---
name: i.eb.deltat
description: Computes the difference of temperature between surface skin temperature and air temperature at 2m as part of sensible heat flux calculations.
keywords: [ imagery, energy balance, SEBAL, SEBS, delta T ]
---

# i.eb.deltat

Computes the difference of temperature between surface skin temperature and air temperature at 2m as part of sensible heat flux calculations.

=== "Command line"

    **i.eb.deltat**
    [**-w**]
    **tempk**=*name*
    **delta**=*name*
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    i.eb.deltat tempk=tempk delta=delta
    ```

=== "Python (grass.script)"

    *grass.script.run_command*("***i.eb.deltat***",
        **tempk**=*"tempk"*,
        **delta**=*"delta"*,
        **flags**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.run_command("i.eb.deltat", tempk="tempk", delta="delta")
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.i_eb_deltat*(**tempk**=*"tempk"*,
        **delta**=*"delta"*,
        **flags**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.i_eb_deltat(tempk="tempk", delta="delta")
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **tempk**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of the surface skin temperature map [Kelvin]  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *tempk*  
    **delta**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of the output delta layer  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *delta*  
    **-w**  
    &nbsp;&nbsp;&nbsp;&nbsp;Wim's generic table  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **tempk** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of the surface skin temperature map [Kelvin]  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *tempk*  
    **delta** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of the output delta layer  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *delta*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *w*  
    &nbsp;&nbsp;&nbsp;&nbsp;**w**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Wim's generic table  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **tempk** : str | np.ndarray, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of the surface skin temperature map [Kelvin]  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *tempk*  
    **delta** : str | np.ndarray, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of the output delta layer  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *delta*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *w*  
    &nbsp;&nbsp;&nbsp;&nbsp;**w**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Wim's generic table  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

*i.eb.deltat* calculates the difference of temperature between two
heights. Generally considered between surface skin temperature and air
temperature \~2m above the skin (soil/canopy/etc). This approximation is
found in Pawan (2004) and is used for initialization of the sensible
heat flux iterations in SEBAL (Bastiaanssen, 1995).

## NOTES

This is found in Pawan (2004). This is the case of a Landsat satellite
image of Oct 8, 2003, located in Portugal. He also mentions a strange
equation for MODIS of January 13, 2003. delta T = -3440.37 +12.18404 \*
LST. Of course the intercept looks like the LST band is still in storage
format (\*10000). Additionally, it is worth menitoning that Pawan only
created this map once, and used it all the time. This is certainly
because he created the relationship from some field data and found it
reliable enough not to modify this parameter anymore, leading to a
simplified iteration process of SEBAL, changing only the rah parameter
through the iterations of H,L,psi,rah.

## TODO

## SEE ALSO

*[i.eb.h0](i.eb.h0.md)*

## AUTHOR

Yann Chemin, Asian Institute of Technology, Thailand

## SOURCE CODE

Available at: [i.eb.deltat source code](https://github.com/OSGeo/grass-addons/tree/grass8/src/imagery/i.eb.deltat)
([history](https://github.com/OSGeo/grass-addons/commits/grass8/src/imagery/i.eb.deltat))  
Latest change: Thursday Feb 20 13:02:26 2025 in commit [53de819](https://github.com/OSGeo/grass-addons/commit/53de8196a10ba5a8a9121898ce87861d227137e3)
