---
name: i.eb.evapfr
description: Computes evaporative fraction and root zone soil moisture.
keywords: [ imagery, energy balance, soil moisture, evaporative fraction, SEBAL ]
---

# i.eb.evapfr

Computes evaporative fraction and root zone soil moisture.

=== "Command line"

    **i.eb.evapfr**
    [**-m**]
    **netradiation**=*name*
    **soilheatflux**=*name*
    **sensibleheatflux**=*name*
    **evaporativefraction**=*name*
    [**soilmoisture**=*name*]
    [**--overwrite**]
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    i.eb.evapfr netradiation=name soilheatflux=name sensibleheatflux=name evaporativefraction=name
    ```

=== "Python (grass.script)"

    *grass.script.run_command*("***i.eb.evapfr***",
        **netradiation**,
        **soilheatflux**,
        **sensibleheatflux**,
        **evaporativefraction**,
        **soilmoisture**=*None*,
        **flags**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.run_command("i.eb.evapfr", netradiation="name", soilheatflux="name", sensibleheatflux="name", evaporativefraction="name")
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.i_eb_evapfr*(**netradiation**,
        **soilheatflux**,
        **sensibleheatflux**,
        **evaporativefraction**,
        **soilmoisture**=*None*,
        **flags**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.i_eb_evapfr(netradiation="name", soilheatflux="name", sensibleheatflux="name", evaporativefraction="name")
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **netradiation**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of Net Radiation raster map [W/m2]  
    **soilheatflux**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of soil heat flux raster map [W/m2]  
    **sensibleheatflux**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of sensible heat flux raster map [W/m2]  
    **evaporativefraction**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output evaporative fraction raster map  
    **soilmoisture**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output root zone soil moisture raster map  
    **-m**  
    &nbsp;&nbsp;&nbsp;&nbsp;Root zone soil moisture output (Makin, Molden and Bastiaanssen, 2001)  
    **--overwrite**  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **netradiation** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of Net Radiation raster map [W/m2]  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **soilheatflux** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of soil heat flux raster map [W/m2]  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **sensibleheatflux** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of sensible heat flux raster map [W/m2]  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **evaporativefraction** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output evaporative fraction raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster, *name*  
    **soilmoisture** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output root zone soil moisture raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster, *name*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *m*  
    &nbsp;&nbsp;&nbsp;&nbsp;**m**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Root zone soil moisture output (Makin, Molden and Bastiaanssen, 2001)  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **netradiation** : str | np.ndarray, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of Net Radiation raster map [W/m2]  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **soilheatflux** : str | np.ndarray, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of soil heat flux raster map [W/m2]  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **sensibleheatflux** : str | np.ndarray, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of sensible heat flux raster map [W/m2]  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **evaporativefraction** : str | type(np.ndarray) | type(np.array) | type(gs.array.array), *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output evaporative fraction raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster, *name*  
    **soilmoisture** : str | type(np.ndarray) | type(np.array) | type(gs.array.array), *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output root zone soil moisture raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster, *name*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *m*  
    &nbsp;&nbsp;&nbsp;&nbsp;**m**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Root zone soil moisture output (Makin, Molden and Bastiaanssen, 2001)  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | np.ndarray | tuple[np.ndarray] | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned. If an array type (e.g., *np.ndarray*) is used for one of the raster outputs, the result will be an array and will have the shape corresponding to the computational region. If an array type is used for more than one raster output, the result will be a tuple of arrays.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

*i.eb.evapfr* calculates the evaporative fraction after Bastiaanssen
1995. The main implementation follows Alexandridis et al. (2009). The
module takes as input the net radiation (see *r.sun*, *i.eb.netrad*),
soil heat flux (see *i.eb.soilheatflux*) and sensible heat flux (see
*i.eb.hsebal01*). A flag adds a root zone empirical soil moisture output
from the article of Bastiaanssen, et al. (2000).

## REFERENCES

Bastiaanssen, W.G.M., 1995. Estimation of Land surface parameters by
remote sensing under clear-sky conditions. PhD thesis, Wageningen
University, Wageningen, The Netherlands.
([PDF](https://edepot.wur.nl/206553))

Bastiaanssen, W.G.M., Molden, D.J., Makin, I.W., 2000. Remote sensing
for irrigated agriculture: examples from research and possible
applications. Agricultural water management 46.2: 137-155.

Chemin Y., Alexandridis T.A., 2001. Improving spatial resolution of ET
seasonal for irrigated rice in Zhanghe, China. Asian Journal of
Geoinformatics. 5(1):3-11.

Alexandridis T.K., Cherif I., Chemin Y., Silleos N.G., Stavrinos E.,
Zalidis G.C., 2009. Integrated methodology for estimating water use in
Mediterranean agricultural areas. Remote Sensing. 1, 445-465.
([PDF](https://doi.org/10.3390/rs1030445))

Chemin, Y., 2012. A Distributed Benchmarking Framework for Actual ET
Models, in: Irmak, A. (Ed.), Evapotranspiration - Remote Sensing and
Modeling. InTech. ([PDF](https://www.intechopen.com/chapters/26115))

## SEE ALSO

*[i.eb.hsebal01](i.eb.hsebal01.md), [i.eb.netrad](i.eb.netrad.md),
[i.eb.soilheatflux](i.eb.soilheatflux.md), [r.sun](r.sun.md)*

## AUTHOR

Yann Chemin, Asian Institute of Technology, Thailand

## SOURCE CODE

Available at: [i.eb.evapfr source code](https://github.com/OSGeo/grass/tree/main/imagery/i.eb.evapfr)
([history](https://github.com/OSGeo/grass/commits/main/imagery/i.eb.evapfr))  
Latest change: Wednesday May 07 12:54:49 2025 in commit [6b2b255](https://github.com/OSGeo/grass/commit/6b2b2553b3c72a32fb9c4ee6ba3110239c361f10)
