---
name: i.eb.soilheatflux
description: Soil heat flux approximation (Bastiaanssen, 1995).
keywords: [ imagery, energy balance, soil heat flux, SEBAL ]
---

# i.eb.soilheatflux

Soil heat flux approximation (Bastiaanssen, 1995).

=== "Command line"

    **i.eb.soilheatflux**
    [**-r**]
    **albedo**=*name*
    **ndvi**=*name*
    **temperature**=*name*
    **netradiation**=*name*
    **localutctime**=*name*
    **output**=*name*
    [**--overwrite**]
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    i.eb.soilheatflux albedo=name ndvi=name temperature=name netradiation=name localutctime=name output=name
    ```

=== "Python (grass.script)"

    *grass.script.run_command*("***i.eb.soilheatflux***",
        **albedo**,
        **ndvi**,
        **temperature**,
        **netradiation**,
        **localutctime**,
        **output**,
        **flags**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.run_command("i.eb.soilheatflux", albedo="name", ndvi="name", temperature="name", netradiation="name", localutctime="name", output="name")
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.i_eb_soilheatflux*(**albedo**,
        **ndvi**,
        **temperature**,
        **netradiation**,
        **localutctime**,
        **output**,
        **flags**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.i_eb_soilheatflux(albedo="name", ndvi="name", temperature="name", netradiation="name", localutctime="name", output="name")
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **albedo**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of albedo raster map [0.0;1.0]  
    **ndvi**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of NDVI raster map [-1.0;+1.0]  
    **temperature**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of Surface temperature raster map [K]  
    **netradiation**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of Net Radiation raster map [W/m2]  
    **localutctime**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of time of satellite overpass raster map [local time in UTC]  
    **output**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output raster map  
    **-r**  
    &nbsp;&nbsp;&nbsp;&nbsp;HAPEX-Sahel empirical correction (Roerink, 1995)  
    **--overwrite**  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **albedo** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of albedo raster map [0.0;1.0]  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **ndvi** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of NDVI raster map [-1.0;+1.0]  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **temperature** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of Surface temperature raster map [K]  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **netradiation** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of Net Radiation raster map [W/m2]  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **localutctime** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of time of satellite overpass raster map [local time in UTC]  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **output** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster, *name*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *r*  
    &nbsp;&nbsp;&nbsp;&nbsp;**r**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;HAPEX-Sahel empirical correction (Roerink, 1995)  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **albedo** : str | np.ndarray, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of albedo raster map [0.0;1.0]  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **ndvi** : str | np.ndarray, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of NDVI raster map [-1.0;+1.0]  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **temperature** : str | np.ndarray, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of Surface temperature raster map [K]  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **netradiation** : str | np.ndarray, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of Net Radiation raster map [W/m2]  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **localutctime** : str | np.ndarray, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of time of satellite overpass raster map [local time in UTC]  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **output** : str | type(np.ndarray) | type(np.array) | type(gs.array.array), *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster, *name*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *r*  
    &nbsp;&nbsp;&nbsp;&nbsp;**r**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;HAPEX-Sahel empirical correction (Roerink, 1995)  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | np.ndarray | tuple[np.ndarray] | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned. If an array type (e.g., *np.ndarray*) is used for one of the raster outputs, the result will be an array and will have the shape corresponding to the computational region. If an array type is used for more than one raster output, the result will be a tuple of arrays.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

*i.eb.soilheatflux* calculates the soil heat flux approximation (g0)
after Bastiaanssen (1995). The main reference for implementation is
Alexandridis, 2009. It takes input of Albedo, NDVI, Surface Skin
temperature, Net Radiation (see *r.sun*), time of satellite overpass,
and a flag for the Roerink empirical modification from the HAPEX-Sahel
experiment. The "time of satellite overpass" map can be obtained as
follows:

- MODIS: a related sub dataset is included in each HDF file, and simply
  to be imported as a raster map;
- Landsat: to be generated as map from the overpass time stored in the
  metadata file (given in Greenwich Mean Time - GMT), see below.

For Landsat, the overpass map can be computed by using a two-step
method:

```sh
# 1) extract the overpass time in GMT from metadata file

i.landsat.toar -p input=dummy output=dummy2 \
   metfile=LC81250452013338LGN00_MTL.txt lsatmet=time
# ... in this example approx. 03:12am GMT

# 2) create map for computational region of Landsat scene
g.region rast=LC81250452013338LGN00_B4 -p
r.mapcalc "overpasstime = 3.211328"
```

## REFERENCES

Bastiaanssen, W.G.M., 1995. Estimation of Land surface parameters by
remote sensing under clear-sky conditions. PhD thesis, Wageningen
University, Wageningen, The Netherlands.
([PDF](https://edepot.wur.nl/206553))

Chemin Y., Alexandridis T.A., 2001. Improving spatial resolution of ET
seasonal for irrigated rice in Zhanghe, China. Asian Journal of
Geoinformatics. 5(1):3-11,2004.

Alexandridis T.K., Cherif I., Chemin Y., Silleos N.G., Stavrinos E.,
Zalidis G.C. Integrated methodology for estimating water use in
Mediterranean agricultural areas. Remote Sensing. 2009, 1, 445-465.
([PDF](https://doi.org/10.3390/rs1030445))

Chemin, Y., 2012. A Distributed Benchmarking Framework for Actual ET
Models, in: Irmak, A. (Ed.), Evapotranspiration - Remote Sensing and
Modeling. InTech. ([PDF](https://www.intechopen.com/chapters/26115))

## SEE ALSO

*[r.sun](r.sun.md), [i.albedo](i.albedo.md),
[i.emissivity](i.emissivity.md), [i.eb.hsebal01](i.eb.hsebal01.md),
[i.eb.evapfr](i.eb.evapfr.md) [i.landsat.toar](i.landsat.toar.md)*

## AUTHOR

Yann Chemin, Asian Institute of Technology, Thailand

## SOURCE CODE

Available at: [i.eb.soilheatflux source code](https://github.com/OSGeo/grass/tree/main/imagery/i.eb.soilheatflux)
([history](https://github.com/OSGeo/grass/commits/main/imagery/i.eb.soilheatflux))  
Latest change: Tuesday Jun 24 19:50:46 2025 in commit [48219eb](https://github.com/OSGeo/grass/commit/48219eb35dc74b741d553152a17f70b0070e37e1)
