---
name: i.evapo.potrad
description: Potential evapotranspiration, radiative method after Bastiaanssen (1995)
keywords: [ Potential ET, evapotranspiration ]
---

# i.evapo.potrad

Potential evapotranspiration, radiative method after Bastiaanssen (1995)

=== "Command line"

    **i.evapo.potrad**
    [**-rdb**]
    **albedo**=*name*
    **temperature**=*name*
    **latitude**=*name*
    **dayofyear**=*name*
    **transmissivitysingleway**=*name*
    **waterdensity**=*float*
    [**slope**=*name*]
    [**aspect**=*name*]
    [**atmosphericemissivity**=*float*]
    [**airtemperature**=*name*]
    [**surfaceemissivity**=*name*]
    **output**=*name*
    [**rnetd**=*name*]
    [**--overwrite**]
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    i.evapo.potrad albedo=name temperature=name latitude=name dayofyear=name transmissivitysingleway=name waterdensity=1005.0 output=name
    ```

=== "Python (grass.script)"

    *grass.script.run_command*("***i.evapo.potrad***",
        **albedo**,
        **temperature**,
        **latitude**,
        **dayofyear**,
        **transmissivitysingleway**,
        **waterdensity**=*1005.0*,
        **slope**=*None*,
        **aspect**=*None*,
        **atmosphericemissivity**=*0.845*,
        **airtemperature**=*None*,
        **surfaceemissivity**=*None*,
        **output**,
        **rnetd**=*None*,
        **flags**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.run_command("i.evapo.potrad", albedo="name", temperature="name", latitude="name", dayofyear="name", transmissivitysingleway="name", waterdensity=1005.0, output="name")
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.i_evapo_potrad*(**albedo**,
        **temperature**,
        **latitude**,
        **dayofyear**,
        **transmissivitysingleway**,
        **waterdensity**=*1005.0*,
        **slope**=*None*,
        **aspect**=*None*,
        **atmosphericemissivity**=*0.845*,
        **airtemperature**=*None*,
        **surfaceemissivity**=*None*,
        **output**,
        **rnetd**=*None*,
        **flags**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.i_evapo_potrad(albedo="name", temperature="name", latitude="name", dayofyear="name", transmissivitysingleway="name", waterdensity=1005.0, output="name")
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **albedo**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of the Albedo layer [0.0-1.0]  
    **temperature**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of the temperature layer [Degree Kelvin]  
    **latitude**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of the degree latitude layer [dd.ddd]  
    **dayofyear**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of the Day of Year layer [0.0-366.0]  
    **transmissivitysingleway**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of the single-way transmissivity layer [0.05-1.0], defaults to 1.0 if no input file  
    **waterdensity**=*float* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Value of the density of fresh water ~[1000-1020]  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1005.0*  
    **slope**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of the Slope layer ~[0-90]  
    **aspect**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of the Aspect layer ~[0-360]  
    **atmosphericemissivity**=*float*  
    &nbsp;&nbsp;&nbsp;&nbsp;Value of the apparent atmospheric emissivity (Bandara, 1998 used 0.845 for Sri Lanka)  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0.845*  
    **airtemperature**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of the Air Temperature layer [Kelvin], use with -b  
    **surfaceemissivity**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of the Surface Emissivity layer [-], use with -b  
    **output**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;OUTPUT: Name of the Potential ET layer  
    **rnetd**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;OUTPUT: Name of the Diurnal Net Radiation layer  
    **-r**  
    &nbsp;&nbsp;&nbsp;&nbsp;Output Diurnal Net Radiation (for i.eb.eta)  
    **-d**  
    &nbsp;&nbsp;&nbsp;&nbsp;Slope/Aspect correction  
    **-b**  
    &nbsp;&nbsp;&nbsp;&nbsp;Net Radiation Bandara (1998), generic Longwave calculation, need apparent atmospheric emissivity, Air temperature and surface emissivity inputs  
    **--overwrite**  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **albedo** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of the Albedo layer [0.0-1.0]  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **temperature** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of the temperature layer [Degree Kelvin]  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **latitude** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of the degree latitude layer [dd.ddd]  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **dayofyear** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of the Day of Year layer [0.0-366.0]  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **transmissivitysingleway** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of the single-way transmissivity layer [0.05-1.0], defaults to 1.0 if no input file  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **waterdensity** : float, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Value of the density of fresh water ~[1000-1020]  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as:   
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1005.0*  
    **slope** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of the Slope layer ~[0-90]  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **aspect** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of the Aspect layer ~[0-360]  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **atmosphericemissivity** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Value of the apparent atmospheric emissivity (Bandara, 1998 used 0.845 for Sri Lanka)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as:   
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0.845*  
    **airtemperature** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of the Air Temperature layer [Kelvin], use with -b  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **surfaceemissivity** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of the Surface Emissivity layer [-], use with -b  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **output** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;OUTPUT: Name of the Potential ET layer  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster, *name*  
    **rnetd** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;OUTPUT: Name of the Diurnal Net Radiation layer  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster, *name*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *r*, *d*, *b*  
    &nbsp;&nbsp;&nbsp;&nbsp;**r**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Output Diurnal Net Radiation (for i.eb.eta)  
    &nbsp;&nbsp;&nbsp;&nbsp;**d**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Slope/Aspect correction  
    &nbsp;&nbsp;&nbsp;&nbsp;**b**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Net Radiation Bandara (1998), generic Longwave calculation, need apparent atmospheric emissivity, Air temperature and surface emissivity inputs  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **albedo** : str | np.ndarray, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of the Albedo layer [0.0-1.0]  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **temperature** : str | np.ndarray, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of the temperature layer [Degree Kelvin]  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **latitude** : str | np.ndarray, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of the degree latitude layer [dd.ddd]  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **dayofyear** : str | np.ndarray, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of the Day of Year layer [0.0-366.0]  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **transmissivitysingleway** : str | np.ndarray, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of the single-way transmissivity layer [0.05-1.0], defaults to 1.0 if no input file  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **waterdensity** : float, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Value of the density of fresh water ~[1000-1020]  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as:   
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1005.0*  
    **slope** : str | np.ndarray, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of the Slope layer ~[0-90]  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **aspect** : str | np.ndarray, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of the Aspect layer ~[0-360]  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **atmosphericemissivity** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Value of the apparent atmospheric emissivity (Bandara, 1998 used 0.845 for Sri Lanka)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as:   
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0.845*  
    **airtemperature** : str | np.ndarray, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of the Air Temperature layer [Kelvin], use with -b  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **surfaceemissivity** : str | np.ndarray, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of the Surface Emissivity layer [-], use with -b  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **output** : str | type(np.ndarray) | type(np.array) | type(gs.array.array), *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;OUTPUT: Name of the Potential ET layer  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster, *name*  
    **rnetd** : str | type(np.ndarray) | type(np.array) | type(gs.array.array), *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;OUTPUT: Name of the Diurnal Net Radiation layer  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster, *name*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *r*, *d*, *b*  
    &nbsp;&nbsp;&nbsp;&nbsp;**r**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Output Diurnal Net Radiation (for i.eb.eta)  
    &nbsp;&nbsp;&nbsp;&nbsp;**d**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Slope/Aspect correction  
    &nbsp;&nbsp;&nbsp;&nbsp;**b**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Net Radiation Bandara (1998), generic Longwave calculation, need apparent atmospheric emissivity, Air temperature and surface emissivity inputs  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | np.ndarray | tuple[np.ndarray] | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned. If an array type (e.g., *np.ndarray*) is used for one of the raster outputs, the result will be an array and will have the shape corresponding to the computational region. If an array type is used for more than one raster output, the result will be a tuple of arrays.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

*i.evapo.potrad* calculates the diurnal potential evapotranspiration
after Bastiaanssen (1995). This is converting all Net radiation from the
diurnal period into ET. It takes input maps of Albedo, surface skin
temperature, latitude, day of year, single-way transmissivity and takes
input value of the density of fresh water. The "-r" flag permits output
map of Diurnal net radiation to use in r.eb.eta. The "-b" flag permits a
generic longwave balance calculation from surface emissivity, Air
Temperature and a value of apparent atmospheric emissivity. The "-d"
flag is a slope/aspect correction, not really tested, reports and tests
are most welcome.

## NOTES

## TODO

Slope/aspect correction to be screened and tested by somebody in the
known.

## SEE ALSO

*[r.sun](https://grass.osgeo.org/grass-stable/manuals/r.sun.html),
[i.albedo](https://grass.osgeo.org/grass-stable/manuals/i.albedo.html),
[i.eb.eta](https://grass.osgeo.org/grass-stable/manuals/i.eb.eta.html)*

## REFERENCES

- Bastiaanssen, W.G.M., 1995. Regionalization of surface flux
    densities and moisture indicators in composite terrain; a remote
    sensing approach under clear skies in mediterranean climates. PhD
    thesis, Wageningen Agricultural Univ., The Netherland, 271 pp.
    ([PDF](https://edepot.wur.nl/206553))
- Chemin, Y., 2012. A Distributed Benchmarking Framework for Actual ET
    Models, in: Irmak, A. (Ed.), Evapotranspiration - Remote Sensing and
    Modeling. InTech.
    ([PDF](https://www.intechopen.com/books/evapotranspiration-remote-sensing-and-modeling/a-distributed-benchmarking-framework-for-actual-et-models),
    [DOI: 10.5772/23571](https://doi.org/10.5772/23571))

## AUTHOR

Yann Chemin, International Rice Research Institute, The Philippines

## SOURCE CODE

Available at: [i.evapo.potrad source code](https://github.com/OSGeo/grass-addons/tree/grass8/src/imagery/i.evapo.potrad)
([history](https://github.com/OSGeo/grass-addons/commits/grass8/src/imagery/i.evapo.potrad))  
Latest change: Friday Feb 21 10:10:05 2025 in commit [7d78fe3](https://github.com/OSGeo/grass-addons/commit/7d78fe34868674c3b6050ba1924e1c5675d155c9)
