---
name: i.fusion.hpf.py
description: Fusing high resolution panchromatic and low resolution multi-spectral data based on the High-Pass Filter Addition technique (Gangkofner, 2008).
keywords: [ imagery, fusion, sharpening, high pass filter, HPFA ]
---

# i.fusion.hpf.py

Fusing high resolution panchromatic and low resolution multi-spectral data based on the High-Pass Filter Addition technique (Gangkofner, 2008).

=== "Command line"

    **i.fusion.hpf.py**
    [**-l2ca**]
    **pan**=*name*
    **msx**=*name* [,*name*,...]
    **suffix**=*basename*
    [**ratio**=*float*]
    [**center**=*string*]
    [**center2**=*string*]
    [**modulation**=*string*]
    [**modulation2**=*string*]
    [**trim**=*float*]
    [**--overwrite**]
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    i.fusion.hpf.py pan=name msx=name suffix=hpf
    ```

=== "Python (grass.script)"

    *grass.script.run_command*("***i.fusion.hpf.py***",
        **pan**,
        **msx**,
        **suffix**=*"hpf"*,
        **ratio**=*None*,
        **center**=*"low"*,
        **center2**=*"low"*,
        **modulation**=*"mid"*,
        **modulation2**=*"mid"*,
        **trim**=*None*,
        **flags**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.run_command("i.fusion.hpf.py", pan="name", msx="name", suffix="hpf")
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.i_fusion_hpf_py*(**pan**,
        **msx**,
        **suffix**=*"hpf"*,
        **ratio**=*None*,
        **center**=*"low"*,
        **center2**=*"low"*,
        **modulation**=*"mid"*,
        **modulation2**=*"mid"*,
        **trim**=*None*,
        **flags**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.i_fusion_hpf_py(pan="name", msx="name", suffix="hpf")
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **pan**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;High resolution Panchromatic image  
    **msx**=*name* [,*name*,...] **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Low resolution Multi-Spectral image(s)  
    **suffix**=*basename* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Suffix for output image(s)  
    &nbsp;&nbsp;&nbsp;&nbsp;Names of Pan-Sharpened image(s) will end with this suffix  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *hpf*  
    **ratio**=*float*  
    &nbsp;&nbsp;&nbsp;&nbsp;Custom ratio  
    &nbsp;&nbsp;&nbsp;&nbsp;Custom ratio overriding standard calculation  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *1.0-10.0*  
    **center**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Center cell value  
    &nbsp;&nbsp;&nbsp;&nbsp;Center cell value of the High-Pass-Filter  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *low, mid, high*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *low*  
    **center2**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;2nd Pass center cell value  
    &nbsp;&nbsp;&nbsp;&nbsp;Center cell value for the second High-Pass-Filter (use -2 flag)  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *low, mid, high*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *low*  
    **modulation**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Modulation level  
    &nbsp;&nbsp;&nbsp;&nbsp;Modulation level weighting the HPF image determining crispness  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *min, mid, max*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *mid*  
    **modulation2**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;2nd Pass modulation level (use -2 flag)  
    &nbsp;&nbsp;&nbsp;&nbsp;Modulation level weighting the second HPF image determining crispness (use -2 flag)  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *min, mid, max*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *mid*  
    &nbsp;&nbsp;&nbsp;&nbsp;**min**: Minimum: 0.25  
    &nbsp;&nbsp;&nbsp;&nbsp;**mid**: Mid: 0.35  
    &nbsp;&nbsp;&nbsp;&nbsp;**max**: Maximum: 0.5  
    **trim**=*float*  
    &nbsp;&nbsp;&nbsp;&nbsp;Trimming factor  
    &nbsp;&nbsp;&nbsp;&nbsp;Trim output border pixels by a factor of the pixel size of the low resolution image. A factor of 1.0 may suffice.  
    **-l**  
    &nbsp;&nbsp;&nbsp;&nbsp;Linearly match histogram of Pan-sharpened output to Multi-Spectral input  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: Quantile scaling  
    **-2**  
    &nbsp;&nbsp;&nbsp;&nbsp;2-Pass Processing (recommended) for large resolution ratio (&gt;=5.5)  
    **-c**  
    &nbsp;&nbsp;&nbsp;&nbsp;Match color table of Pan-Sharpened output to Multi-Spectral input  
    **-a**  
    &nbsp;&nbsp;&nbsp;&nbsp;Align output to pan band  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: set resolution from pan band  
    **--overwrite**  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **pan** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;High resolution Panchromatic image  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **msx** : str | list[str], *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Low resolution Multi-Spectral image(s)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **suffix** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Suffix for output image(s)  
    &nbsp;&nbsp;&nbsp;&nbsp;Names of Pan-Sharpened image(s) will end with this suffix  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster, *basename*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *hpf*  
    **ratio** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Custom ratio  
    &nbsp;&nbsp;&nbsp;&nbsp;Custom ratio overriding standard calculation  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *1.0-10.0*  
    **center** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Center cell value  
    &nbsp;&nbsp;&nbsp;&nbsp;Center cell value of the High-Pass-Filter  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *low, mid, high*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *low*  
    **center2** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;2nd Pass center cell value  
    &nbsp;&nbsp;&nbsp;&nbsp;Center cell value for the second High-Pass-Filter (use -2 flag)  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *low, mid, high*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *low*  
    **modulation** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Modulation level  
    &nbsp;&nbsp;&nbsp;&nbsp;Modulation level weighting the HPF image determining crispness  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *min, mid, max*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *mid*  
    **modulation2** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;2nd Pass modulation level (use -2 flag)  
    &nbsp;&nbsp;&nbsp;&nbsp;Modulation level weighting the second HPF image determining crispness (use -2 flag)  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *min, mid, max*  
    &nbsp;&nbsp;&nbsp;&nbsp;**min**: Minimum: 0.25  
    &nbsp;&nbsp;&nbsp;&nbsp;**mid**: Mid: 0.35  
    &nbsp;&nbsp;&nbsp;&nbsp;**max**: Maximum: 0.5  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *mid*  
    **trim** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Trimming factor  
    &nbsp;&nbsp;&nbsp;&nbsp;Trim output border pixels by a factor of the pixel size of the low resolution image. A factor of 1.0 may suffice.  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *l*, *2*, *c*, *a*  
    &nbsp;&nbsp;&nbsp;&nbsp;**l**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Linearly match histogram of Pan-sharpened output to Multi-Spectral input  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Default: Quantile scaling  
    &nbsp;&nbsp;&nbsp;&nbsp;**2**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;2-Pass Processing (recommended) for large resolution ratio (&gt;=5.5)  
    &nbsp;&nbsp;&nbsp;&nbsp;**c**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Match color table of Pan-Sharpened output to Multi-Spectral input  
    &nbsp;&nbsp;&nbsp;&nbsp;**a**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Align output to pan band  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Default: set resolution from pan band  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **pan** : str | np.ndarray, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;High resolution Panchromatic image  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **msx** : str | list[str], *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Low resolution Multi-Spectral image(s)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **suffix** : str | type(np.ndarray) | type(np.array) | type(gs.array.array), *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Suffix for output image(s)  
    &nbsp;&nbsp;&nbsp;&nbsp;Names of Pan-Sharpened image(s) will end with this suffix  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster, *basename*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *hpf*  
    **ratio** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Custom ratio  
    &nbsp;&nbsp;&nbsp;&nbsp;Custom ratio overriding standard calculation  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *1.0-10.0*  
    **center** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Center cell value  
    &nbsp;&nbsp;&nbsp;&nbsp;Center cell value of the High-Pass-Filter  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *low, mid, high*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *low*  
    **center2** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;2nd Pass center cell value  
    &nbsp;&nbsp;&nbsp;&nbsp;Center cell value for the second High-Pass-Filter (use -2 flag)  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *low, mid, high*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *low*  
    **modulation** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Modulation level  
    &nbsp;&nbsp;&nbsp;&nbsp;Modulation level weighting the HPF image determining crispness  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *min, mid, max*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *mid*  
    **modulation2** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;2nd Pass modulation level (use -2 flag)  
    &nbsp;&nbsp;&nbsp;&nbsp;Modulation level weighting the second HPF image determining crispness (use -2 flag)  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *min, mid, max*  
    &nbsp;&nbsp;&nbsp;&nbsp;**min**: Minimum: 0.25  
    &nbsp;&nbsp;&nbsp;&nbsp;**mid**: Mid: 0.35  
    &nbsp;&nbsp;&nbsp;&nbsp;**max**: Maximum: 0.5  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *mid*  
    **trim** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Trimming factor  
    &nbsp;&nbsp;&nbsp;&nbsp;Trim output border pixels by a factor of the pixel size of the low resolution image. A factor of 1.0 may suffice.  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *l*, *2*, *c*, *a*  
    &nbsp;&nbsp;&nbsp;&nbsp;**l**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Linearly match histogram of Pan-sharpened output to Multi-Spectral input  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Default: Quantile scaling  
    &nbsp;&nbsp;&nbsp;&nbsp;**2**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;2-Pass Processing (recommended) for large resolution ratio (&gt;=5.5)  
    &nbsp;&nbsp;&nbsp;&nbsp;**c**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Match color table of Pan-Sharpened output to Multi-Spectral input  
    &nbsp;&nbsp;&nbsp;&nbsp;**a**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Align output to pan band  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Default: set resolution from pan band  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | np.ndarray | tuple[np.ndarray] | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned. If an array type (e.g., *np.ndarray*) is used for one of the raster outputs, the result will be an array and will have the shape corresponding to the computational region. If an array type is used for more than one raster output, the result will be a tuple of arrays.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

*i.fusion.hpf* is an implementation of the High Pass Filter Additive
(HPFA) Fusion Technique. It combines high-resolution panchromatic data
with lower resolution multispectral data, resulting in an output with
both excellent detail and a realistic representation of original
multispectral scene colors. The process involves a convolution using a
High Pass Filter (HPF) on the high resolution data, then combining this
with the lower resolution multispectral data. Optionally, a linear
histogram matching technique is performed in a way that matches the
resulting Pan-Sharpened image to the statistical mean and standard
deviation of the original multi-spectral image.

### Background

1. Computing ratio of low (Multi-Spectral) to high (Panchromatic)
    resolutions
2. High Pass Filtering the Panchromatic Image
3. Resampling MSX image to the higher resolution
4. Adding weighted High-Pass-Filetred image to the upsampled MSX image
5. Optionally, matching histogram of Pansharpened image to the one of
    the original MSX image

```text
Figure:
 ____________________________________________________________________________
+                                                                            +
| Pan Img ->  High Pass Filter  ->  HP Img                                   |
|                                      |                                     |
|                                      v                                     |
| MSx Img ->  Weighting Factors ->  Weighted HP Img                          |
|       |                              |                                     |
|       |                              v                                     |
|       +------------------------>  Addition to MSx Img  =>  Fused MSx Image |
+____________________________________________________________________________+

```

Source: Gangkofner, 2008

## NOTES

- Grasping and testing the various parameters that define the
    High-Pass filter's kernel size and center value is a matter of short
    time.
- Works with any number and type of raster imagery (8-bit, 16-bit)
- The "black border" effect, possibly caused due to a non-perfect
    match of the high vs. the low resolution of the input images, can be
    trimmed out by using the `trim` option --a floating point "trimming
    factor" with which to multiply the pixel size of the low resolution
    image-- and shrink the extent of the output image.

## EXAMPLE

The module is fairly easy to use. Arbitrary examples:

### Pansharpening of one band

```sh
i.fusion.hpf pan=Panchromatic msx=Red
```

### Pansharpening of multiple bands

```sh
i.fusion.hpf pan=Panchromatic msx=Red,Green,Blue,NIR
```

### North Carolina: pansharpening of multiple bands

Example using the North Carolina sample dataset, `landsat` mapset:

```sh
# pansharpening of R, G, B, NIR
g.region raster=lsat7_2002_80 -p
i.fusion.hpf pan=lsat7_2000_80 msx=lsat7_2000_10,lsat7_2000_20,lsat7_2000_30,lsat7_2000_40 suffix=_hpf

# visual comparison
d.mon wx0
d.rgb b=lsat7_2000_10 g=lsat7_2000_20 r=lsat7_2000_30

# color balance pansharpened scene
i.colors.enhance b=lsat7_2000_10_hpf g=lsat7_2000_20_hpf r=lsat7_2000_30_hpf
d.rgb b=lsat7_2000_10_hpf g=lsat7_2000_20_hpf r=lsat7_2000_30_hpf
```

![image-alt](i_fusion_hpf_lsat7_orig_rgb.png)  
*Figure: Original Landsat 7 RGB color composite at 28.5m resolution
(North Carolina, Raleigh subset)*

![image-alt](i_fusion_hpf_lsat7_hpf_rgb.png)  
*Figure: Pansharpened Landsat 7 RGB color composite at 14.25m
resolution(North Carolina, Raleigh subset)*

### Further examples

Various illustrated examples detailed in the document [i.fusion.hpf,
implementation of the High Pass Filter Additive (HPFA) Image Fusion
Technique](https://gitlab.com/NikosAlexandris/i.fusion.hpf/blob/master/Documentation.pdf)
(PDF)

## TODO

- Go through [Submitting
    Python](https://trac.osgeo.org/grass/wiki/Submitting/Python)
- Access input raster by row I/O
- Support for parallel processing
- Proper command history tracking.
- Add timestamps (r.timestamp, temporal framework)
- Deduplicate code where applicable
- Make verbose level messages shorter, yet more informative (ie report
    center cell)
- Test if it compiles in other systems
- Check options to integrate in
    [i.pansharpen](https://grass.osgeo.org/grass-stable/manuals/i.pansharpen.html).
    Think of FFM methods vs. Others?
- Improve Documentation.lyx

## REFERENCES

- Gangkofner, U. G., Pradhan, P. S., and Holcomb, D. W. (2008).
    Optimizing the high-pass filter addition technique for image fusion.
    PHOTOGRAMMETRIC ENGINEERING & REMOTE SENSING, 74(9):1107--1118.
- "ERDAS IMAGINE." Accessed March 19, 2015. [ERDAS IMAGINE
    Help](http://doc.hexagongeospatial.com/ERDAS-IMAGINE/ERDAS_IMAGINE_Help/#ii_hpfmerge_mergedialog.htm).
- Aniruddha Ghosh & P.K. Joshi (2013) Assessment of pan-sharpened very
    high-resolution WorldView-2 images, International Journal of Remote
    Sensing, 34:23, 8336-8359

## SEE ALSO

*[i.pansharpen](https://grass.osgeo.org/grass-stable/manuals/i.pansharpen.html)*

## AUTHORS

Nikos Alexandris  
Panagiotis Mavrogiorgos

## SOURCE CODE

Available at: [i.fusion.hpf source code](https://github.com/OSGeo/grass-addons/tree/grass8/src/imagery/i.fusion.hpf)
([history](https://github.com/OSGeo/grass-addons/commits/grass8/src/imagery/i.fusion.hpf))  
Latest change: Thursday Mar 20 21:36:57 2025 in commit [7286ecf](https://github.com/OSGeo/grass-addons/commit/7286ecf7af235bfd089fb9b1b82fb383cf95f3fc)
