---
name: i.image.bathymetry.py
description: Estimates Satellite Derived Bathymetry (SDB) from multispectral images.
keywords: [ imagery, bathymetry, satellite ]
---

# i.image.bathymetry.py

Estimates Satellite Derived Bathymetry (SDB) from multispectral images.

=== "Command line"

    **i.image.bathymetry.py**
    [**-fb**]
    [**blue_band**=*name*]
    **green_band**=*name*
    **red_band**=*name*
    **nir_band**=*name*
    **band_for_correction**=*name*
    **calibration_points**=*name*
    [**area_of_interest**=*name*]
    [**additional_band1**=*name*]
    [**additional_band2**=*name*]
    [**additional_band3**=*name*]
    [**additional_band4**=*name*]
    **depth_estimate**=*name*
    [**tide_height**=*float*]
    **calibration_column**=*name*
    [**--overwrite**]
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    i.image.bathymetry.py green_band=name red_band=name nir_band=name band_for_correction=name calibration_points=name depth_estimate=name calibration_column=name
    ```

=== "Python (grass.script)"

    *grass.script.run_command*("***i.image.bathymetry.py***",
        **blue_band**=*None*,
        **green_band**,
        **red_band**,
        **nir_band**,
        **band_for_correction**,
        **calibration_points**,
        **area_of_interest**=*None*,
        **additional_band1**=*None*,
        **additional_band2**=*None*,
        **additional_band3**=*None*,
        **additional_band4**=*None*,
        **depth_estimate**,
        **tide_height**=*None*,
        **calibration_column**,
        **flags**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.run_command("i.image.bathymetry.py", green_band="name", red_band="name", nir_band="name", band_for_correction="name", calibration_points="name", depth_estimate="name", calibration_column="name")
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.i_image_bathymetry_py*(**blue_band**=*None*,
        **green_band**,
        **red_band**,
        **nir_band**,
        **band_for_correction**,
        **calibration_points**,
        **area_of_interest**=*None*,
        **additional_band1**=*None*,
        **additional_band2**=*None*,
        **additional_band3**=*None*,
        **additional_band4**=*None*,
        **depth_estimate**,
        **tide_height**=*None*,
        **calibration_column**,
        **flags**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.i_image_bathymetry_py(green_band="name", red_band="name", nir_band="name", band_for_correction="name", calibration_points="name", depth_estimate="name", calibration_column="name")
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **blue_band**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input raster map  
    **green_band**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input raster map  
    **red_band**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input raster map  
    **nir_band**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input raster map  
    **band_for_correction**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input raster map  
    **calibration_points**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input vector map  
    &nbsp;&nbsp;&nbsp;&nbsp;Or data source for direct OGR access  
    **area_of_interest**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input vector map  
    &nbsp;&nbsp;&nbsp;&nbsp;Or data source for direct OGR access  
    **additional_band1**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input raster map  
    **additional_band2**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input raster map  
    **additional_band3**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input raster map  
    **additional_band4**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input raster map  
    **depth_estimate**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output raster map  
    **tide_height**=*float*  
    &nbsp;&nbsp;&nbsp;&nbsp;Tide correction to the time of satellite image capture  
    **calibration_column**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of the column which stores depth values  
    **-f**  
    &nbsp;&nbsp;&nbsp;&nbsp;select if only want to run Fixed-GWR model  
    **-b**  
    &nbsp;&nbsp;&nbsp;&nbsp;select kernel function as bi-square  
    **--overwrite**  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **blue_band** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **green_band** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **red_band** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **nir_band** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **band_for_correction** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **calibration_points** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input vector map  
    &nbsp;&nbsp;&nbsp;&nbsp;Or data source for direct OGR access  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, vector, *name*  
    **area_of_interest** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input vector map  
    &nbsp;&nbsp;&nbsp;&nbsp;Or data source for direct OGR access  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, vector, *name*  
    **additional_band1** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **additional_band2** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **additional_band3** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **additional_band4** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **depth_estimate** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster, *name*  
    **tide_height** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Tide correction to the time of satellite image capture  
    **calibration_column** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of the column which stores depth values  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, dbcolumn, *name*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *f*, *b*  
    &nbsp;&nbsp;&nbsp;&nbsp;**f**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;select if only want to run Fixed-GWR model  
    &nbsp;&nbsp;&nbsp;&nbsp;**b**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;select kernel function as bi-square  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **blue_band** : str | np.ndarray, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **green_band** : str | np.ndarray, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **red_band** : str | np.ndarray, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **nir_band** : str | np.ndarray, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **band_for_correction** : str | np.ndarray, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **calibration_points** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input vector map  
    &nbsp;&nbsp;&nbsp;&nbsp;Or data source for direct OGR access  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, vector, *name*  
    **area_of_interest** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input vector map  
    &nbsp;&nbsp;&nbsp;&nbsp;Or data source for direct OGR access  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, vector, *name*  
    **additional_band1** : str | np.ndarray, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **additional_band2** : str | np.ndarray, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **additional_band3** : str | np.ndarray, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **additional_band4** : str | np.ndarray, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **depth_estimate** : str | type(np.ndarray) | type(np.array) | type(gs.array.array), *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster, *name*  
    **tide_height** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Tide correction to the time of satellite image capture  
    **calibration_column** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of the column which stores depth values  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, dbcolumn, *name*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *f*, *b*  
    &nbsp;&nbsp;&nbsp;&nbsp;**f**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;select if only want to run Fixed-GWR model  
    &nbsp;&nbsp;&nbsp;&nbsp;**b**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;select kernel function as bi-square  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | np.ndarray | tuple[np.ndarray] | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned. If an array type (e.g., *np.ndarray*) is used for one of the raster outputs, the result will be an array and will have the shape corresponding to the computational region. If an array type is used for more than one raster output, the result will be a tuple of arrays.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

*i.image.bathymetry* is used to estimate Satellite-Derived Bathymetry
(SDB). Module estimates bathymetry over near-shore region using limited
reference depth points. The maximum depth can be estimated by the module
is depending up on many factors such as quality of the water, suspended
materials etc.,(Lyzenga et al., 2006, Kanno and Tanaka, 2012). Our
experiments with several multispectral optical images indicate that the
depth estimates are reliable for when water column is below 20 meter.  
  
Delineation of land and water area are based on combining the result of
NDVI and band ratio. NDVI has used to delineate water from land, band
ratio between green band and infrared band used to separate the
delineated water from clouds, ice, etc. Atmospheric and water
corrections applied according to the Lyzenga et al., 2006. Corrected
spectral bands will be used for weighted multiple regression to estimate
depth. R library *GWmodel* has been used to compute the Geographically
Weighted Regression used for depth estimation.

## NOTES

The input image must include deep water pixels (far away from the coast)
which are used to assist water surface and water column correction.if
there is no deep water pixels included in the satellite imagery,
atmospheric and water corrections are carried without using deep water
pixels. Sparse depth points extracted from hydrographic charts or depth
pints derived from LiDAR survey or derived from Sonar survey can be used
as reference depth for calibration. The calibration depth points
provided by the user are used to ditermine the Area of Interest,
therefore it is suggested to provide calibration depth points in order
to cover user's estimation region boundary. In addition, an optional
parameter is also available to provide a polygon vector file for user's
to ditermine the area to be estimated (see first example).  
  
The tide height at the time of reference depth collection and satellite
imagery capture should be normalized if it is not. An option is
available in the module to provide tide hieght at the tide of image
captured and the module will correct the reference depth accordingly.
This option asuumes that the reference depth given is corrected zero
tide height. The tide lower than zero can be added as negative value.  
  
The *GWmodel* adaptive GWR model is memory intensive and may not be used
to process large images. For large images, the estimation is carried out
by using non-adaptive GWR implemented in *r.gwr* module in GRASS GIS. R
\> 3.1 should be installed to run *GWmodel* in order to proccess
adaptive GWR model for better depth estimation. Default gaussian kernel
will be used to estimate geographically weighted regression
coefficients.The flag 'b' can be used to change the kernel function
gaussian to bi-square.  
  
## EXAMPLES

In *i.image.bathymetry* green band, red band, near-infrared band, band
for correction and calibration depth points are mandatory input.
Additional bands available in the visible wavelength can be used for
better depth estimation as optional input. Short Wave Infrared (SWIR)
band is suggested to use as "band\_for\_correction" if it is available
(for e.g. satellite images like Landsat-7, Landsat-8 and Sentinel-2).An
example of depth estimation using Sentinel-2 (MSI) image is shown below,
where depth value is stored in column named 'Z'  

```sh
i.image.bathymetry blue_band='B2' green_band='B3' red_band='B4'
nir_band='B8' band_for_correction='B11'
calibration_points='Calibration_points' calibration_column='Z'
depth_estimate='output' area_of_interest='AOI'
```

If SWIR band is not available near-infrared band can be used as
"band\_for\_correction" (for e.g. satellite images like RapidEye and
ALOS AVINIR-2). An example of depth estimation using RapidEye image is
shown below image is shown below, where depth value is stored in column
named 'value'.  

```sh
i.image.bathymetry blue_band='B1' green_band='B2' red_band='B3'
Additional_band1='B4' nir_band='B5' band_for_correction='B5'
calibration_points='Calibration_points'  calibration_column='value'
depth_estimate='output'
```

## REFERENCES

- Vinayaraj, P., Raghavan, V. and Masumoto, S. (2016) Satellite
    derived bathymetry using adaptive-geographically weighted regression
    model, Marine Geodesy, 39(6), pp.458-478
- Su, H., Liu, H., Lei, W., Philipi, M., Heyman, W., and Beck, A.,
    2013, Geographically Adaptive Inversion Model for Improving
    Bathymetric Retrieval from Multispectral satellite Imagery. IEEE
    Transaction on Geosciences and Remote Sensing, 52(1) : 465-476,
    Accessed January 2013, doi:10.1109/TGRS.2013.2241772.

## SEE ALSO

*[r.gwr](r.gwr.md),
[r.regression.multi](https://grass.osgeo.org/grass-stable/manuals/r.regression.multi.html)*

## AUTHORS

Vinayaraj Poliyapram (email:*<vinay223333@gmail.com>*), Luca Delucchi and
Venkatesh Raghavan

## SOURCE CODE

Available at: [i.image.bathymetry source code](https://github.com/OSGeo/grass-addons/tree/grass8/src/imagery/i.image.bathymetry)
([history](https://github.com/OSGeo/grass-addons/commits/grass8/src/imagery/i.image.bathymetry))  
Latest change: Friday Feb 21 12:27:42 2025 in commit [8fce680](https://github.com/OSGeo/grass-addons/commit/8fce680a2170ee81eff27fdf4315079b10a10f83)
