---
name: i.in.probav.py
description: Imports PROBA-V NDVI data in netCDF format into a raster map with real NDVI data range.
keywords: [ imagery, import, NDVI, PROBA-V ]
---

# i.in.probav.py

Imports PROBA-V NDVI data in netCDF format into a raster map with real NDVI data range.

=== "Command line"

    **i.in.probav.py**
    **input**=*name*
    **output**=*name*
    [**scale**=*float*]
    [**shift**=*float*]
    [**memory**=*integer*]
    [**--overwrite**]
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    i.in.probav.py input=name output=name
    ```

=== "Python (grass.script)"

    *grass.script.run_command*("***i.in.probav.py***",
        **input**,
        **output**,
        **scale**=*0.004*,
        **shift**=*-0.08*,
        **memory**=*300*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.run_command("i.in.probav.py", input="name", output="name")
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.i_in_probav_py*(**input**,
        **output**,
        **scale**=*0.004*,
        **shift**=*-0.08*,
        **memory**=*300*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.i_in_probav_py(input="name", output="name")
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **input**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input PROBA-V NDVI .nc file  
    **output**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output raster map  
    **scale**=*float*  
    &nbsp;&nbsp;&nbsp;&nbsp;Scale factor for input  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0.004*  
    **shift**=*float*  
    &nbsp;&nbsp;&nbsp;&nbsp;Shift factor for input  
    &nbsp;&nbsp;&nbsp;&nbsp;Offset factor for input  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *-0.08*  
    **memory**=*integer*  
    &nbsp;&nbsp;&nbsp;&nbsp;Maximum memory to be used in MB  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *0-2047*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *300*  
    **--overwrite**  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **input** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input PROBA-V NDVI .nc file  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, file, *name*  
    **output** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster, *name*  
    **scale** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Scale factor for input  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *float*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0.004*  
    **shift** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Shift factor for input  
    &nbsp;&nbsp;&nbsp;&nbsp;Offset factor for input  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *float*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *-0.08*  
    **memory** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Maximum memory to be used in MB  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *integer*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *0-2047*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *300*  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **input** : str | io.StringIO, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input PROBA-V NDVI .nc file  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, file, *name*  
    **output** : str | type(np.ndarray) | type(np.array) | type(gs.array.array), *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster, *name*  
    **scale** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Scale factor for input  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *float*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0.004*  
    **shift** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Shift factor for input  
    &nbsp;&nbsp;&nbsp;&nbsp;Offset factor for input  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *float*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *-0.08*  
    **memory** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Maximum memory to be used in MB  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *integer*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *0-2047*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *300*  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | np.ndarray | tuple[np.ndarray] | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned. If an array type (e.g., *np.ndarray*) is used for one of the raster outputs, the result will be an array and will have the shape corresponding to the computational region. If an array type is used for more than one raster output, the result will be a tuple of arrays.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

*i.in.probav* imports Proba-V NDVI data sets. After the import the
digital numbers (DN) are remapped to VEGETATION NDVI values and the NDVI
color table is applied. The imported DN map is removed after remapping.
It is also possible to change the scale and offset factor (default is
scale: 0.004, offset: -0.08 for Proba-V) and to improve the memory usage
(default is 300 MB).

Important for the Proba-V Data sets, is a user registration at [the VITO
portal](https://www.vito-eodata.be/PDF/portal/Application.html#Home)
necessary (Register Button in the Upper Right Corner).

## NOTES

The Proba-V files are delivered in NetCDF (Network Common Data Form)
format. It is required to have the GDAL libraries installed with NetCDF
support. Also to check the necessary scale and offset factor with
**gdalinfo**.

### Before Import

When working with Proba-V NDVI, it it necessary to fix the range of the
map because it exceeds the -180°..+180° range with entire world extent.
You can shift the map slightly into the right position using
[gdal\_translate](https://gdal.org/en/latest/programs/gdal_translate.html).
This example in [Global
datasets](https://grasswiki.osgeo.org/wiki/Global_datasets#ESA_Globcover_dataset)
may help you.

## EXAMPLE

```sh
# import of 300m NDVI
i.in.probav input=c_gls_NDVI300_201611010000_GLOBE_PROBAV_V1.0.1.nc \
            output=c_gls_NDVI300_201611010000_GLOBE_PROBAV_V1.0.1 memory=500
```

## SEE ALSO

*[i.in.spotvgt](https://grass.osgeo.org/grass-stable/manuals/i.in.spotvgt.html),
[r.in.gdal](https://grass.osgeo.org/grass-stable/manuals/r.in.gdal.html)*

## REFERENCES

- [VITO Product Distribution
    Portal](https://www.vito-eodata.be/PDF/portal/Application.html#Home)
- [PROBA-V
    FAQ](https://www.vito-eodata.be/PDF/image/faq_help/Faq.html)
- [VITO Collections
    help](https://www.vito-eodata.be/PDF/image/faq_help/Help.html#COLLECTION)

## AUTHOR

Jonas Strobel

## SOURCE CODE

Available at: [i.in.probav source code](https://github.com/OSGeo/grass-addons/tree/grass8/src/imagery/i.in.probav)
([history](https://github.com/OSGeo/grass-addons/commits/grass8/src/imagery/i.in.probav))  
Latest change: Friday Feb 21 10:10:05 2025 in commit [7d78fe3](https://github.com/OSGeo/grass-addons/commit/7d78fe34868674c3b6050ba1924e1c5675d155c9)
