---
name: i.landsat.qa.py
description: Reclassifies Landsat QA band according to acceptable pixel quality as defined by the user.
keywords: [ imagery, pixel, quality, qa, bitpattern, mask, landsat ]
---

# i.landsat.qa.py

Reclassifies Landsat QA band according to acceptable pixel quality as defined by the user.

=== "Command line"

    **i.landsat.qa.py**
    [**output**=*name*]
    [**dataset**=*string*]
    [**designated_fill**=*string*]
    [**cloud**=*string*]
    [**cloud_confidence**=*string* [,*string*,...]]
    [**cloud_shadow_confidence**=*string* [,*string*,...]]
    [**snow_ice_confidence**=*string* [,*string*,...]]
    [**cirrus_confidence**=*string* [,*string*,...]]
    [**dilated_cloud**=*string*]
    [**snow**=*string*]
    [**clear**=*string*]
    [**water**=*string*]
    [**terrain_occlusion**=*string*]
    [**radiometric_saturation**=*string* [,*string*,...]]
    [**--overwrite**]
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    i.landsat.qa.py designated_fill=string
    ```

=== "Python (grass.script)"

    *grass.script.run_command*("***i.landsat.qa.py***",
        **output**=*None*,
        **dataset**=*"landsat_ot_c2_l2"*,
        **designated_fill**=*None*,
        **cloud**=*None*,
        **cloud_confidence**=*None*,
        **cloud_shadow_confidence**=*None*,
        **snow_ice_confidence**=*None*,
        **cirrus_confidence**=*None*,
        **dilated_cloud**=*None*,
        **snow**=*None*,
        **clear**=*None*,
        **water**=*None*,
        **terrain_occlusion**=*None*,
        **radiometric_saturation**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.run_command("i.landsat.qa.py", designated_fill="string")
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.i_landsat_qa_py*(**output**=*None*,
        **dataset**=*"landsat_ot_c2_l2"*,
        **designated_fill**=*None*,
        **cloud**=*None*,
        **cloud_confidence**=*None*,
        **cloud_shadow_confidence**=*None*,
        **snow_ice_confidence**=*None*,
        **cirrus_confidence**=*None*,
        **dilated_cloud**=*None*,
        **snow**=*None*,
        **clear**=*None*,
        **water**=*None*,
        **terrain_occlusion**=*None*,
        **radiometric_saturation**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.i_landsat_qa_py(designated_fill="string")
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **output**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Output file with reclass rules  
    **dataset**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Landsat dataset to search for  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *landsat_tm_c1,  landsat_etm_c1,  landsat_8_c1,  landsat_tm_c2_l1,  landsat_tm_c2_l2,  landsat_etm_c2_l1,  landsat_etm_c2_l2,  landsat_ot_c2_l1,  landsat_ot_c2_l2*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *landsat_ot_c2_l2*  
    **designated_fill**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Unacceptable conditions for Designated Fill  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *No,  Yes*  
    **cloud**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Unacceptable conditions for Clouds  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *No,  Yes*  
    **cloud_confidence**=*string* [,*string*,...]  
    &nbsp;&nbsp;&nbsp;&nbsp;Unacceptable conditions for Cloud confidence  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *Not Determined,  Low,  Medium,  High*  
    **cloud_shadow_confidence**=*string* [,*string*,...]  
    &nbsp;&nbsp;&nbsp;&nbsp;Unacceptable conditions for Cloud Shaddow Confidence  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *Not Determined,  Low,  Medium,  High*  
    **snow_ice_confidence**=*string* [,*string*,...]  
    &nbsp;&nbsp;&nbsp;&nbsp;Unacceptable conditions for Snow/Ice Confidence  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *Not Determined,  Low,  Medium,  High*  
    **cirrus_confidence**=*string* [,*string*,...]  
    &nbsp;&nbsp;&nbsp;&nbsp;Unacceptable conditions for Cirrus Confidence  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *Not Determined,  Low,  Medium,  High*  
    **dilated_cloud**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Unacceptable conditions for Pixels with Dilated Clouds (only collection 2)  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *No,  Yes*  
    **snow**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Unacceptable conditions for Snow Pixels (only collection 2)  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *No,  Yes*  
    **clear**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Unacceptable conditions for Clear Pixels (only collection 2)  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *No,  Yes*  
    **water**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Unacceptable conditions for Water Pixels (only collection 2)  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *No,  Yes*  
    **terrain_occlusion**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Unacceptable conditions for Terrain Occlusion / Dropped Pixels (only collection 1)  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *No,  Yes*  
    **radiometric_saturation**=*string* [,*string*,...]  
    &nbsp;&nbsp;&nbsp;&nbsp;Unacceptable conditions for Radiometric Saturation (only collection 1)  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *Not Determined,  Low,  Medium,  High*  
    **--overwrite**  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **output** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Output file with reclass rules  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, file, *name*  
    **dataset** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Landsat dataset to search for  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *landsat_tm_c1,  landsat_etm_c1,  landsat_8_c1,  landsat_tm_c2_l1,  landsat_tm_c2_l2,  landsat_etm_c2_l1,  landsat_etm_c2_l2,  landsat_ot_c2_l1,  landsat_ot_c2_l2*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *landsat_ot_c2_l2*  
    **designated_fill** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Unacceptable conditions for Designated Fill  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *No,  Yes*  
    **cloud** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Unacceptable conditions for Clouds  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *No,  Yes*  
    **cloud_confidence** : str | list[str], *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Unacceptable conditions for Cloud confidence  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *Not Determined,  Low,  Medium,  High*  
    **cloud_shadow_confidence** : str | list[str], *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Unacceptable conditions for Cloud Shaddow Confidence  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *Not Determined,  Low,  Medium,  High*  
    **snow_ice_confidence** : str | list[str], *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Unacceptable conditions for Snow/Ice Confidence  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *Not Determined,  Low,  Medium,  High*  
    **cirrus_confidence** : str | list[str], *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Unacceptable conditions for Cirrus Confidence  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *Not Determined,  Low,  Medium,  High*  
    **dilated_cloud** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Unacceptable conditions for Pixels with Dilated Clouds (only collection 2)  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *No,  Yes*  
    **snow** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Unacceptable conditions for Snow Pixels (only collection 2)  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *No,  Yes*  
    **clear** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Unacceptable conditions for Clear Pixels (only collection 2)  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *No,  Yes*  
    **water** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Unacceptable conditions for Water Pixels (only collection 2)  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *No,  Yes*  
    **terrain_occlusion** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Unacceptable conditions for Terrain Occlusion / Dropped Pixels (only collection 1)  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *No,  Yes*  
    **radiometric_saturation** : str | list[str], *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Unacceptable conditions for Radiometric Saturation (only collection 1)  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *Not Determined,  Low,  Medium,  High*  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **output** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Output file with reclass rules  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, file, *name*  
    **dataset** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Landsat dataset to search for  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *landsat_tm_c1,  landsat_etm_c1,  landsat_8_c1,  landsat_tm_c2_l1,  landsat_tm_c2_l2,  landsat_etm_c2_l1,  landsat_etm_c2_l2,  landsat_ot_c2_l1,  landsat_ot_c2_l2*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *landsat_ot_c2_l2*  
    **designated_fill** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Unacceptable conditions for Designated Fill  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *No,  Yes*  
    **cloud** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Unacceptable conditions for Clouds  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *No,  Yes*  
    **cloud_confidence** : str | list[str], *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Unacceptable conditions for Cloud confidence  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *Not Determined,  Low,  Medium,  High*  
    **cloud_shadow_confidence** : str | list[str], *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Unacceptable conditions for Cloud Shaddow Confidence  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *Not Determined,  Low,  Medium,  High*  
    **snow_ice_confidence** : str | list[str], *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Unacceptable conditions for Snow/Ice Confidence  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *Not Determined,  Low,  Medium,  High*  
    **cirrus_confidence** : str | list[str], *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Unacceptable conditions for Cirrus Confidence  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *Not Determined,  Low,  Medium,  High*  
    **dilated_cloud** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Unacceptable conditions for Pixels with Dilated Clouds (only collection 2)  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *No,  Yes*  
    **snow** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Unacceptable conditions for Snow Pixels (only collection 2)  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *No,  Yes*  
    **clear** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Unacceptable conditions for Clear Pixels (only collection 2)  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *No,  Yes*  
    **water** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Unacceptable conditions for Water Pixels (only collection 2)  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *No,  Yes*  
    **terrain_occlusion** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Unacceptable conditions for Terrain Occlusion / Dropped Pixels (only collection 1)  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *No,  Yes*  
    **radiometric_saturation** : str | list[str], *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Unacceptable conditions for Radiometric Saturation (only collection 1)  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *Not Determined,  Low,  Medium,  High*  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

Removing unreliable pixels is a fundamental and one of the first steps
in remote sensing. Landsat imagery provides a Quality Assessment (QA)
band which can be used for this purpose.

The *i.landsat.qa* module generates reclassification rule files which
can be used in
[r.reclass](https://grass.osgeo.org/grass-stable/manuals/r.reclass.html)
for filtering the QA band according to pixel quality characteristics the
user defines as unacceptable. It works with both Collection 1 and
Collection 2 data from Landsat 8 OLI/TIRS, 4-7 TM/ETM+. The **dataset**
the QA band belongs to is specified like in
[i.landsat.download](i.landsat.download.md).

Values defined as unacceptable for a given condition will be set to NULL
in the output raster map. All other values will be set to 1.

The Quality Assessment (QA) band from Landsat contains 16bit integer
values that represent "bit-packed combinations of surface, atmosphere,
and sensor conditions that can affect the overall usefulness of a given
pixel".  

The following quality relevant conditions are represented as "single
bits" in the Landsat QA band:

|                                    |            |
| ---------------------------------- | ---------- |
| Condition                          | Collection |
| Designated Fill                    | 1,2        |
| Dilated Cloud                      | 2          |
| Terrain Occlusion / Dropped Pixels | 1          |
| Cloud                              | 1,2        |
| Cirrus                             | 2          |
| Cloud Shadow                       | 2          |
| Snow                               | 2          |
| Clear                              | 2          |
| Water                              | 2          |

Possible choices for the "single bits" are:

|       |                               |                    |
| ----- | ----------------------------- | ------------------ |
| Value | Description                   | Bit representation |
| No    | This condition does not exist | 0                  |
| Yes   | This condition exists         | 1                  |

The following quality relevant conditions are represented as "double
bits" in the Landsat QA band:

|                         |            |
| ----------------------- | ---------- |
| Condition               | Collection |
| Radiometric saturation  | 2          |
| Cloud Confidence        | 1,2        |
| Cloud Shadow Confidence | 1,2        |
| Snow/Ice Confidence     | 1,2        |
| Cirrus Confidence       | 1,2        |

Possible choices for the "double bits" are:

|                |                                                                                         |                    |
| -------------- | --------------------------------------------------------------------------------------- | ------------------ |
| Value          | Description                                                                             | Bit representation |
| Not Determined | Algorithm did not determine the status of this condition                                | 00                 |
| Low            | Algorithm has low to no confidence that this condition exists (0-33 percent confidence) | 01                 |
| Medium         | Algorithm has medium confidence that this condition exists (34-66 percent confidence)   | 10                 |
| High           | Algorithm has high confidence that this condition exists (67-100 percent confidence)    | 11                 |

## NOTES

The Landsat Quality Assessment band is an artificial band which
represents an analysis based on [defined
algorithms](https://landsat.usgs.gov/documents/LDCM_CVT_ADD.pdf). The
USGS provides the users with the following note on how the QA band
should be used:

"Rigorous science applications seeking to optimize the value of pixels
used in a study will find QA bits useful as a first level indicator of
certain conditions. Otherwise, users are advised that this file contains
information that can be easily misinterpreted and it is not recommended
for general use."

## EXAMPLE

```sh
# Create a cloud mask:
i.landsat.qa --overwrite --verbose cloud_confidence="Medium,High" \
    dataset="landsat_ot_c2_l2" \
    output=./Cloud_Mask_rules.txt
r.reclass input=LC81980182015183LGN00_BQA \
    output=LC81980182015183LGN00_Cloud_Mask rules=./Cloud_Mask_rules.txt

# Create a water mask (only available for collection 2):
i.landsat.qa --overwrite --verbose water="Yes" \
    dataset="landsat_ot_c2_l2" \
    output=./Water_Mask_rules.txt
r.reclass input=LC81980182015183LGN00_BQA \
    output=LC81980182015183LGN00_Water_Mask rules=./Water_Mask_rules.txt

```

## SEE ALSO

*[r.reclass](https://grass.osgeo.org/grass-stable/manuals/r.reclass.html),
[i.modis.qc](i.modis.qc.md), [r.bitpattern](r.bitpattern.md),
[i.landsat](i.landsat.md) [i.landsat8.swlst](i.landsat8.swlst.md)*

## REFERENCES

*[Landsat Collection 1 Level 1 Quality Assessment
bands](https://www.usgs.gov/core-science-systems/nli/landsat/landsat-collection-1-level-1-quality-assessment-band)
[Landsat Collection 2 Level 1 Quality Assessment
bands](https://www.usgs.gov/core-science-systems/nli/landsat/landsat-collection-2-quality-assessment-bands)*

## AUTHOR

Stefan Blumentrath, Norwegian Institute for Nature Research, Oslo
(Norway)

## SOURCE CODE

Available at: [i.landsat.qa source code](https://github.com/OSGeo/grass-addons/tree/grass8/imagery/i.landsat/i.landsat.qa)
([history](https://github.com/OSGeo/grass-addons/commits/grass8/imagery/i.landsat/i.landsat.qa))  
Latest change: Saturday Jan 24 09:11:56 2026 in commit [55aacc4](https://github.com/OSGeo/grass-addons/commit/55aacc4e42009565da495e6a2b1d06e2ddf13922)
