---
name: i.sam2.py
description: Integrates SAMGeo model with text prompt for segmentation in GRASS GIS.
keywords: [ imagery, segmentation, object recognition, deep learning ]
---

# i.sam2.py

Integrates SAMGeo model with text prompt for segmentation in GRASS GIS.

=== "Command line"

    **i.sam2.py**
    **group**=*name*
    **output**=*name*
    [**checkpoint_dir**=*name*]
    [**text_prompt**=*string*]
    [**text_threshold**=*float*]
    [**box_threshold**=*float*]
    [**--overwrite**]
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    i.sam2.py group=name output=name
    ```

=== "Python (grass.script)"

    *grass.script.run_command*("***i.sam2.py***",
        **group**,
        **output**,
        **checkpoint_dir**=*None*,
        **text_prompt**=*None*,
        **text_threshold**=*0.24*,
        **box_threshold**=*0.24*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.run_command("i.sam2.py", group="name", output="name")
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.i_sam2_py*(**group**,
        **output**,
        **checkpoint_dir**=*None*,
        **text_prompt**=*None*,
        **text_threshold**=*0.24*,
        **box_threshold**=*0.24*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.i_sam2_py(group="name", output="name")
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **group**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input imagery group  
    **output**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of output segmented raster map  
    **checkpoint_dir**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Path to the SAMGeo model checkpoint directory (optional if using default model)  
    **text_prompt**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Text prompt to guide segmentation  
    **text_threshold**=*float*  
    &nbsp;&nbsp;&nbsp;&nbsp;Text threshold for text segmentation  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0.24*  
    **box_threshold**=*float*  
    &nbsp;&nbsp;&nbsp;&nbsp;Box threshold for text segmentation  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0.24*  
    **--overwrite**  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **group** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input imagery group  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, group, *name*  
    **output** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of output segmented raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster, *name*  
    **checkpoint_dir** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Path to the SAMGeo model checkpoint directory (optional if using default model)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, dir, *name*  
    **text_prompt** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Text prompt to guide segmentation  
    **text_threshold** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Text threshold for text segmentation  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0.24*  
    **box_threshold** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Box threshold for text segmentation  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0.24*  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **group** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input imagery group  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, group, *name*  
    **output** : str | type(np.ndarray) | type(np.array) | type(gs.array.array), *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of output segmented raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster, *name*  
    **checkpoint_dir** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Path to the SAMGeo model checkpoint directory (optional if using default model)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, dir, *name*  
    **text_prompt** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Text prompt to guide segmentation  
    **text_threshold** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Text threshold for text segmentation  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0.24*  
    **box_threshold** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Box threshold for text segmentation  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0.24*  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | np.ndarray | tuple[np.ndarray] | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned. If an array type (e.g., *np.ndarray*) is used for one of the raster outputs, the result will be an array and will have the shape corresponding to the computational region. If an array type is used for more than one raster output, the result will be a tuple of arrays.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

*i.sam2* allows users to segment orthoimagery based on text prompts
using [SamGeo](https://samgeo.gishub.org/).

## REQUIREMENTS

- [Pillow\>=10.2.0](https://pillow.readthedocs.io/en/stable/)
- [numpy\>=1.26.1](https://numpy.org/)
- [torch\>=2.5.1](https://pytorch.org/)
- [segment-geospatial\>=0.12.3](https://samgeo.gishub.org/)

```sh
pip install pillow numpy torch segment-geospatial
```

## EXAMPLES

Segment orthoimagery using SamGeo2:

```sh
i.sam2 group=rgb_255 output=tree_mask text_prompt="trees"
```

![i.sam2: trees detected in an aerial image with samgeo](i_sam2_trees.jpg)

## NOTES

The first time use will be longer as the model needs to be downloaded.
Subsequent runs will be faster. Additionally, CUDA is required for GPU
acceleration. If you do not have a GPU, you can use the CPU by setting
the environment variable \`CUDA\_VISIBLE\_DEVICES\` to \`-1\`.

## REFERENCES

- Wu, Q., & Osco, L. (2023). samgeo: A Python package for segmenting
    geospatial data with the Segment Anything Model (SAM). Journal of
    Open Source Software, 8(89), 5663.
    <https://doi.org/10.21105/joss.05663>
- Osco, L. P., Wu, Q., de Lemos, E. L., Gonçalves, W. N., Ramos, A. P.
    M., Li, J., & Junior, J. M. (2023). The Segment Anything Model (SAM)
    for remote sensing applications: From zero to one shot.
    International Journal of Applied Earth Observation and
    Geoinformation, 124, 103540.
    <https://doi.org/10.1016/j.jag.2023.103540>

## SEE ALSO

*[i.segment.gsoc](i.segment.gsoc.md) for region growing and merging
segmentation, [i.segment.hierarchical](i.segment.hierarchical) performs
a hierarchical segmentation, [i.superpixels.slic](i.superpixels.slic)
for superpixel segmentation.*

## AUTHOR

Corey T. White (NCSU GeoForAll Lab & OpenPlains Inc.)

## SOURCE CODE

Available at: [i.sam2 source code](https://github.com/OSGeo/grass-addons/tree/grass8/src/imagery/i.sam2)
([history](https://github.com/OSGeo/grass-addons/commits/grass8/src/imagery/i.sam2))  
Latest change: Thursday Mar 20 21:36:57 2025 in commit [7286ecf](https://github.com/OSGeo/grass-addons/commit/7286ecf7af235bfd089fb9b1b82fb383cf95f3fc)
