---
name: i.sar.speckle.py
description: Remove speckle from SAR image
keywords: [ imagery, speckle, sar, radar ]
---

# i.sar.speckle.py

Remove speckle from SAR image

=== "Command line"

    **i.sar.speckle.py**
    **input**=*name*
    **output**=*name*
    **method**=*string*
    **size**=*integer*
    [**--overwrite**]
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    i.sar.speckle.py input=name output=name method=lee size=11
    ```

=== "Python (grass.script)"

    *grass.script.run_command*("***i.sar.speckle.py***",
        **input**,
        **output**,
        **method**=*"lee"*,
        **size**=*11*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.run_command("i.sar.speckle.py", input="name", output="name", method="lee", size=11)
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.i_sar_speckle_py*(**input**,
        **output**,
        **method**=*"lee"*,
        **size**=*11*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.i_sar_speckle_py(input="name", output="name", method="lee", size=11)
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **input**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input image  
    **output**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of output image  
    **method**=*string* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Method for speckle removal  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *lee*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *lee*  
    **size**=*integer* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Size of neighborhood  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *11*  
    **--overwrite**  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **input** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input image  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **output** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of output image  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster, *name*  
    **method** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Method for speckle removal  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *lee*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *lee*  
    **size** : int, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Size of neighborhood  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *11*  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **input** : str | np.ndarray, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input image  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **output** : str | type(np.ndarray) | type(np.array) | type(gs.array.array), *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of output image  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster, *name*  
    **method** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Method for speckle removal  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *lee*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *lee*  
    **size** : int, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Size of neighborhood  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *11*  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | np.ndarray | tuple[np.ndarray] | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned. If an array type (e.g., *np.ndarray*) is used for one of the raster outputs, the result will be an array and will have the shape corresponding to the computational region. If an array type is used for more than one raster output, the result will be a tuple of arrays.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

A simple procedure to reduce speckle noise in SAR images.

So far, the only algorithm implemented is the Lee filter. So, the
*method* parameter is set to *lee* by default.

The *size* parameter is the one used in
[r.neighbors](https://grass.osgeo.org/grass-stable/manuals/r.neighbors.html)
and is used to calculate local mean and local square mean. It must be
odd.

## REFERENCES

Lee, J. S. (1986). Speckle suppression and analysis for synthetic
aperture radar images. Optical engineering, 25(5), 255636.

## SEE ALSO

[r.neighbors](https://grass.osgeo.org/grass-stable/manuals/r.neighbors.html)

## AUTHOR

Margherita Di Leo

## SOURCE CODE

Available at: [i.sar.speckle source code](https://github.com/OSGeo/grass-addons/tree/grass8/src/imagery/i.sar.speckle)
([history](https://github.com/OSGeo/grass-addons/commits/grass8/src/imagery/i.sar.speckle))  
Latest change: Thursday Feb 20 13:02:26 2025 in commit [53de819](https://github.com/OSGeo/grass-addons/commit/53de8196a10ba5a8a9121898ce87861d227137e3)
