---
name: i.sentinel.parallel.download.py
description: Downloads Sentinel-2 images in parallel using i.sentinel.download.
keywords: [ imagery, satellite, Sentinel, download, parallel ]
---

# i.sentinel.parallel.download.py

Downloads Sentinel-2 images in parallel using i.sentinel.download.

=== "Command line"

    **i.sentinel.parallel.download.py**
    [**-sfe**]
    [**settings**=*name*]
    [**scene_name**=*string* [,*string*,...]]
    [**output**=*name*]
    [**clouds**=*integer*]
    [**producttype**=*string*]
    [**start**=*string*]
    [**end**=*string*]
    [**nprocs**=*integer*]
    [**datasource**=*string*]
    [**limit**=*integer*]
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    i.sentinel.parallel.download.py
    ```

=== "Python (grass.script)"

    *grass.script.run_command*("***i.sentinel.parallel.download.py***",
        **settings**=*None*,
        **scene_name**=*None*,
        **output**=*None*,
        **clouds**=*20*,
        **producttype**=*"S2MSI2A"*,
        **start**=*None*,
        **end**=*None*,
        **nprocs**=*1*,
        **datasource**=*"ESA_COAH"*,
        **limit**=*None*,
        **flags**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.run_command("i.sentinel.parallel.download.py")
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.i_sentinel_parallel_download_py*(**settings**=*None*,
        **scene_name**=*None*,
        **output**=*None*,
        **clouds**=*20*,
        **producttype**=*"S2MSI2A"*,
        **start**=*None*,
        **end**=*None*,
        **nprocs**=*1*,
        **datasource**=*"ESA_COAH"*,
        **limit**=*None*,
        **flags**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.i_sentinel_parallel_download_py()
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **settings**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Full path to settings file (user, password)  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input file  
    **scene_name**=*string* [,*string*,...]  
    &nbsp;&nbsp;&nbsp;&nbsp;Names of the scenes to be downloaded  
    **output**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output directory where to store downloaded Sentinel data  
    **clouds**=*integer*  
    &nbsp;&nbsp;&nbsp;&nbsp;Maximum cloud cover percentage for Sentinel scene  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *20*  
    **producttype**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Sentinel product type to filter  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *SLC, GRD, OCN, S2MSI1C, S2MSI2A, S2MSI2Ap*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *S2MSI2A*  
    **start**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Start date ('YYYY-MM-DD')  
    **end**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;End date ('YYYY-MM-DD')  
    **nprocs**=*integer*  
    &nbsp;&nbsp;&nbsp;&nbsp;Number of parallel processes  
    &nbsp;&nbsp;&nbsp;&nbsp;Number of used CPUs  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1*  
    **datasource**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default is ESA Copernicus Open Access Hub (ESA_COAH), but Sentinel-2 L1C data can also be acquired from USGS Earth Explorer (USGS_EE) or Google Cloud Storage (GCS)  
    &nbsp;&nbsp;&nbsp;&nbsp;Data-Hub to download scenes from  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *ESA_COAH, USGS_EE, GCS*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *ESA_COAH*  
    **limit**=*integer*  
    &nbsp;&nbsp;&nbsp;&nbsp;Maximum number of scenes to filter/download  
    **-s**  
    &nbsp;&nbsp;&nbsp;&nbsp;Use scenename/s instead of start/end/producttype to download specific S2 data (specify in the scene_name field)  
    **-f**  
    &nbsp;&nbsp;&nbsp;&nbsp;Download each Sentinel-2 datasat into an individual folder within the output folder  
    **-e**  
    &nbsp;&nbsp;&nbsp;&nbsp;Use ESA-style scenename/s to download from USGS  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **settings** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Full path to settings file (user, password)  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input file  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, file, *name*  
    **scene_name** : str | list[str], *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Names of the scenes to be downloaded  
    **output** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output directory where to store downloaded Sentinel data  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, dir, *name*  
    **clouds** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Maximum cloud cover percentage for Sentinel scene  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *20*  
    **producttype** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Sentinel product type to filter  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *SLC, GRD, OCN, S2MSI1C, S2MSI2A, S2MSI2Ap*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *S2MSI2A*  
    **start** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Start date ('YYYY-MM-DD')  
    **end** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;End date ('YYYY-MM-DD')  
    **nprocs** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Number of parallel processes  
    &nbsp;&nbsp;&nbsp;&nbsp;Number of used CPUs  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1*  
    **datasource** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default is ESA Copernicus Open Access Hub (ESA_COAH), but Sentinel-2 L1C data can also be acquired from USGS Earth Explorer (USGS_EE) or Google Cloud Storage (GCS)  
    &nbsp;&nbsp;&nbsp;&nbsp;Data-Hub to download scenes from  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *ESA_COAH, USGS_EE, GCS*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *ESA_COAH*  
    **limit** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Maximum number of scenes to filter/download  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *s*, *f*, *e*  
    &nbsp;&nbsp;&nbsp;&nbsp;**s**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Use scenename/s instead of start/end/producttype to download specific S2 data (specify in the scene_name field)  
    &nbsp;&nbsp;&nbsp;&nbsp;**f**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Download each Sentinel-2 datasat into an individual folder within the output folder  
    &nbsp;&nbsp;&nbsp;&nbsp;**e**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Use ESA-style scenename/s to download from USGS  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **settings** : str | io.StringIO, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Full path to settings file (user, password)  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input file  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, file, *name*  
    **scene_name** : str | list[str], *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Names of the scenes to be downloaded  
    **output** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output directory where to store downloaded Sentinel data  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, dir, *name*  
    **clouds** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Maximum cloud cover percentage for Sentinel scene  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *20*  
    **producttype** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Sentinel product type to filter  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *SLC, GRD, OCN, S2MSI1C, S2MSI2A, S2MSI2Ap*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *S2MSI2A*  
    **start** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Start date ('YYYY-MM-DD')  
    **end** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;End date ('YYYY-MM-DD')  
    **nprocs** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Number of parallel processes  
    &nbsp;&nbsp;&nbsp;&nbsp;Number of used CPUs  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1*  
    **datasource** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default is ESA Copernicus Open Access Hub (ESA_COAH), but Sentinel-2 L1C data can also be acquired from USGS Earth Explorer (USGS_EE) or Google Cloud Storage (GCS)  
    &nbsp;&nbsp;&nbsp;&nbsp;Data-Hub to download scenes from  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *ESA_COAH, USGS_EE, GCS*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *ESA_COAH*  
    **limit** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Maximum number of scenes to filter/download  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *s*, *f*, *e*  
    &nbsp;&nbsp;&nbsp;&nbsp;**s**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Use scenename/s instead of start/end/producttype to download specific S2 data (specify in the scene_name field)  
    &nbsp;&nbsp;&nbsp;&nbsp;**f**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Download each Sentinel-2 datasat into an individual folder within the output folder  
    &nbsp;&nbsp;&nbsp;&nbsp;**e**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Use ESA-style scenename/s to download from USGS  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

*i.sentinel.parallel.download* downloads Sentinel-2 data defined by
scene names in parallel using *i.sentinel.download*.  
If no scene names are specified *i.sentinel.parallel.download* downloads
data for the computational region set in the mapset; i.e, only products
which footprint intersects the current computation region extent (area
of interest, AOI) are selected.

## SEE ALSO

*[i.sentinel](i.sentinel.md) module set,
[i.sentinel.download](i.sentinel.download.md)*

## AUTHOR

Guido Riembauer, [mundialis](https://www.mundialis.de/)

## SOURCE CODE

Available at: [i.sentinel.parallel.download source code](https://github.com/OSGeo/grass-addons/tree/grass8/imagery/i.sentinel/i.sentinel.parallel.download)
([history](https://github.com/OSGeo/grass-addons/commits/grass8/imagery/i.sentinel/i.sentinel.parallel.download))  
Latest change: Monday Jan 19 23:02:33 2026 in commit [f6cae1f](https://github.com/OSGeo/grass-addons/commit/f6cae1f411b7cc75908d239b02dea6f6abd7fedd)
