---
name: r.basin.py
description: Morphometric characterization of river basins
keywords: [ raster, hydrology, watershed ]
---

# r.basin.py

Morphometric characterization of river basins

=== "Command line"

    **r.basin.py**
    [**-ac**]
    **map**=*name*
    **prefix**=*prefix*
    **coordinates**=*east,north*
    **dir**=*name*
    [**threshold**=*threshold*]
    [**--overwrite**]
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    r.basin.py map=name prefix=prefix coordinates=0.0 dir=name
    ```

=== "Python (grass.script)"

    *grass.script.run_command*("***r.basin.py***",
        **map**,
        **prefix**,
        **coordinates**,
        **dir**,
        **threshold**=*None*,
        **flags**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.run_command("r.basin.py", map="name", prefix="prefix", coordinates=0.0, dir="name")
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.r_basin_py*(**map**,
        **prefix**,
        **coordinates**,
        **dir**,
        **threshold**=*None*,
        **flags**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.r_basin_py(map="name", prefix="prefix", coordinates=0.0, dir="name")
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **map**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of elevation raster map  
    **prefix**=*prefix* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;output prefix (must start with a letter)  
    **coordinates**=*east,north* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;coordinates of the outlet (east,north)  
    **dir**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Directory where the output will be found  
    **threshold**=*threshold*  
    &nbsp;&nbsp;&nbsp;&nbsp;threshold  
    **-a**  
    &nbsp;&nbsp;&nbsp;&nbsp;Use default threshold (1km^2)  
    **-c**  
    &nbsp;&nbsp;&nbsp;&nbsp;No maps output  
    **--overwrite**  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **map** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of elevation raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **prefix** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;output prefix (must start with a letter)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *prefix*  
    **coordinates** : tuple[float, float] | list[float] | str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;coordinates of the outlet (east,north)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, coords, *east,north*  
    **dir** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Directory where the output will be found  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, dir, *name*  
    **threshold** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;threshold  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *threshold*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *a*, *c*  
    &nbsp;&nbsp;&nbsp;&nbsp;**a**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Use default threshold (1km^2)  
    &nbsp;&nbsp;&nbsp;&nbsp;**c**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;No maps output  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **map** : str | np.ndarray, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of elevation raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **prefix** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;output prefix (must start with a letter)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *prefix*  
    **coordinates** : tuple[float, float] | list[float] | str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;coordinates of the outlet (east,north)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, coords, *east,north*  
    **dir** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Directory where the output will be found  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, dir, *name*  
    **threshold** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;threshold  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *threshold*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *a*, *c*  
    &nbsp;&nbsp;&nbsp;&nbsp;**a**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Use default threshold (1km^2)  
    &nbsp;&nbsp;&nbsp;&nbsp;**c**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;No maps output  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

*r.basin* generates the main morphometric parameters of the basin
starting from the digital elevation model and the coordinates of the
basin's closing section (outlet). **Important:** *r.basin* works in
projected locations, geographic or xy-locations are not supported.

The closing section's coordinates must belong to the river network
generated by
[r.stream.extract](https://grass.osgeo.org/grass-stable/manuals/r.stream.extract.html).
It is suggested to run it beforehand. In GRASS GIS 7, *r.basin* has been
improved to take in input coordinates not exactly belonging to the river
network (but not too far from it). It basically snaps to the closest
point belonging to the network. This feature is experimental and might
not produce the expected result. To check if the snapped outlet is
acceptable, at the end of the computation, two outlet vector maps are
produced: the one with the coordinates inserted by the user and the
snapped one. If the snapped outlet is not acceptable, the user should
tweak the coordinates to match with the river network.

### Morphometric parameters of basin

The main parameters are:

- The coordinates of the vertices of the rectangle containing the
    basin.
- The center of gravity of the basin: the coordinates of the pixel
    nearest to the center of gravity of the geometric figure resulting
    from the projection of the basin on the horizontal plane.
- The area of the basin: is the area of a single cell multiplied by
    the number of cells belonging to the basin.
- The perimeter: is the length of the contour of the figure resulting
    by the projection of the basin on the horizontal plane.
- Characteristic values of elevation: the highest and the lowest
    altitude, the difference between them and the mean elevation
    calculated as the sum of the values of the cells divided by the
    number of the cells.
- The mean slope, calculated averaging the slope map.
- The length of the directing vector: the length of the vector linking
    the outlet to the center of gravity of the basin.
- The prevalent orientation: in GRASS GIS the aspect categories
    represent the number degrees of east and they increase
    counterclockwise: (90deg is North, 180 is West, 270 is South 360 is
    East). The aspect value 0 is used to indicate undefined aspect in
    flat areas with slope=0. We instead calculate the orientation as the
    number of degrees from north, increasing counterclockwise.
- The length of the main channel: is the length of the longest
    succession of segments that connect a source to the outlet of the
    basin.
- The mean slope of the main channel: it is calculated as follows

![image-alt](r_basin1.png)

where N is the topological diameter, i.e. the number of links in which
the main channel can be divided on the basis of the junctions.

- The circularity ratio: is the ratio between the area of the basin
    and the area of the circle having the same perimeter of the basin.
- The elongation ratio: is the ratio between the diameter of the
    circle having the same area of the basin and the length of the main
    channel.
- The compactness coefficient: is the ratio between the perimeter of
    the basin and the diameter of the circle having the same area of the
    basin.
- The shape factor: is the ratio between the area of the basin and the
    square of the length of the main channel.
- The concentration time (Giandotti, 1934):

![image-alt](r_basin2.png)

where A is the area, L the length of the main channel and H the
difference between the highest and the lowest elevation of the basin.

- The mean hillslope length: is the mean of the distances calculated
    along the flow direction of each point not belonging to the river
    network from the point in which flows into the network.
- The magnitude: is the number of the branches of order 1 following
    the Strahler hierarchy.
- The max order: is the order of the basin, following the Strahler
    hierarchy.
- The number of streams: is the number of the branches of the river
    network.
- The total stream length: is the sum of the length of every branch.
- The first order stream frequency: is the ratio between the magnitude
    and the area of the basin.
- The drainage density: is the ratio between the total length of the
    river network and the area.
- The Horton ratios (Horton, 1945; Strahler, 1957).

### Plots

- The distance-area function, also known as Width Function: in x axis
    is the length and in y axis is the area.
- The hypsographic curve provides the distribution of the areas at
    different altitudes. Each point on the hypsographic curve has on the
    y-axis the altitude and on the x-axis the percentage of basin
    surface placed above that altitude.
- The hypsometric curve has the same shape but is dimensionless.

## EXAMPLE

North Carolina sample dataset example:

```sh
g.region raster=elevation -p
r.basin map=elevation prefix=my_basin coord=637304.924954,218617.100523 \
 dir=/tmp/my_basin threshold=1000

# visualize some results
d.mon wx0
d.rast my_basin_elevation_hack

d.rast my_basin_elevation_dist2out

d.his i=aspect h=my_basin_elevation_dist2out
```

[![image-alt](r_basin_map.png)](r_basin_map.png)

### Dependencies

- Matplotlib
- r.hypso
- r.stream.basins
- r.stream.distance
- r.stream.extract
- r.stream.order
- r.stream.snap
- r.stream.stats
- r.width.funct

## Known issues

- r.basin hasn't been designed for working in lat/long coordinates.
    This means that if you are working in lat/long coordinates, you need
    to reproject your map first in order to apply the tool.
- r.basin is designed to work in meters unit. The values that you get
    using feet are nonsense.
- r.basin does not handle overwrite. You need to delete the output
    products already created (maps, text files, figures) by hand before
    running it again.

## SEE ALSO

*[r.hypso](r.hypso.md) (Addon), [r.stream.basins](r.stream.basins.md)
(Addon), [r.stream.channel](r.stream.channel.md) (Addon),
[r.stream.distance](r.stream.distance.md) (Addon),
[r.stream.extract](https://grass.osgeo.org/grass-stable/manuals/r.stream.extract.html),
[r.stream.order](r.stream.order.md) (Addon),
[r.stream.segment](r.stream.segment.md) (Addon),
[r.stream.slope](r.stream.slope.md) (Addon),
[r.stream.snap](r.stream.snap.md) (Addon),
[r.stream.stats](r.stream.stats.md) (Addon),
[r.watershed](https://grass.osgeo.org/grass-stable/manuals/r.watershed.html),
[r.width.funct](r.width.funct.md) (Addon)  
Related [Wiki page](https://grasswiki.osgeo.org/wiki/R.basin)*

## CITE AS

Di Leo Margherita, Di Stefano Massimo (2013) An Open-Source Approach for
Catchment's Physiographic Characterization, Abstract H52E-06 presented
at 2013 Fall Meeting, AGU, San Francisco, CA, USA 9-13 Dec.
[abstract](http://abstractsearch.agu.org/meetings/2013/FM/sections/H/sessions/H52E/abstracts/H52E-06.html)

## REFERENCES

- *Rodriguez-Iturbe I., Rinaldo A. (2001) Fractal River Basins, Chance
    and Self-Organization. Cambridge Press*
- *In Italian: Di Leo M., Di Stefano M., Claps P., Sole A. (2010)
    Caratterizzazione morfometrica del bacino idrografico in GRASS GIS
    (Morphometric characterization of the catchment in GRASS GIS
    environment), [Geomatics
    Workbooks](https://www.geolab.polimi.it/volume-9/), n. 9*

## AUTHORS

Margherita Di Leo (grass-dev AT lists DOT osgeo DOT org ), Massimo Di
Stefano

## SOURCE CODE

Available at: [r.basin source code](https://github.com/OSGeo/grass-addons/tree/grass8/src/raster/r.basin)
([history](https://github.com/OSGeo/grass-addons/commits/grass8/src/raster/r.basin))  
Latest change: Friday Feb 21 10:10:05 2025 in commit [7d78fe3](https://github.com/OSGeo/grass-addons/commit/7d78fe34868674c3b6050ba1924e1c5675d155c9)
