---
name: r.category.trim.py
description: Export categories and corresponding colors as QGIS color file or csv file. Non-existing categories and their color definitions will be removed.
keywords: [ raster, color, color table, category ]
---

# r.category.trim.py

Export categories and corresponding colors as QGIS color file or csv file. Non-existing categories and their color definitions will be removed.

=== "Command line"

    **r.category.trim.py**
    [**-n**]
    **input**=*name*
    [**output**=*name*]
    [**csv**=*name*]
    [**qgis**=*name*]
    [**--overwrite**]
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    r.category.trim.py input=name
    ```

=== "Python (grass.script)"

    *grass.script.run_command*("***r.category.trim.py***",
        **input**,
        **output**=*None*,
        **csv**=*None*,
        **qgis**=*None*,
        **flags**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.run_command("r.category.trim.py", input="name")
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.r_category_trim_py*(**input**,
        **output**=*None*,
        **csv**=*None*,
        **qgis**=*None*,
        **flags**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.r_category_trim_py(input="name")
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **input**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;input map  
    **output**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;output map  
    **csv**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Attribute table (csv format)  
    **qgis**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;QGIS color file (txt format)  
    **-n**  
    &nbsp;&nbsp;&nbsp;&nbsp;Recode layer to get consecutive category values  
    **--overwrite**  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **input** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;input map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **output** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;output map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster, *name*  
    **csv** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Attribute table (csv format)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, file, *name*  
    **qgis** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;QGIS color file (txt format)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, file, *name*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *n*  
    &nbsp;&nbsp;&nbsp;&nbsp;**n**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Recode layer to get consecutive category values  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **input** : str | np.ndarray, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;input map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **output** : str | type(np.ndarray) | type(np.array) | type(gs.array.array), *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;output map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster, *name*  
    **csv** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Attribute table (csv format)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, file, *name*  
    **qgis** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;QGIS color file (txt format)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, file, *name*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *n*  
    &nbsp;&nbsp;&nbsp;&nbsp;**n**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Recode layer to get consecutive category values  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | np.ndarray | tuple[np.ndarray] | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned. If an array type (e.g., *np.ndarray*) is used for one of the raster outputs, the result will be an array and will have the shape corresponding to the computational region. If an array type is used for more than one raster output, the result will be a tuple of arrays.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

### Trim redundant category labels and colors

In GRASS you can 'cut out' a subset of a larger raster layer by setting
the extent to something smaller than the extent of the original map
using g.region and/or by setting a mask using r.mask, after which you
simply run r.mapcalc "newmap = oldmap".

You may have noticed that when creating the new map, all category labels
and colour table of the original map are copied over to the new map,
even for category values that are not in the new map. If you are working
with categorical maps, this may not be what you want. See
[categorical maps and legends](https://pvanb.wordpress.com/2015/09/22/categorical-maps-and-legends/)
for a more detailed discussion.

With this addon you can trim the category and colour tables so it only
contains category labels and colour definitions for the values present
in the new map. You can do this on the input map, or do this on a copy
of the map.

### Recode to consecutive category values

If you prefer the map to have consecutive values (i.e., without gaps),
there is the option to change the category values to a consecutive
series by setting the n-flag. For example, if the map has the following
categories values and labels (after the redundant category labels have
been removed):

```text
2 label2
5 label5
9 label9
```

Then the new recoded layer will have the category values and labels:

```text
1 label2
2 label5
3 label9
```

### Export QGIS color map file

The addon let's you export the categories, category labels and colours
as QGIS colour map file. This is just a simple text file with the raster
categories and corresponding colour definitions and category labels.
QGIS can use this to set the colour and labels for a raster layer. See
[this
blogpost](https://pvanb.wordpress.com/2015/09/22/categorical-maps-and-legends/)
for more details how to use the colour map file in QGIS. Alternatively,
you can also export the categories and category labels as a normal comma
separated values (CSV) file, which can be easily viewed in a spreadsheet
program such as Libre/Open Office Calc, Microsoft Excel, or Google Docs
and can be easily shared together with an exported raster file for users
that use other GIS programs.

## NOTE

The file is only useful for categorical maps. Therefore only integer
maps are accepted as input. To export color maps for continuous raster
layers (or as an alternative to this plugin), have a look at the
r.colors.out\_sld plugin. To get QGIS color files, you need a two-step
approach: (1) create a sld file using the r.colors.out\_sld plugin, and
(2) in QGIS, use the SLD4raster plugin to convert this to a qml file.

When you use the option to recode the map, you need to set an output map
as well. It uses the
*[r.recode](https://grass.osgeo.org/grass-stable/manuals/r.recode.html)*
function, with the 'a' flag set, i.e., the region is aligned to the
input raster map.

## Examples

See the blogpost
[grass-gis-categorical-raster-layers-in-qgis](https://pvanb.wordpress.com/grass-gis-categorical-raster-layers-in-qgis)
for examples

## See also

*[r.category](https://grass.osgeo.org/grass-stable/manuals/r.category.html),
[r.colors](https://grass.osgeo.org/grass-stable/manuals/r.colors.html),
[r.recode](https://grass.osgeo.org/grass-stable/manuals/r.recode.html)
[r.colors.out\_sld](r.colors.out_sld.md)*

## AUTHOR

Paulo van Breugel, paulo at ecodiv.earth

## SOURCE CODE

Available at: [r.category.trim source code](https://github.com/OSGeo/grass-addons/tree/grass8/src/raster/r.category.trim)
([history](https://github.com/OSGeo/grass-addons/commits/grass8/src/raster/r.category.trim))  
Latest change: Friday Jan 23 11:36:31 2026 in commit [d3db45e](https://github.com/OSGeo/grass-addons/commit/d3db45e2713a8d17b0f5c59c83c45febf91165c4)
