---
name: r.colors.cubehelix.py
description: Create or apply a cubehelix color table to a GRASS raster map
keywords: [ raster, color table, cubehelix, seaborn ]
---

# r.colors.cubehelix.py

Create or apply a cubehelix color table to a GRASS raster map

=== "Command line"

    **r.colors.cubehelix.py**
    [**-dngae**]
    [**map**=*name* [,*name*,...]]
    [**output**=*name*]
    [**start**=*float*]
    [**nrotations**=*float*]
    [**gamma**=*float*]
    [**hue**=*float*]
    [**light**=*float*]
    [**dark**=*float*]
    [**ncolors**=*integer*]
    [**--overwrite**]
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    r.colors.cubehelix.py
    ```

=== "Python (grass.script)"

    *grass.script.run_command*("***r.colors.cubehelix.py***",
        **map**=*None*,
        **output**=*None*,
        **start**=*0*,
        **nrotations**=*0.4*,
        **gamma**=*1.0*,
        **hue**=*0.8*,
        **light**=*0.85*,
        **dark**=*0.15*,
        **ncolors**=*6*,
        **flags**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.run_command("r.colors.cubehelix.py")
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.r_colors_cubehelix_py*(**map**=*None*,
        **output**=*None*,
        **start**=*0*,
        **nrotations**=*0.4*,
        **gamma**=*1.0*,
        **hue**=*0.8*,
        **light**=*0.85*,
        **dark**=*0.15*,
        **ncolors**=*6*,
        **flags**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.r_colors_cubehelix_py()
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **map**=*name* [,*name*,...]  
    &nbsp;&nbsp;&nbsp;&nbsp;Raster map(s) to apply color table to  
    **output**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for the new color table rules file  
    **start**=*float*  
    &nbsp;&nbsp;&nbsp;&nbsp;The hue at the start of the helix  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *0-3*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0*  
    **nrotations**=*float*  
    &nbsp;&nbsp;&nbsp;&nbsp;Rotations around the hue wheel  
    &nbsp;&nbsp;&nbsp;&nbsp;Rotations around the hue wheel over the range of the color table  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *0-3*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0.4*  
    **gamma**=*float*  
    &nbsp;&nbsp;&nbsp;&nbsp;Gamma factor to emphasize darker (&lt;1) or lighter (&gt;1) colors  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *0-*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1.0*  
    **hue**=*float*  
    &nbsp;&nbsp;&nbsp;&nbsp;Saturation of the colors  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *0-1*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0.8*  
    **light**=*float*  
    &nbsp;&nbsp;&nbsp;&nbsp;Intensity of the lightest color in the color table  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *0-1*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0.85*  
    **dark**=*float*  
    &nbsp;&nbsp;&nbsp;&nbsp;Intensity of the darkest color in the color table  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *0-1*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0.15*  
    **ncolors**=*integer*  
    &nbsp;&nbsp;&nbsp;&nbsp;Number of colors in the color table  
    &nbsp;&nbsp;&nbsp;&nbsp;Number of color intervals in a discrete color table with -d  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *2-*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *6*  
    **-d**  
    &nbsp;&nbsp;&nbsp;&nbsp;Generate discrete color table  
    &nbsp;&nbsp;&nbsp;&nbsp;Generate discrete (interval) color table instead of a continuous one  
    **-n**  
    &nbsp;&nbsp;&nbsp;&nbsp;Reverse the order of colors (invert colors)  
    &nbsp;&nbsp;&nbsp;&nbsp;If set, the color table will go from dark to light  
    **-g**  
    &nbsp;&nbsp;&nbsp;&nbsp;Logarithmic scaling  
    **-a**  
    &nbsp;&nbsp;&nbsp;&nbsp;Logarithmic-absolute scaling  
    **-e**  
    &nbsp;&nbsp;&nbsp;&nbsp;Histogram equalization  
    **--overwrite**  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **map** : str | list[str], *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Raster map(s) to apply color table to  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **output** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for the new color table rules file  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, file, *name*  
    **start** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;The hue at the start of the helix  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *0-3*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0*  
    **nrotations** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Rotations around the hue wheel  
    &nbsp;&nbsp;&nbsp;&nbsp;Rotations around the hue wheel over the range of the color table  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *0-3*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0.4*  
    **gamma** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Gamma factor to emphasize darker (&lt;1) or lighter (&gt;1) colors  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *0-*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1.0*  
    **hue** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Saturation of the colors  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *0-1*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0.8*  
    **light** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Intensity of the lightest color in the color table  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *0-1*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0.85*  
    **dark** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Intensity of the darkest color in the color table  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *0-1*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0.15*  
    **ncolors** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Number of colors in the color table  
    &nbsp;&nbsp;&nbsp;&nbsp;Number of color intervals in a discrete color table with -d  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *2-*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *6*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *d*, *n*, *g*, *a*, *e*  
    &nbsp;&nbsp;&nbsp;&nbsp;**d**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Generate discrete color table  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Generate discrete (interval) color table instead of a continuous one  
    &nbsp;&nbsp;&nbsp;&nbsp;**n**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Reverse the order of colors (invert colors)  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;If set, the color table will go from dark to light  
    &nbsp;&nbsp;&nbsp;&nbsp;**g**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Logarithmic scaling  
    &nbsp;&nbsp;&nbsp;&nbsp;**a**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Logarithmic-absolute scaling  
    &nbsp;&nbsp;&nbsp;&nbsp;**e**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Histogram equalization  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **map** : str | list[str], *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Raster map(s) to apply color table to  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **output** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for the new color table rules file  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, file, *name*  
    **start** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;The hue at the start of the helix  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *0-3*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0*  
    **nrotations** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Rotations around the hue wheel  
    &nbsp;&nbsp;&nbsp;&nbsp;Rotations around the hue wheel over the range of the color table  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *0-3*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0.4*  
    **gamma** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Gamma factor to emphasize darker (&lt;1) or lighter (&gt;1) colors  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *0-*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1.0*  
    **hue** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Saturation of the colors  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *0-1*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0.8*  
    **light** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Intensity of the lightest color in the color table  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *0-1*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0.85*  
    **dark** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Intensity of the darkest color in the color table  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *0-1*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0.15*  
    **ncolors** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Number of colors in the color table  
    &nbsp;&nbsp;&nbsp;&nbsp;Number of color intervals in a discrete color table with -d  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *2-*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *6*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *d*, *n*, *g*, *a*, *e*  
    &nbsp;&nbsp;&nbsp;&nbsp;**d**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Generate discrete color table  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Generate discrete (interval) color table instead of a continuous one  
    &nbsp;&nbsp;&nbsp;&nbsp;**n**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Reverse the order of colors (invert colors)  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;If set, the color table will go from dark to light  
    &nbsp;&nbsp;&nbsp;&nbsp;**g**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Logarithmic scaling  
    &nbsp;&nbsp;&nbsp;&nbsp;**a**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Logarithmic-absolute scaling  
    &nbsp;&nbsp;&nbsp;&nbsp;**e**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Histogram equalization  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

The *r.colors.cubehelix* module generates a cubehelix color table and
assigns it to a given raster map if requested. The color table is
generated using *seaborn* Python package. Several parameters are
available to control the cubehelix. When option **map** is specified
*r.colors.cubehelix* assigns the color rules to the given raster map.
The color tables are always stretched based on the range of values of
the map

Depending on the use case, it may be advantageous to use the **-d** to
discretize the color table into intervals.

## NOTES

This module depends on
*[seaborn](https://seaborn.pydata.org/index.html)* which needs to be
installed on your computer. Use your Python package manager (e.g. *pip*)
or distribution package manager to install it.

## EXAMPLES

### Creating a color table as GRASS color rules

We do 0.6 rotation around the axis and use discrete (interval) color
table rather than the standard continuous. If we don't specify output
file, it is printed to standard output:

```sh
r.colors.cubehelix -d ncolors=5 nrotations=0.6
```

```text
0.000% 218:222:192
20.000% 218:222:192
20.000% 198:166:136
40.000% 198:166:136
40.000% 173:108:112
60.000% 173:108:112
60.000% 119:61:98
80.000% 119:61:98
80.000% 48:28:59
100.000% 48:28:59
```

### Setting color table for a raster map

Now we set several different color tables for the elevation raster map
from the North Carolina sample dataset. We use continuous and discrete
color tables (gradients). The color tables are stretched to fit the
raster map range.

```sh
r.colors.cubehelix -d ncolors=8 nrotations=0.6 map=elevation
```

We can display legend:

```sh
d.legend raster=elevation labelnum=10 at=5,50,7,10
```

Here we set continuous color table with more colors

```sh
r.colors.cubehelix nrotations=1.4 start=4 map=elevation
```

![image-alt](r_colors_cubehelix_two_colors.png)
![image-alt](r_colors_cubehelix.png)

### Setting color table for a vector map

First we create a text file with color rules:

```sh
r.colors.cubehelix -i rot=0.6 output=cubehelix.txt
```

Then we set color table for the vector to the rules stored in a file:

```sh
v.colors map=points rules=cubehelix.txt
```

Color table for 3D raster map can be set in the same way.

## REFERENCES

- Green, D. A., 2011, [*A colour scheme for the display of
    astronomical intensity
    images*](https://astron-soc.in/bulletin/11June/289392011.pdf),
    Bulletin of the Astronomical Society of India, 39, 289.

## SEE ALSO

*[r.colors](https://grass.osgeo.org/grass-stable/manuals/r.colors.html),
[v.colors](https://grass.osgeo.org/grass-stable/manuals/v.colors.html),
[r3.colors](https://grass.osgeo.org/grass-stable/manuals/r3.colors.html),
[r.cpt2grass](r.cpt2grass.md),
[r.colors.matplotlib](r.colors.matplotlib.md)*

seaborn
[cubehelix\_palette](https://seaborn.pydata.org/generated/seaborn.cubehelix_palette.html)
function documentation and an
[example](https://seaborn.pydata.org/examples/palette_generation.html)

## AUTHOR

Vaclav Petras, [NCSU GeoForAll
Lab](httpss://geospatial.ncsu.edu/geoforall/)

## SOURCE CODE

Available at: [r.colors.cubehelix source code](https://github.com/OSGeo/grass-addons/tree/grass8/src/raster/r.colors.cubehelix)
([history](https://github.com/OSGeo/grass-addons/commits/grass8/src/raster/r.colors.cubehelix))  
Latest change: Thursday Mar 20 21:36:57 2025 in commit [7286ecf](https://github.com/OSGeo/grass-addons/commit/7286ecf7af235bfd089fb9b1b82fb383cf95f3fc)
