---
name: r.colors.out_sld.py
description: Exports the color table associated with a raster map layer in SLD format.
keywords: [ raster, export, color table ]
---

# r.colors.out_sld.py

Exports the color table associated with a raster map layer in SLD format.

=== "Command line"

    **r.colors.out_sld.py**
    [**-n**]
    **map**=*name*
    [**style_name**=*string*]
    [**output**=*name*]
    [**--overwrite**]
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    r.colors.out_sld.py map=name
    ```

=== "Python (grass.script)"

    *grass.script.run_command*("***r.colors.out_sld.py***",
        **map**,
        **style_name**=*"GRASS GIS color table"*,
        **output**=*"-"*,
        **flags**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.run_command("r.colors.out_sld.py", map="name")
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.r_colors_out_sld_py*(**map**,
        **style_name**=*"GRASS GIS color table"*,
        **output**=*"-"*,
        **flags**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.r_colors_out_sld_py(map="name")
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **map**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of raster map  
    **style_name**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for style  
    &nbsp;&nbsp;&nbsp;&nbsp;A name for the style which might be displayed on the server  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *GRASS GIS color table*  
    **output**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output SLD rules file  
    &nbsp;&nbsp;&nbsp;&nbsp;"-" to write to stdout  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *-*  
    **-n**  
    &nbsp;&nbsp;&nbsp;&nbsp;Propagate NULLs  
    **--overwrite**  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **map** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **style_name** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for style  
    &nbsp;&nbsp;&nbsp;&nbsp;A name for the style which might be displayed on the server  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *GRASS GIS color table*  
    **output** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output SLD rules file  
    &nbsp;&nbsp;&nbsp;&nbsp;"-" to write to stdout  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, file, *name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *-*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *n*  
    &nbsp;&nbsp;&nbsp;&nbsp;**n**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Propagate NULLs  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **map** : str | np.ndarray, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **style_name** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for style  
    &nbsp;&nbsp;&nbsp;&nbsp;A name for the style which might be displayed on the server  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *GRASS GIS color table*  
    **output** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output SLD rules file  
    &nbsp;&nbsp;&nbsp;&nbsp;"-" to write to stdout  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, file, *name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *-*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *n*  
    &nbsp;&nbsp;&nbsp;&nbsp;**n**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Propagate NULLs  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

The module *r.colors.out\_sld* exports the colors of a raster map into
the Styled Layer Description (SLD) format according to OGC standard.

For raster maps of type CELL also labels are exported. The export of
labels requires that the input map is entirely read and may thus take a
bit longer than the export of continuous color rules (ramp).

Only if the flag **n** is given, the NaN values are written into the
generated SLD file which leads e.g. in GeoServer to an error when using
such SLD.

Currently only SLD v1.0.0 is implemented.

## EXAMPLES

```sh
# Exporting a color ramp
r.colors.out_sld map=testmap style_name=Celsius
```

## SEE ALSO

[r.colors.out](https://grass.osgeo.org/grass-stable/manuals/r.colors.out.html)

## REFERENCES

<https://www.ogc.org/standard/sld>

## AUTHORS

Hamish Bowman  
Stefan Blumentrath, Norwegian Institute for Nature Research, Oslo,
Norway

## SOURCE CODE

Available at: [r.colors.out_sld source code](https://github.com/OSGeo/grass-addons/tree/grass8/src/raster/r.colors.out_sld)
([history](https://github.com/OSGeo/grass-addons/commits/grass8/src/raster/r.colors.out_sld))  
Latest change: Thursday Feb 20 13:02:26 2025 in commit [53de819](https://github.com/OSGeo/grass-addons/commit/53de8196a10ba5a8a9121898ce87861d227137e3)
