---
name: r.colors.qml.py
description: Applies GRASS raster colors and category labels from a QGIS .qml style file. Supports paletted and singleband pseudocolor renderers.
keywords: [ raster, color table, category, QGIS ]
---

# r.colors.qml.py

Applies GRASS raster colors and category labels from a QGIS .qml style file. Supports paletted and singleband pseudocolor renderers.

=== "Command line"

    **r.colors.qml.py**
    [**-clnd**]
    **map**=*name*
    **qml**=*name*
    [**separator**=*character*]
    [**default_color**=*name*]
    [**null_value**=*float*]
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    r.colors.qml.py map=name qml=name
    ```

=== "Python (grass.script)"

    *grass.script.run_command*("***r.colors.qml.py***",
        **map**,
        **qml**,
        **separator**=*"tab"*,
        **default_color**=*"255:255:255"*,
        **null_value**=*None*,
        **flags**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.run_command("r.colors.qml.py", map="name", qml="name")
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.r_colors_qml_py*(**map**,
        **qml**,
        **separator**=*"tab"*,
        **default_color**=*"255:255:255"*,
        **null_value**=*None*,
        **flags**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.r_colors_qml_py(map="name", qml="name")
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **map**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Raster map to style  
    **qml**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Input QGIS .qml style file  
    **separator**=*character*  
    &nbsp;&nbsp;&nbsp;&nbsp;Field separator  
    &nbsp;&nbsp;&nbsp;&nbsp;Field separator for category rules  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *tab*  
    **default_color**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Color  
    &nbsp;&nbsp;&nbsp;&nbsp;Default color (used for out-of-range values when clip is enabled)  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *255:255:255*  
    **null_value**=*float*  
    &nbsp;&nbsp;&nbsp;&nbsp;Value(s) to set to NULL  
    **-c**  
    &nbsp;&nbsp;&nbsp;&nbsp;Apply colors only  
    **-l**  
    &nbsp;&nbsp;&nbsp;&nbsp;Apply labels only  
    **-n**  
    &nbsp;&nbsp;&nbsp;&nbsp;Only print color and category rules to stdout  
    **-d**  
    &nbsp;&nbsp;&nbsp;&nbsp;For singlebandpseudocolor, force discrete (stepped) color rules  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **map** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Raster map to style  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **qml** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Input QGIS .qml style file  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, file, *name*  
    **separator** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Field separator  
    &nbsp;&nbsp;&nbsp;&nbsp;Field separator for category rules  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, separator, *character*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *tab*  
    **default_color** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Color  
    &nbsp;&nbsp;&nbsp;&nbsp;Default color (used for out-of-range values when clip is enabled)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, color, *name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *255:255:255*  
    **null_value** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Value(s) to set to NULL  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *c*, *l*, *n*, *d*  
    &nbsp;&nbsp;&nbsp;&nbsp;**c**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Apply colors only  
    &nbsp;&nbsp;&nbsp;&nbsp;**l**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Apply labels only  
    &nbsp;&nbsp;&nbsp;&nbsp;**n**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Only print color and category rules to stdout  
    &nbsp;&nbsp;&nbsp;&nbsp;**d**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;For singlebandpseudocolor, force discrete (stepped) color rules  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **map** : str | np.ndarray, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Raster map to style  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **qml** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Input QGIS .qml style file  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, file, *name*  
    **separator** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Field separator  
    &nbsp;&nbsp;&nbsp;&nbsp;Field separator for category rules  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, separator, *character*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *tab*  
    **default_color** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Color  
    &nbsp;&nbsp;&nbsp;&nbsp;Default color (used for out-of-range values when clip is enabled)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, color, *name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *255:255:255*  
    **null_value** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Value(s) to set to NULL  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *c*, *l*, *n*, *d*  
    &nbsp;&nbsp;&nbsp;&nbsp;**c**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Apply colors only  
    &nbsp;&nbsp;&nbsp;&nbsp;**l**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Apply labels only  
    &nbsp;&nbsp;&nbsp;&nbsp;**n**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Only print color and category rules to stdout  
    &nbsp;&nbsp;&nbsp;&nbsp;**d**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;For singlebandpseudocolor, force discrete (stepped) color rules  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

*r.colors.qml* applies raster symbology defined in QGIS in a QML style file to
the same raster in GRASS. The user provides the QML style file and the raster to
which to apply the symbology (color and labels) from that file.

![From QGIS through QML to GRASS color table and categories](r_colors_qml.png)

QML is a format for storing layer styling in QGIS, including the colors and
labels that are defined under symbology. The addon extracts the raster colors
and the raster labels and uses these to construct the color table and raster
categories in GRASS.

### Singleband Pseudocolor

- Continuous (Interpolated): Generates a smooth color gradient.
- Discrete: QGIS discrete classes are translated into GRASS "step" rules by
  duplicating boundary values, creating hard color transitions without
  gradients.
- Forced Discrete: Users can force a continuous QGIS ramp to be interpreted as
  discrete steps using the **-d** flag.

### Paletted (Unique Values)

Treated as an exact mapping. Each unique value in the palette is assigned its
specific color and label. Other colors are assigned the default color (white or
user-defined).

### Range and Clipping Behavior

The effective range is determined by the minimum and maximum values defined in
the QGIS settings. If undefined, the lowest and highest values found in the
color ramp items are used.

By default, for raster values outside the effective range, the color ramp is
extended to infinity. I.e., values below the defined minimum inherit the start
color, and values above the defined maximum inherit the end color. If clipping
is enabled, values outside the effective range are assigned the default color
(default: white).

## NOTE

Transparency is silently ignored, as this is not supported by GRASS.

There are many different ways to style a raster in QGIS, and not all
combinations have been checked. In case a QML file does not result in the
expected styling in GRASS, carefully check your settings first.

Text labels defined in the QGIS symbology are extracted and applied using
*r.category*. Any characters in the label that match the output field separator
are replaced with a space.

## EXAMPLES

Apply both colors and labels defined in the landclass96.qml file to the raster
layer **landclass96** in GRASS.

```sh
r.colors.qml map=landclass96 qml=landclass96.qml
```

## SEE ALSO

*[r.category.trim](https://grass.osgeo.org/grass-stable/manuals/addons/r.category.trim.html)*

## AUTHOR

[Paulo van Breugel](https://ecodiv.earth), [HAS green academy](https://has.nl),
[Innovative Biomonitoring research
group](https://www.has.nl/en/research/professorships/innovative-bio-monitoring-professorship/),
[Climate-robust Landscapes research
group](https://www.has.nl/en/research/professorships/climate-robust-landscapes-professorship/)

## SOURCE CODE

Available at: [r.colors.qml source code](https://github.com/OSGeo/grass-addons/tree/grass8/src/raster/r.colors.qml)
([history](https://github.com/OSGeo/grass-addons/commits/grass8/src/raster/r.colors.qml))  
Latest change: Saturday Jan 17 19:11:52 2026 in commit [f9e94e9](https://github.com/OSGeo/grass-addons/commit/f9e94e9bae908a4e1f793882f94a0eb5849b6179)
