---
name: r.colors.toqml.py
description: Exports GRASS raster colors and category labels to a QGIS .qml style file. Optionally exports the raster to GeoTIFF with the same basename.
keywords: [ raster, color table, category, QGIS ]
---

# r.colors.toqml.py

Exports GRASS raster colors and category labels to a QGIS .qml style file. Optionally exports the raster to GeoTIFF with the same basename.

=== "Command line"

    **r.colors.toqml.py**
    [**-rdc**]
    **map**=*name*
    **output**=*name*
    [**--overwrite**]
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    r.colors.toqml.py map=name output=name
    ```

=== "Python (grass.script)"

    *grass.script.run_command*("***r.colors.toqml.py***",
        **map**,
        **output**,
        **flags**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.run_command("r.colors.toqml.py", map="name", output="name")
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.r_colors_toqml_py*(**map**,
        **output**,
        **flags**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.r_colors_toqml_py(map="name", output="name")
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **map**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Input GRASS raster map  
    **output**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Output QGIS .qml style file  
    **-r**  
    &nbsp;&nbsp;&nbsp;&nbsp;Export raster as GeoTIFF  
    &nbsp;&nbsp;&nbsp;&nbsp;Export the raster to GeoTIFF with the same basename as the QML  
    **-d**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force discrete/paletted style  
    &nbsp;&nbsp;&nbsp;&nbsp;For CELL: force 'Paletted' (unique values) even if no categories exist. For FCELL/DCELL: force 'SinglebandPseudocolor' with DISCRETE interpolation (bins).  
    **-c**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force continuous/linear style  
    &nbsp;&nbsp;&nbsp;&nbsp;Force 'SinglebandPseudocolor' with LINEAR interpolation. If CELL map has categories, they are ignored.  
    **--overwrite**  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **map** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Input GRASS raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **output** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Output QGIS .qml style file  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, file, *name*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *r*, *d*, *c*  
    &nbsp;&nbsp;&nbsp;&nbsp;**r**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Export raster as GeoTIFF  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Export the raster to GeoTIFF with the same basename as the QML  
    &nbsp;&nbsp;&nbsp;&nbsp;**d**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Force discrete/paletted style  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;For CELL: force 'Paletted' (unique values) even if no categories exist. For FCELL/DCELL: force 'SinglebandPseudocolor' with DISCRETE interpolation (bins).  
    &nbsp;&nbsp;&nbsp;&nbsp;**c**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Force continuous/linear style  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Force 'SinglebandPseudocolor' with LINEAR interpolation. If CELL map has categories, they are ignored.  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **map** : str | np.ndarray, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Input GRASS raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **output** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Output QGIS .qml style file  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, file, *name*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *r*, *d*, *c*  
    &nbsp;&nbsp;&nbsp;&nbsp;**r**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Export raster as GeoTIFF  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Export the raster to GeoTIFF with the same basename as the QML  
    &nbsp;&nbsp;&nbsp;&nbsp;**d**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Force discrete/paletted style  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;For CELL: force 'Paletted' (unique values) even if no categories exist. For FCELL/DCELL: force 'SinglebandPseudocolor' with DISCRETE interpolation (bins).  
    &nbsp;&nbsp;&nbsp;&nbsp;**c**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Force continuous/linear style  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Force 'SinglebandPseudocolor' with LINEAR interpolation. If CELL map has categories, they are ignored.  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

*r.colors.toqml* exports raster symbology defined in GRASS GIS to a QGIS QML
style file. The addon reads the GRASS raster color table and, where applicable,
raster category labels, and writes a QML file that can be used to style the
raster in QGIS.

Optionally, the raster itself can be exported simultaneously to GeoTIFF, using
the same basename as the QML file. As long as the two files are kept in the same
folder, opening the GeoTIFF in QGIS will automatically apply the style.

![From GRASS through QML to QGIS raster symbology](r_colors_toqml.png)

The addon supports both **Categorical rasters** (CELL with/without categories),
exported as *paletted* QGIS renderers and **Continuous rasters** (FCELL/DCELL),
exported as *singleband pseudocolor* renderers with interpolated or discrete
color ramps.

For categorical rasters, only categories actually present in the current
computational region and MASK are included in the QML file.

## NOTE

Percentage-based color rules are not supported and cause the module to fail.
such rules are relative to the raster range in GRASS and cannot be faithfully
represented in a QGIS QML style, which requires absolute numeric breakpoints.

## KNOWN ISSUES

Continuous range vs. breakpoints: for continuous rasters, the QML range is
derived from the numeric color-rule breakpoints. If the raster range in a given
region is narrower than the color table domain, QGIS will still show the full
ramp domain defined by the breakpoints.

Category subset in current region: for categorical rasters, the exported palette
is filtered to categories present in the current region/MASK. If you want a
palette for the full raster extent, set the computational region to the full
raster before running the module.

## EXAMPLES

Export the color table and category labels of a categorical raster to a QML
file:

```sh
r.colors.toqml map=landclass96 output=landclass96.qml
```

Export a continuous raster color table to QML and simultaneously export the
raster to GeoTIFF:

```sh
r.colors.toqml -r map=cfactor output=cfactor.qml
```

Force a discrete color ramp for a continuous raster:

```sh
r.colors.toqml -r map=cfactor output=cfactor.qml discrete=yes
```

## SEE ALSO

*[r.colors.out](https://grass.osgeo.org/grass-stable/manuals/r.colors.out.html)*,
*[r.colors.qml](https://grass.osgeo.org/grass-stable/manuals/addons/r.colors.qml.html)*

## AUTHOR

[Paulo van Breugel](https://ecodiv.earth), [HAS green academy](https://has.nl),
[Innovative Biomonitoring research group](https://www.has.nl/en/research/professorships/innovative-bio-monitoring-professorship/),
[Climate-robust Landscapes research group](https://www.has.nl/en/research/professorships/climate-robust-landscapes-professorship)

## SOURCE CODE

Available at: [r.colors.toqml source code](https://github.com/OSGeo/grass-addons/tree/grass8/src/raster/r.colors.toqml)
([history](https://github.com/OSGeo/grass-addons/commits/grass8/src/raster/r.colors.toqml))  
Latest change: Monday Jan 19 23:04:27 2026 in commit [619af32](https://github.com/OSGeo/grass-addons/commit/619af32fc64428e3548aedba6eee30397693435e)
