---
name: r.confusionmatrix.py
description: Calculates a confusion matrix and accuracies for a given classification using r.kappa.
keywords: [ raster, statistics, accuracy, classification ]
---

# r.confusionmatrix.py

Calculates a confusion matrix and accuracies for a given classification using r.kappa.

=== "Command line"

    **r.confusionmatrix.py**
    [**-dm**]
    [**classification**=*name*]
    [**raster_reference**=*name*]
    [**vector_reference**=*name*]
    [**column**=*name*]
    [**label_column**=*name*]
    [**csvfile**=*name*]
    [**--overwrite**]
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    r.confusionmatrix.py
    ```

=== "Python (grass.script)"

    *grass.script.run_command*("***r.confusionmatrix.py***",
        **classification**=*None*,
        **raster_reference**=*None*,
        **vector_reference**=*None*,
        **column**=*None*,
        **label_column**=*None*,
        **csvfile**=*None*,
        **flags**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.run_command("r.confusionmatrix.py")
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.r_confusionmatrix_py*(**classification**=*None*,
        **raster_reference**=*None*,
        **vector_reference**=*None*,
        **column**=*None*,
        **label_column**=*None*,
        **csvfile**=*None*,
        **flags**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.r_confusionmatrix_py()
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **classification**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of raster map containing classification result  
    **raster_reference**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of raster map containing reference classes  
    **vector_reference**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input vector map  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of vector map containing reference classes  
    **column**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of column in the vector map containing reference classes  
    **label_column**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of column used as raster category labels  
    **csvfile**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output csv file containing confusion matrix and accuracies  
    &nbsp;&nbsp;&nbsp;&nbsp;If not given write to standard output  
    **-d**  
    &nbsp;&nbsp;&nbsp;&nbsp;Description of the accuracies  
    **-m**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print output as a matrix  
    **--overwrite**  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **classification** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of raster map containing classification result  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **raster_reference** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of raster map containing reference classes  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **vector_reference** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input vector map  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of vector map containing reference classes  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, vector, *name*  
    **column** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of column in the vector map containing reference classes  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, dbcolumn, *name*  
    **label_column** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of column used as raster category labels  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *name*  
    **csvfile** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output csv file containing confusion matrix and accuracies  
    &nbsp;&nbsp;&nbsp;&nbsp;If not given write to standard output  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, file, *name*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *d*, *m*  
    &nbsp;&nbsp;&nbsp;&nbsp;**d**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Description of the accuracies  
    &nbsp;&nbsp;&nbsp;&nbsp;**m**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Print output as a matrix  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **classification** : str | np.ndarray, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of raster map containing classification result  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **raster_reference** : str | np.ndarray, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of raster map containing reference classes  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **vector_reference** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input vector map  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of vector map containing reference classes  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, vector, *name*  
    **column** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of column in the vector map containing reference classes  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, dbcolumn, *name*  
    **label_column** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of column used as raster category labels  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *name*  
    **csvfile** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output csv file containing confusion matrix and accuracies  
    &nbsp;&nbsp;&nbsp;&nbsp;If not given write to standard output  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, file, *name*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *d*, *m*  
    &nbsp;&nbsp;&nbsp;&nbsp;**d**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Description of the accuracies  
    &nbsp;&nbsp;&nbsp;&nbsp;**m**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Print output as a matrix  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

*r.confusionmatrix* calculates the confusion matrix, overall, user and
producer accuracies, the omission and commission errors and the Kappa
coefficient of classification result using *r.kappa*.

## NOTES

The reference can be a raster map **raster\_reference** or a vector map
**vector\_reference** with a **column** containing the class labels as
integer numbers.

In case of vector reference, this map is rasterized according to the
extent and resolution of the **classification** raster map.

## EXAMPLE

Compute the confusion matrix as a CSV file including description of the
accuracies:

```sh
r.confusionmatrix classification=classified raster_reference=trainingmap csvfile=test.csv -d
```

## SEE ALSO

*[r.kappa](https://grass.osgeo.org/grass-stable/manuals/r.kappa.html)*

## AUTHOR

Anika Weinmann, [mundialis GmbH & Co. KG](https://www.mundialis.de/)

## SOURCE CODE

Available at: [r.confusionmatrix source code](https://github.com/OSGeo/grass-addons/tree/grass8/src/raster/r.confusionmatrix)
([history](https://github.com/OSGeo/grass-addons/commits/grass8/src/raster/r.confusionmatrix))  
Latest change: Thursday Feb 20 13:02:26 2025 in commit [53de819](https://github.com/OSGeo/grass-addons/commit/53de8196a10ba5a8a9121898ce87861d227137e3)
