---
name: r.connectivity.corridors.py
description: Compute corridors between habitat patches of an input-layer based on (cost) distance raster maps
keywords: [ raster, vector, corridor, cost distance, least cost paths ]
---

# r.connectivity.corridors.py

Compute corridors between habitat patches of an input-layer based on (cost) distance raster maps

=== "Command line"

    **r.connectivity.corridors.py**
    [**-sdr**]
    **input**=*Result from r.connectivity.network containing edge measures*
    **layer**=*string*
    [**weights**=*Column names* [,*Column names*,...]]
    [**where**=*where (SQL statement)*]
    **suffix**=*string*
    [**corridor_tolerance**=*float*]
    [**cores**=*integer*]
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    r.connectivity.corridors.py input=Result from r.connectivity.network containing edge measures layer=1 suffix=string
    ```

=== "Python (grass.script)"

    *grass.script.run_command*("***r.connectivity.corridors.py***",
        **input**,
        **layer**=*"1"*,
        **weights**=*None*,
        **where**=*None*,
        **suffix**,
        **corridor_tolerance**=*0.0*,
        **cores**=*1*,
        **flags**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.run_command("r.connectivity.corridors.py", input="Result from r.connectivity.network containing edge measures", layer="1", suffix="string")
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.r_connectivity_corridors_py*(**input**,
        **layer**=*"1"*,
        **weights**=*None*,
        **where**=*None*,
        **suffix**,
        **corridor_tolerance**=*0.0*,
        **cores**=*1*,
        **flags**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.r_connectivity_corridors_py(input="Result from r.connectivity.network containing edge measures", layer="1", suffix="string")
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **input**=*Result from r.connectivity.network containing edge measures* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input vector map  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of the table containing edge measures from r.connectivity.network  
    **layer**=*string* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Layer number or name  
    &nbsp;&nbsp;&nbsp;&nbsp;layer containing patch geometries  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1*  
    **weights**=*Column names* [,*Column names*,...]  
    &nbsp;&nbsp;&nbsp;&nbsp;Column names separated by commas  
    **where**=*where (SQL statement)*  
    &nbsp;&nbsp;&nbsp;&nbsp;WHERE conditions of SQL statement without 'where' keyword  
    &nbsp;&nbsp;&nbsp;&nbsp;where conditions of an SQL statement without 'where' keyword. (example: cf_mst_ud = 1 or cf_eb_ud &gt; 100)  
    **suffix**=*string* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Output suffix for corridor summary result  
    **corridor_tolerance**=*float*  
    &nbsp;&nbsp;&nbsp;&nbsp;Tolerance for deviation from (cost) distance within corridors (in %)  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0.0*  
    **cores**=*integer*  
    &nbsp;&nbsp;&nbsp;&nbsp;cores used for multithreading (1 means no multithreading)  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1*  
    **-s**  
    &nbsp;&nbsp;&nbsp;&nbsp;Show edges selected by where-clause and exit  
    **-d**  
    &nbsp;&nbsp;&nbsp;&nbsp;Assign distance values to corridors instead of connection ids and weights  
    **-r**  
    &nbsp;&nbsp;&nbsp;&nbsp;Recalculate already computed corridors (default is only weight and summarize already existing corridor maps)  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **input** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input vector map  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of the table containing edge measures from r.connectivity.network  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, vector, *Result from r.connectivity.network containing edge measures*  
    **layer** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Layer number or name  
    &nbsp;&nbsp;&nbsp;&nbsp;layer containing patch geometries  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, layer  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1*  
    **weights** : str | list[str], *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Column names separated by commas  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, dbcolumn, *Column names*  
    **where** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;WHERE conditions of SQL statement without 'where' keyword  
    &nbsp;&nbsp;&nbsp;&nbsp;where conditions of an SQL statement without 'where' keyword. (example: cf_mst_ud = 1 or cf_eb_ud &gt; 100)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, sql_query, *where (SQL statement)*  
    **suffix** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Output suffix for corridor summary result  
    **corridor_tolerance** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Tolerance for deviation from (cost) distance within corridors (in %)  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0.0*  
    **cores** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;cores used for multithreading (1 means no multithreading)  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *s*, *d*, *r*  
    &nbsp;&nbsp;&nbsp;&nbsp;**s**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Show edges selected by where-clause and exit  
    &nbsp;&nbsp;&nbsp;&nbsp;**d**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Assign distance values to corridors instead of connection ids and weights  
    &nbsp;&nbsp;&nbsp;&nbsp;**r**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Recalculate already computed corridors (default is only weight and summarize already existing corridor maps)  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **input** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input vector map  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of the table containing edge measures from r.connectivity.network  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, vector, *Result from r.connectivity.network containing edge measures*  
    **layer** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Layer number or name  
    &nbsp;&nbsp;&nbsp;&nbsp;layer containing patch geometries  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, layer  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1*  
    **weights** : str | list[str], *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Column names separated by commas  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, dbcolumn, *Column names*  
    **where** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;WHERE conditions of SQL statement without 'where' keyword  
    &nbsp;&nbsp;&nbsp;&nbsp;where conditions of an SQL statement without 'where' keyword. (example: cf_mst_ud = 1 or cf_eb_ud &gt; 100)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, sql_query, *where (SQL statement)*  
    **suffix** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Output suffix for corridor summary result  
    **corridor_tolerance** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Tolerance for deviation from (cost) distance within corridors (in %)  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0.0*  
    **cores** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;cores used for multithreading (1 means no multithreading)  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *s*, *d*, *r*  
    &nbsp;&nbsp;&nbsp;&nbsp;**s**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Show edges selected by where-clause and exit  
    &nbsp;&nbsp;&nbsp;&nbsp;**d**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Assign distance values to corridors instead of connection ids and weights  
    &nbsp;&nbsp;&nbsp;&nbsp;**r**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Recalculate already computed corridors (default is only weight and summarize already existing corridor maps)  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

r.connectivity.corridors is the 3rd tool of the r.connectivity.\*
toolset.

*r.connectivity.corridors* loops through the user-selected edges
(**where** option) of the edge-measure output vector map from
*r.connectivity.network* and computes the respective corridor(s).

Corridors are defined as all pixels that have a lower average cost
distance from a pair of patches than the average cost distance between
that pair. The user can add a tolerance for allowed deviation from cost
distance within corridors in %, using the **corridor\_tolerance**
option.

*r.connectivity.corridors* can account for the importance of the
corridors for the entire network by weighting them with regards to one
or more network measures from *r.connectivity.network*, using the
**weights** option.

Thus, *r.connectivity.corridors* produces two types of output, that are
named according to a user defined **prefix** and **suffix**:

1. a set of individual corridor raster maps (named:
    **prefix**\_corridor\_**edge\_id**\_**weight**) and
2. a summary over all computed corridors (named:
    **prefix**\_corridor\_**edge\_id**\_**weight**\_sum\_**suffix**).

Finally, all individual corridors are being put together using
*r.series*. In this step, the values of the cells in all corridor maps
are summed up, which indicates the importance of an area (raster cell)
for the network of the given patches (either the number of corridors a
cell is part of, or other graph-theoretical measures for corridor
importance).

## NOTES

Corridors are only computed for an undirected graph.

## EXAMPLE

The following example is continued from and based on the example in
*r.connectivity.network*\!

In this example two alternative (or to some extent complementary) sets
of corridors are calculated:

### Corridor set 1

For the first set, corridors are only computed for the minimum spanning
tree (in literature sometimes called the backbone of an ecological
network). This is specified in the "where"-parameter. Edge betweenness
values are used as weights, which represent the centrality of a
connection (edge) in a network (and is therewith a measure of
importance). The output is a set of corridor raster maps (named:
"prefix" \_corridor\_ "edge\_id" \_ "weight") and a summary over all
computed corridors (named: "prefix" \_corridor\_ "edge\_id" \_ "weight"
\_sum\_ "suffix").

```sh
r.connectivity.corridors input=hws_connectivity_edge_measures layer=1 \
weights=cd_eb_ud suffix=mst corridor_tolerance=0.05 where="cf_mst_ud>0" \
cores=1
```

[![image-alt](r_connectivity_corridors_mst_eb.png)](r_connectivity_corridors_mst_eb.png)  
*Figure: Corridors computed for connections on the minimum spanning tree
weighted by edge betweenness in the example above.*

### Corridor set 2

For the second set, corridors are computed for all edges in the graph
(network). This takes a little more time. Corridors are then weighted by
the modeled, undirected (= in oth directions) flow of propagules
("cf\_u").

```sh
r.connectivity.corridors input=hws_connectivity_edge_measures layer=1 \
weights=cf_u suffix=all corridor_tolerance=0.05 \
cores=1
```

[![image-alt](r_connectivity_corridors_cf_u_sum_all.png)](r_connectivity_corridors_cf_u_sum_all.png)  
*Figure: Corridors computed for all connections, weighted by potential
flow of propagules.*

Users with a multi-processor computer (e.g. dual-core) may speed up
corridor processing by setting cores \> 1 r.connectivity.corridors.  
Another means for speeding up processing would be to use integer weights
(e.g. by converting edge betweenness to integer after multiplying with
10 to the power of the relevant number of digits). Then *r.reclass* is
used in the script instead of *r.recode*.  
  
When all analysis is finished some cleanup may be appropriate, in order
to save disk space:  

```sh
# Add the f-lag (-f) to the following two commands if you are sure you
# want to delete all intermediate maps from r.connectivity.*.
g.remove type=raster pattern=hws_connectivity_corridor_*
g.remove type=raster pattern=hws_connectivity_patch_*
```

## SEE ALSO

*[r.connectivity.distance](r.connectivity.distance.md),
[r.connectivity.network](r.connectivity.network.md)*

## AUTHOR

Stefan Blumentrath, Norwegian Institute for Nature Research (NINA)

## SOURCE CODE

Available at: [r.connectivity.corridors source code](https://github.com/OSGeo/grass-addons/tree/grass8/raster/r.connectivity/r.connectivity.corridors)
([history](https://github.com/OSGeo/grass-addons/commits/grass8/raster/r.connectivity/r.connectivity.corridors))  
Latest change: Friday Feb 21 12:27:42 2025 in commit [8fce680](https://github.com/OSGeo/grass-addons/commit/8fce680a2170ee81eff27fdf4315079b10a10f83)
