---
name: r.euro.ecosystem.py
description: Sets colors and categories of European ecosystem raster data set
keywords: [ raster, color, category, ecosystem ]
---

# r.euro.ecosystem.py

Sets colors and categories of European ecosystem raster data set

=== "Command line"

    **r.euro.ecosystem.py**
    [**-12**]
    **input**=*name*
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    r.euro.ecosystem.py input=name
    ```

=== "Python (grass.script)"

    *grass.script.run_command*("***r.euro.ecosystem.py***",
        **input**,
        **flags**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.run_command("r.euro.ecosystem.py", input="name")
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.r_euro_ecosystem_py*(**input**,
        **flags**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.r_euro_ecosystem_py(input="name")
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **input**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input raster map  
    **-1**  
    &nbsp;&nbsp;&nbsp;&nbsp;level 1 data  
    **-2**  
    &nbsp;&nbsp;&nbsp;&nbsp;level 2 data  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **input** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *1*, *2*  
    &nbsp;&nbsp;&nbsp;&nbsp;**1**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;level 1 data  
    &nbsp;&nbsp;&nbsp;&nbsp;**2**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;level 2 data  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **input** : str | np.ndarray, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *1*, *2*  
    &nbsp;&nbsp;&nbsp;&nbsp;**1**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;level 1 data  
    &nbsp;&nbsp;&nbsp;&nbsp;**2**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;level 2 data  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

*r.euro.ecosystem* defines colors and raster category labels for
[Ecosystem types of
Europe](https://www.eea.europa.eu/en/datahub/datahubitem-view/573ff9d5-6889-407f-b3fc-cfe3f9e23941).

The data can be downloaded at
[EEA](https://www.eea.europa.eu/en/datahub/datahubitem-view/573ff9d5-6889-407f-b3fc-cfe3f9e23941)
for level 1 (based on
[EUNIS](https://www.eea.europa.eu/en/datahub/datahubitem-view/ce3e4bf4-e929-404a-88c7-37f2c614fd1d%22)
habitat classification level 1) and level 2 (based on EUNIS habitat
classification level 2).

The dataset combines the Corine based MAES ecosystem classes with the
non-spatial EUNIS habitat classification for a better biological
characterization of ecosystems across Europe. As such it represents
probabilities of EUNIS habitat presence for each MAES ecosystem type.

Data definition rules have to be defined by flags **-1** or **-2**.

Raster data definition rules are donated by EEA.

## EXAMPLE

```sh
  # link to ecosystem raster data level 1
  r.external input="es_l1_100m.tif" output=es_l1_100m
  # define colors and raster category labels
  r.euro.ecosystem -1 input=es_l1_100m

  # link to ecosystem raster data level 2
  r.external input="es_l2_100m.tif" output=es_l2_100m
  # define colors and raster category labels
  r.euro.ecosystem -2 input=es_l2_100m
 
```

## SEE ALSO

*[r.colors](https://grass.osgeo.org/grass-stable/manuals/r.colors.html)
[r.category](https://grass.osgeo.org/grass-stable/manuals/r.category.html)*

## AUTHOR

Helmut Kudrnovsky

## SOURCE CODE

Available at: [r.euro.ecosystem source code](https://github.com/OSGeo/grass-addons/tree/grass8/src/raster/r.euro.ecosystem)
([history](https://github.com/OSGeo/grass-addons/commits/grass8/src/raster/r.euro.ecosystem))  
Latest change: Thursday Feb 20 13:02:26 2025 in commit [53de819](https://github.com/OSGeo/grass-addons/commit/53de8196a10ba5a8a9121898ce87861d227137e3)
