---
name: r.extract.py
description: Extracts specified categories of an integer input map.
keywords: [ raster, extract, extent, category ]
---

# r.extract.py

Extracts specified categories of an integer input map.

=== "Command line"

    **r.extract.py**
    [**-cs**]
    **input**=*name*
    **output**=*name*
    **cats**=*range*
    [**--overwrite**]
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    r.extract.py input=name output=name cats=range
    ```

=== "Python (grass.script)"

    *grass.script.run_command*("***r.extract.py***",
        **input**,
        **output**,
        **cats**,
        **flags**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.run_command("r.extract.py", input="name", output="name", cats="range")
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.r_extract_py*(**input**,
        **output**,
        **cats**,
        **flags**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.r_extract_py(input="name", output="name", cats="range")
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **input**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input raster map  
    **output**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output raster map  
    **cats**=*range* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Category values  
    &nbsp;&nbsp;&nbsp;&nbsp;Example: 1,3,7-9,13  
    **-c**  
    &nbsp;&nbsp;&nbsp;&nbsp;Clip to minimum extent  
    **-s**  
    &nbsp;&nbsp;&nbsp;&nbsp;Output reclassified map instead of true map  
    **--overwrite**  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **input** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **output** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster, *name*  
    **cats** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Category values  
    &nbsp;&nbsp;&nbsp;&nbsp;Example: 1,3,7-9,13  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, cats, *range*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *c*, *s*  
    &nbsp;&nbsp;&nbsp;&nbsp;**c**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Clip to minimum extent  
    &nbsp;&nbsp;&nbsp;&nbsp;**s**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Output reclassified map instead of true map  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **input** : str | np.ndarray, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **output** : str | type(np.ndarray) | type(np.array) | type(gs.array.array), *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster, *name*  
    **cats** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Category values  
    &nbsp;&nbsp;&nbsp;&nbsp;Example: 1,3,7-9,13  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, cats, *range*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *c*, *s*  
    &nbsp;&nbsp;&nbsp;&nbsp;**c**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Clip to minimum extent  
    &nbsp;&nbsp;&nbsp;&nbsp;**s**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Output reclassified map instead of true map  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | np.ndarray | tuple[np.ndarray] | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned. If an array type (e.g., *np.ndarray*) is used for one of the raster outputs, the result will be an array and will have the shape corresponding to the computational region. If an array type is used for more than one raster output, the result will be a tuple of arrays.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

This module extracts selected categories from an integer raster map into
a new raster, similarly to
*[v.extract](https://grass.osgeo.org/grass-stable/manuals/v.extract.html)*
for vectors. The categories and color table are preserved.

The category values can be specified as:

- cat1,cat2,...
- cat1-cat3
- cat1-
- \-cat1
- and their combination: -cat1,cat2,cat3-cat6

The extent of the new raster can be changed with flag **-c** to fit the
extent of the extracted data. When using flag **-s** output raster is a
reclassified input raster (see
*[r.reclass](https://grass.osgeo.org/grass-stable/manuals/r.reclass.html)*
for details).

## NOTES

This implementation supports only integer raster maps (type CELL).

## EXAMPLES

The following examples are using the full North Carolina sample dataset.
We will extract certain zipcodes. First print zipcodes raster info:

```sh
g.region raster=zipcodes -p
r.info zipcodes -rg
```

```text
...
rows=1350
cols=1500
min=27511
max=27610
...
```

Now we extract 2 categories and automatically adjust the raster extent
to fit the extracted data.

```sh
r.extract input=zipcodes output=selected_zipcodes cats=27605,27601 -c
r.info selected_zipcodes -rg
```

```text
...
rows=404
cols=377
min=27601
max=27605
...
```

## SEE ALSO

*[r.reclass](https://grass.osgeo.org/grass-stable/manuals/r.reclass.html)*
(used in this implementation)  
*[v.extract](https://grass.osgeo.org/grass-stable/manuals/v.extract.html)*
(for extracting vector data)

## AUTHOR

Anna Petrasova, [NCSU GeoForAll
Lab](https://geospatial.ncsu.edu/geoforall/)

## SOURCE CODE

Available at: [r.extract source code](https://github.com/OSGeo/grass-addons/tree/grass8/src/raster/r.extract)
([history](https://github.com/OSGeo/grass-addons/commits/grass8/src/raster/r.extract))  
Latest change: Friday May 30 13:37:35 2025 in commit [d60e371](https://github.com/OSGeo/grass-addons/commit/d60e3717c9f05b222b84af4bc02ccd3f14fdf65a)
