---
name: r.findtheriver
description: Find the stream pixel nearest the input coordinate
keywords: [ raster, hydrology ]
---

# r.findtheriver

Find the stream pixel nearest the input coordinate

=== "Command line"

    **r.findtheriver**
    **map**=*name*
    [**window**=*x*]
    [**threshold**=*x*]
    **coordinates**=*east,north*
    [**separator**=*character*]
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    r.findtheriver map=name coordinates=0.0
    ```

=== "Python (grass.script)"

    *grass.script.run_command*("***r.findtheriver***",
        **map**,
        **window**=*None*,
        **threshold**=*None*,
        **coordinates**,
        **separator**=*"space"*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.run_command("r.findtheriver", map="name", coordinates=0.0)
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.r_findtheriver*(**map**,
        **window**=*None*,
        **threshold**=*None*,
        **coordinates**,
        **separator**=*"space"*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.r_findtheriver(map="name", coordinates=0.0)
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **map**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input upstream accumulation area raster map  
    **window**=*x*  
    &nbsp;&nbsp;&nbsp;&nbsp;The size of the window in pixels to search in for stream pixels. Must be an odd integer. If not supplied, window will be inferred based on raster resolution.  
    **threshold**=*x*  
    &nbsp;&nbsp;&nbsp;&nbsp;The threshold for distinguishing log(UAA) values of stream and non-stream pixels. If not supplied, threshold will be inferred from minimum and maximum raster values.  
    **coordinates**=*east,north* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Coordinates of outlet point  
    **separator**=*character*  
    &nbsp;&nbsp;&nbsp;&nbsp;Field separator  
    &nbsp;&nbsp;&nbsp;&nbsp;Special characters: pipe, comma, space, tab, newline  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *space*  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **map** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input upstream accumulation area raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **window** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;The size of the window in pixels to search in for stream pixels. Must be an odd integer. If not supplied, window will be inferred based on raster resolution.  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *x*  
    **threshold** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;The threshold for distinguishing log(UAA) values of stream and non-stream pixels. If not supplied, threshold will be inferred from minimum and maximum raster values.  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *x*  
    **coordinates** : tuple[float, float] | list[float] | str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Coordinates of outlet point  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, coords, *east,north*  
    **separator** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Field separator  
    &nbsp;&nbsp;&nbsp;&nbsp;Special characters: pipe, comma, space, tab, newline  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, separator, *character*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *space*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **map** : str | np.ndarray, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input upstream accumulation area raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **window** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;The size of the window in pixels to search in for stream pixels. Must be an odd integer. If not supplied, window will be inferred based on raster resolution.  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *x*  
    **threshold** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;The threshold for distinguishing log(UAA) values of stream and non-stream pixels. If not supplied, threshold will be inferred from minimum and maximum raster values.  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *x*  
    **coordinates** : tuple[float, float] | list[float] | str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Coordinates of outlet point  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, coords, *east,north*  
    **separator** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Field separator  
    &nbsp;&nbsp;&nbsp;&nbsp;Special characters: pipe, comma, space, tab, newline  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, separator, *character*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *space*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

*r.findtheriver* finds the nearest stream pixel to a coordinate pair
using an upstream accumulating area (UAA) raster map. This is necessary
because the coordinates for streamflow gages are often not perfectly
registered to the topography represented by a digital elevation model
(DEM) map. This presents a problem when trying to derive a watershed
contributing area using
*[r.water.outlet](https://grass.osgeo.org/grass-stable/manuals/r.water.outlet.html)*;
if the streamflow gage does not fall on the stream as represented in the
DEM,
*[r.water.outlet](https://grass.osgeo.org/grass-stable/manuals/r.water.outlet.html)*
can fail to derive the watershed area.

The basic assumption is that the UAA for "stream" pixels will be much
higher than for adjacent "non-stream" pixels. *r.findtheriver* attempts
to "snap" the coordinates of the streamflow gage to the "true" stream
location by first identifying stream pixels within a search window, and
then selecting the stream pixel that is closest (Cartesian distance) to
the input gage coordinates. Stream pixels are identified by searching
the UAA raster window for pixels that exceed a threshold. This is done
by computing the log10 of the UAA value for the pixel corresponding to
the gage coordinates and subtracting from it the log10 of each pixel in
the window; for a given pixel if this difference is greater than the
threshold, the pixel is deemed to be a stream pixel.

*r.findtheriver* will automatically compute the window and threshold if
they are not supplied by the user. The window is determined based on a
THRESHOLD\_DISTANCE / cell resolution of the UAA map. The threshold is
determined by subtracting the log10 of the UAA value at the input gage
coordinate from the log10 of the maximum UAA value of the map, and then
rounding down to the nearest integer, in other words: threshold = floor(
log(maxUAA) - log(gageUAA) ).

The closest stream pixel is printed to standard output. If no stream
pixels were found, nothing is printed.

## SEE ALSO

*[r.water.outlet](https://grass.osgeo.org/grass-stable/manuals/r.water.outlet.html)*

## AUTHORS

[Brian Miles](mailto:brian_miles@unc-edu)  
Updated to GRASS 7 by [Huidae Cho](mailto:grass4u@gmail-com)

## SOURCE CODE

Available at: [r.findtheriver source code](https://github.com/OSGeo/grass-addons/tree/grass8/src/raster/r.findtheriver)
([history](https://github.com/OSGeo/grass-addons/commits/grass8/src/raster/r.findtheriver))  
Latest change: Thursday Feb 20 13:02:26 2025 in commit [53de819](https://github.com/OSGeo/grass-addons/commit/53de8196a10ba5a8a9121898ce87861d227137e3)
