---
name: r.flowfill.py
description: Moves water downhill into pools or the ocean/map edge
keywords: [ raster, hydrology ]
---

# r.flowfill.py

Moves water downhill into pools or the ocean/map edge

=== "Command line"

    **r.flowfill.py**
    **input**=*name*
    **np**=*integer*
    [**threshold**=*float*]
    [**h_runoff**=*float*]
    [**h_runoff_raster**=*name*]
    [**ties**=*string*]
    [**ffpath**=*string*]
    [**output**=*name*]
    [**water**=*name*]
    [**--overwrite**]
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    r.flowfill.py input=name np=0
    ```

=== "Python (grass.script)"

    *grass.script.run_command*("***r.flowfill.py***",
        **input**,
        **np**,
        **threshold**=*0.001*,
        **h_runoff**=*None*,
        **h_runoff_raster**=*None*,
        **ties**=*"PREF"*,
        **ffpath**=*"flowfill"*,
        **output**=*None*,
        **water**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.run_command("r.flowfill.py", input="name", np=0)
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.r_flowfill_py*(**input**,
        **np**,
        **threshold**=*0.001*,
        **h_runoff**=*None*,
        **h_runoff_raster**=*None*,
        **ties**=*"PREF"*,
        **ffpath**=*"flowfill"*,
        **output**=*None*,
        **water**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.r_flowfill_py(input="name", np=0)
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **input**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Input DEM  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input raster map  
    **np**=*integer* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Number of processors to use (&gt;= 3)  
    **threshold**=*float*  
    &nbsp;&nbsp;&nbsp;&nbsp;Threshold water-surface elevation change to conclude calculation  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0.001*  
    **h_runoff**=*float*  
    &nbsp;&nbsp;&nbsp;&nbsp;Initial depth of uniform runoff [thickness in map units]  
    **h_runoff_raster**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Initial depth of non-uniform runoff [thickness in map units]  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input raster map  
    **ties**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Tie-handling: counterclockwise from Northwest (PREF) or random (RAND)  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *PREF, RAND*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *PREF*  
    **ffpath**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Path to the FlowFill executable  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *flowfill*  
    **output**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Output DEM + pooled/remaining runoff  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output raster map  
    **water**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Output water depth at the end of the run  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output raster map  
    **--overwrite**  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **input** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Input DEM  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **np** : int, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Number of processors to use (&gt;= 3)  
    **threshold** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Threshold water-surface elevation change to conclude calculation  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0.001*  
    **h_runoff** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Initial depth of uniform runoff [thickness in map units]  
    **h_runoff_raster** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Initial depth of non-uniform runoff [thickness in map units]  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **ties** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Tie-handling: counterclockwise from Northwest (PREF) or random (RAND)  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *PREF, RAND*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *PREF*  
    **ffpath** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Path to the FlowFill executable  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *flowfill*  
    **output** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Output DEM + pooled/remaining runoff  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster, *name*  
    **water** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Output water depth at the end of the run  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster, *name*  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **input** : str | np.ndarray, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Input DEM  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **np** : int, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Number of processors to use (&gt;= 3)  
    **threshold** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Threshold water-surface elevation change to conclude calculation  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0.001*  
    **h_runoff** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Initial depth of uniform runoff [thickness in map units]  
    **h_runoff_raster** : str | np.ndarray, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Initial depth of non-uniform runoff [thickness in map units]  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **ties** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Tie-handling: counterclockwise from Northwest (PREF) or random (RAND)  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *PREF, RAND*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *PREF*  
    **ffpath** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Path to the FlowFill executable  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *flowfill*  
    **output** : str | type(np.ndarray) | type(np.array) | type(gs.array.array), *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Output DEM + pooled/remaining runoff  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster, *name*  
    **water** : str | type(np.ndarray) | type(np.array) | type(gs.array.array), *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Output water depth at the end of the run  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster, *name*  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | np.ndarray | tuple[np.ndarray] | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned. If an array type (e.g., *np.ndarray*) is used for one of the raster outputs, the result will be an array and will have the shape corresponding to the computational region. If an array type is used for more than one raster output, the result will be a tuple of arrays.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

*r.flowfill* runs the FlowFill code (Callaghan and Wickert, 2019) that
moves water cell-by-cell to flood depressions in a DEM. It can be used
as a simplified/cellular simulation of downslope flow (though not
equivalent to physics-based approaches for flow) or as a tool to fill
depressions in a DEM. For further information, see the README at
<https://github.com/KCallaghan/FlowFill>.

## REFERENCES

Callaghan, K.\~L., and A.\~D. Wickert (in revision), Computing water
flow through complex landscapes, part 1: Incorporating depressions in
flow routing using FlowFill, *Earth Surface Dynamics Discussions*,
doi:10.5194/esurf-2019-11.

## SEE ALSO

[r.fill.dir](https://grass.osgeo.org/grass-stable/manuals/r.fill.dir.html)  

## AUTHORS

Kerry L. Callaghan, Andrew D. Wickert

## SOURCE CODE

Available at: [r.flowfill source code](https://github.com/OSGeo/grass-addons/tree/grass8/src/raster/r.flowfill)
([history](https://github.com/OSGeo/grass-addons/commits/grass8/src/raster/r.flowfill))  
Latest change: Thursday Feb 20 13:02:26 2025 in commit [53de819](https://github.com/OSGeo/grass-addons/commit/53de8196a10ba5a8a9121898ce87861d227137e3)
