---
name: r.futures.validation.py
description: Module for land change simulation validation and accuracy assessment
keywords: [ raster, statistics, accuracy, validation ]
---

# r.futures.validation.py

Module for land change simulation validation and accuracy assessment

=== "Command line"

    **r.futures.validation.py**
    **simulated**=*name*
    **reference**=*name*
    [**original**=*name*]
    [**format**=*string*]
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    r.futures.validation.py simulated=name reference=name
    ```

=== "Python (grass.script)"

    *grass.script.parse_command*("***r.futures.validation.py***",
        **simulated**,
        **reference**,
        **original**=*None*,
        **format**=*"plain"*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.parse_command("r.futures.validation.py", simulated="name", reference="name", format="json")
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.r_futures_validation_py*(**simulated**,
        **reference**,
        **original**=*None*,
        **format**=*"plain"*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.r_futures_validation_py(simulated="name", reference="name", format="json")
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **simulated**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Simulated land use raster  
    **reference**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Reference land use raster  
    **original**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Original land use raster  
    &nbsp;&nbsp;&nbsp;&nbsp;Required for kappa simulation  
    **format**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Output format  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *plain, shell, json*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *plain*  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **simulated** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Simulated land use raster  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **reference** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Reference land use raster  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **original** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Original land use raster  
    &nbsp;&nbsp;&nbsp;&nbsp;Required for kappa simulation  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **format** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Output format  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *plain, shell, json*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *plain*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **simulated** : str | np.ndarray, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Simulated land use raster  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **reference** : str | np.ndarray, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Reference land use raster  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **original** : str | np.ndarray, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Original land use raster  
    &nbsp;&nbsp;&nbsp;&nbsp;Required for kappa simulation  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **format** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Output format  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *plain, shell, json*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *plain*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

Module *r.futures.validation* allows to validate land change simulation
results. It computes:

- Allocation disagreement (total and per class), see Pontius et al,
    2011
- Quantity disagreement (total and per class), see Pontius et al, 2011
- Cohen's Kappa
- Kappa simulation, see van Vliet et al, 2011

This module can be used for any number of classes. Input raster
**original** represents the initial conditions and is needed only for
Kappa simulation.

## EXAMPLES

Validate land change simulation output by computing quantity and
allocation disagreement.

```sh
r.reclass input=simulated_2016 output=simulated_2016_reclass rules=rules.txt
r.futures.validation simulated=simulated_2016_reclass reference=reference_2016 original=orig_2001
```

## SEE ALSO

For alternative validation metrics see
[r.confusionmatrix](r.confusionmatrix.md), [r.kappa](r.kappa.md)

## REFERENCES

- Robert Gilmore Pontius Jr & Marco Millones (2011). [Death to Kappa:
    birth of quantity disagreement and allocation disagreement for
    accuracy assessment](https://doi.org/10.1080/01431161.2011.552923).
    International Journal of Remote Sensing, 32:15, 4407-4429
- Jasper van Vliet, Arnold K. Bregt, Alex Hagen-Zanker (2011)
    [Revisiting Kappa to account for change in the accuracy assessment
    of land-use change
    models](https://doi.org/10.1016/j.ecolmodel.2011.01.017). Ecological
    Modelling, Volume 222, Issue 8.
- Meentemeyer, R. K., Tang, W., Dorning, M. A., Vogler, J. B.,
    Cunniffe, N. J., & Shoemaker, D. A. (2013). [FUTURES: Multilevel
    Simulations of Emerging Urban-Rural Landscape Structure Using a
    Stochastic Patch-Growing
    Algorithm](https://doi.org/10.1080/00045608.2012.707591). Annals of
    the Association of American Geographers, 103(4), 785-807. DOI:
    10.1080/00045608.2012.707591
- Dorning, M. A., Koch, J., Shoemaker, D. A., & Meentemeyer, R. K.
    (2015). [Simulating urbanization scenarios reveals tradeoffs between
    conservation planning
    strategies](https://doi.org/10.1016/j.landurbplan.2014.11.011).
    Landscape and Urban Planning, 136, 28-39. DOI:
    10.1016/j.landurbplan.2014.11.011
- Petrasova, A., Petras, V., Van Berkel, D., Harmon, B. A., Mitasova,
    H., & Meentemeyer, R. K. (2016). [Open Source Approach to Urban
    Growth
    Simulation](https://isprs-archives.copernicus.org/articles/XLI-B7/953/2016/isprs-archives-XLI-B7-953-2016.pdf).
    Int. Arch. Photogramm. Remote Sens. Spatial Inf. Sci., XLI-B7,
    953-959. DOI: 10.5194/isprsarchives-XLI-B7-953-2016

## AUTHOR

Anna Petrasova, [NCSU
GeoForAll](https://geospatial.ncsu.edu/geoforall/)

## SOURCE CODE

Available at: [r.futures.validation source code](https://github.com/OSGeo/grass-addons/tree/grass8/raster/r.futures/r.futures.validation)
([history](https://github.com/OSGeo/grass-addons/commits/grass8/raster/r.futures/r.futures.validation))  
Latest change: Friday Feb 21 10:10:05 2025 in commit [7d78fe3](https://github.com/OSGeo/grass-addons/commit/7d78fe34868674c3b6050ba1924e1c5675d155c9)
