---
name: r.gdd
description: Makes each output cell value a function of the values assigned to the corresponding cells in the input raster map layers.
keywords: [ raster, aggregation, series, parallel ]
---

# r.gdd

Makes each output cell value a function of the values assigned to the corresponding cells in the input raster map layers.

=== "Command line"

    **r.gdd**
    [**-nz**]
    [**input**=*name* [,*name*,...]]
    [**add**=*name*]
    [**file**=*name*]
    **output**=*name*
    [**index**=*string*]
    [**scale**=*float*]
    [**shift**=*float*]
    [**baseline**=*float*]
    [**cutoff**=*float*]
    [**range**=*lo,hi*]
    [**--overwrite**]
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    r.gdd output=name
    ```

=== "Python (grass.script)"

    *grass.script.run_command*("***r.gdd***",
        **input**=*None*,
        **add**=*None*,
        **file**=*None*,
        **output**,
        **index**=*"gdd"*,
        **scale**=*1.0*,
        **shift**=*0.0*,
        **baseline**=*10*,
        **cutoff**=*30*,
        **range**=*None*,
        **flags**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.run_command("r.gdd", output="name")
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.r_gdd*(**input**=*None*,
        **add**=*None*,
        **file**=*None*,
        **output**,
        **index**=*"gdd"*,
        **scale**=*1.0*,
        **shift**=*0.0*,
        **baseline**=*10*,
        **cutoff**=*30*,
        **range**=*None*,
        **flags**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.r_gdd(output="name")
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **input**=*name* [,*name*,...]  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input raster map(s)  
    **add**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Existing map to be added to output  
    **file**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Input file with raster map names, one per line  
    **output**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output raster map  
    **index**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Index to calculate  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *gdd, winkler, bedd, huglin*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *gdd*  
    &nbsp;&nbsp;&nbsp;&nbsp;**gdd**: Growing Degree Days  
    &nbsp;&nbsp;&nbsp;&nbsp;**winkler**: Winkler index  
    &nbsp;&nbsp;&nbsp;&nbsp;**bedd**: Biologically Effective Degree Days  
    &nbsp;&nbsp;&nbsp;&nbsp;**huglin**: Huglin Heliothermal index  
    **scale**=*float*  
    &nbsp;&nbsp;&nbsp;&nbsp;Scale factor for input  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1.0*  
    **shift**=*float*  
    &nbsp;&nbsp;&nbsp;&nbsp;Shift factor for input  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0.0*  
    **baseline**=*float*  
    &nbsp;&nbsp;&nbsp;&nbsp;Baseline temperature  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *10*  
    **cutoff**=*float*  
    &nbsp;&nbsp;&nbsp;&nbsp;Cutoff temperature  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *30*  
    **range**=*lo,hi*  
    &nbsp;&nbsp;&nbsp;&nbsp;Ignore values outside this range  
    **-n**  
    &nbsp;&nbsp;&nbsp;&nbsp;Propagate NULLs  
    **-z**  
    &nbsp;&nbsp;&nbsp;&nbsp;Don't keep files open  
    **--overwrite**  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **input** : str | list[str], *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input raster map(s)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **add** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Existing map to be added to output  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **file** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Input file with raster map names, one per line  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, file, *name*  
    **output** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster, *name*  
    **index** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Index to calculate  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *gdd, winkler, bedd, huglin*  
    &nbsp;&nbsp;&nbsp;&nbsp;**gdd**: Growing Degree Days  
    &nbsp;&nbsp;&nbsp;&nbsp;**winkler**: Winkler index  
    &nbsp;&nbsp;&nbsp;&nbsp;**bedd**: Biologically Effective Degree Days  
    &nbsp;&nbsp;&nbsp;&nbsp;**huglin**: Huglin Heliothermal index  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *gdd*  
    **scale** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Scale factor for input  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1.0*  
    **shift** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Shift factor for input  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0.0*  
    **baseline** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Baseline temperature  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *10*  
    **cutoff** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Cutoff temperature  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *30*  
    **range** : tuple[float, float] | list[float] | str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Ignore values outside this range  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *lo,hi*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *n*, *z*  
    &nbsp;&nbsp;&nbsp;&nbsp;**n**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Propagate NULLs  
    &nbsp;&nbsp;&nbsp;&nbsp;**z**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Don't keep files open  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **input** : str | list[str], *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input raster map(s)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **add** : str | np.ndarray, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Existing map to be added to output  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **file** : str | io.StringIO, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Input file with raster map names, one per line  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, file, *name*  
    **output** : str | type(np.ndarray) | type(np.array) | type(gs.array.array), *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster, *name*  
    **index** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Index to calculate  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *gdd, winkler, bedd, huglin*  
    &nbsp;&nbsp;&nbsp;&nbsp;**gdd**: Growing Degree Days  
    &nbsp;&nbsp;&nbsp;&nbsp;**winkler**: Winkler index  
    &nbsp;&nbsp;&nbsp;&nbsp;**bedd**: Biologically Effective Degree Days  
    &nbsp;&nbsp;&nbsp;&nbsp;**huglin**: Huglin Heliothermal index  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *gdd*  
    **scale** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Scale factor for input  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1.0*  
    **shift** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Shift factor for input  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0.0*  
    **baseline** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Baseline temperature  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *10*  
    **cutoff** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Cutoff temperature  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *30*  
    **range** : tuple[float, float] | list[float] | str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Ignore values outside this range  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *lo,hi*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *n*, *z*  
    &nbsp;&nbsp;&nbsp;&nbsp;**n**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Propagate NULLs  
    &nbsp;&nbsp;&nbsp;&nbsp;**z**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Don't keep files open  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | np.ndarray | tuple[np.ndarray] | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned. If an array type (e.g., *np.ndarray*) is used for one of the raster outputs, the result will be an array and will have the shape corresponding to the computational region. If an array type is used for more than one raster output, the result will be a tuple of arrays.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

*r.gdd* calculates (accumulated) growing degree days
([GDDs](https://en.wikipedia.org/wiki/Growing_degree-day)), [Winkler
indices](https://en.wikipedia.org/wiki/Winkler_index), Biologically
Effective Degree Days (BEDD), and Huglin indices from several input maps
with temperature data for different times of the day.

**GDDs** are calculated as

```text
    gdd = average - baseline
```

The **Winkler index** is calculated as

```text
    wi = average - baseline
```

usually accumulated for the period April 1<sup>st</sup> to October
31<sup>st</sup> (northern hemisphere) or the period October
1<sup>st</sup> to April 30<sup>th</sup> (southern hemisphere).

**BEDDs** are calculated as

```text
    bedd = average - baseline
```

with an optional upper *cutoff* applied to the average. Vine development
kinetics for example reach a plateau at an average daily temperature of
19°C.

The **Huglin heliothermal index** is calculated as

```text
    hi = (average + max) / 2 - baseline
```

usually accumulated for the period April 1<sup>st</sup> to September
30<sup>th</sup> (northern hemisphere) or the period September
1<sup>st</sup> to April 30<sup>th</sup> (southern hemisphere).

Any averages above the *cutoff* value are set to *cutoff*, and any
*average* values below the *baseline* value are set to *baseline*.
Negative results are set to 0 (zero).

The *shift* and *scale* values are applied directly to the input values.
The *baseline*, *cutoff*, and *range* options are applied to the shifted
and scaled values.

If an existing map is provided with the *add* option, the values of this
map are added to the output, thus accumulating the selected index.

## NOTES

The *scale* and *shift* parameters are used to transform input values
with

```text
    new = old * scale + shift
```

With the *-n* flag, any cell for which any of the corresponding input
cells are NULL is automatically set to NULL (NULL propagation) and the
index is not calculated.

Without the *-n* flag, all non-NULL cells are used to calculate the
selected index.

If the *range=* option is given, any values which fall outside that
range will be treated as if they were NULL. Note that the range is
applied to the scaled and shifted input data. The *range* parameter can
be set to *low,high* thresholds: values outside of this range are
treated as NULL (i.e., they will be ignored by most aggregates, or will
cause the result to be NULL if -n is given). The *low,high* thresholds
are floating point, so use *-inf* or *inf* for a single threshold (e.g.,
*range=0,inf* to ignore negative values, or *range=-inf,-200.4* to
ignore values above -200.4).

The number of raster maps to be processed is given by the limit of the
operating system. For example, both the hard and soft limits are
typically 1024. The soft limit can be changed with e.g. `ulimit -n 1500`
(UNIX-based operating systems) but not higher than the hard limit. If it
is too low, you can as superuser add an entry in

```text
/etc/security/limits.conf
# <domain>      <type>  <item>         <value>
your_username  hard    nofile          1500
```

This would raise the hard limit to 1500 file. Be warned that more files
open need more RAM.

Use the *file* option to analyze large amount of raster maps without
hitting open files limit and the size limit of command line arguments.
The computation is slower than the *input* option method. For every
sinlge row in the output map(s) all input maps are opened and closed.
The amount of RAM will rise linear with the number of specified input
maps. The input and file options are mutually exclusive. Input is a text
file with a new line separated list of raster map names.

## EXAMPLES

Example with MODIS Land Surface Temperature, transforming values from
Kelvin \* 50 to degrees Celsius:

```sh
r.gdd in=MOD11A1.Day,MOD11A1.Night,MYD11A1.Day,MYD11A1.Night out=MCD11A1.GDD \
      scale=0.02 shift=-273.15 baseline=10 cutoff=30
```

## SEE ALSO

*[r.series](https://grass.osgeo.org/grass-stable/manuals/r.series.html),
[g.list](https://grass.osgeo.org/grass-stable/manuals/g.list.html),
[g.region](https://grass.osgeo.org/grass-stable/manuals/g.region.html)*

## AUTHOR

Markus Metz (based on r.series)

## SOURCE CODE

Available at: [r.gdd source code](https://github.com/OSGeo/grass-addons/tree/grass8/src/raster/r.gdd)
([history](https://github.com/OSGeo/grass-addons/commits/grass8/src/raster/r.gdd))  
Latest change: Monday Jan 19 23:02:33 2026 in commit [f6cae1f](https://github.com/OSGeo/grass-addons/commit/f6cae1f411b7cc75908d239b02dea6f6abd7fedd)
