---
name: r.green.biomassfor.recommended.py
description: Estimates potential bioenergy according to environmental restriction
keywords: [ raster, biomass ]
---

# r.green.biomassfor.recommended.py

Estimates potential bioenergy according to environmental restriction

=== "Command line"

    **r.green.biomassfor.recommended.py**
    **hfmap**=*name*
    **cmap**=*name*
    **output_basename**=*name*
    **management**=*name*
    **treatment**=*name*
    [**restrictions**=*name* [,*name*,...]]
    [**hydro**=*name*]
    [**buffer_hydro**=*integer*]
    [**zone_less**=*name*]
    [**energy_tops_hf**=*float*]
    [**energy_cormometric_vol_hf**=*float*]
    [**energy_tops_cop**=*float*]
    [**--overwrite**]
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    r.green.biomassfor.recommended.py hfmap=name cmap=name output_basename=name management=name treatment=name
    ```

=== "Python (grass.script)"

    *grass.script.run_command*("***r.green.biomassfor.recommended.py***",
        **hfmap**,
        **cmap**,
        **output_basename**,
        **management**,
        **treatment**,
        **restrictions**=*None*,
        **hydro**=*None*,
        **buffer_hydro**=*0*,
        **zone_less**=*None*,
        **energy_tops_hf**=*0.49*,
        **energy_cormometric_vol_hf**=*1.97*,
        **energy_tops_cop**=*0.55*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.run_command("r.green.biomassfor.recommended.py", hfmap="name", cmap="name", output_basename="name", management="name", treatment="name")
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.r_green_biomassfor_recommended_py*(**hfmap**,
        **cmap**,
        **output_basename**,
        **management**,
        **treatment**,
        **restrictions**=*None*,
        **hydro**=*None*,
        **buffer_hydro**=*0*,
        **zone_less**=*None*,
        **energy_tops_hf**=*0.49*,
        **energy_cormometric_vol_hf**=*1.97*,
        **energy_tops_cop**=*0.55*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.r_green_biomassfor_recommended_py(hfmap="name", cmap="name", output_basename="name", management="name", treatment="name")
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **hfmap**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Bioenergy potential map for High Forest in MWh/m3  
    **cmap**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Bioenergy potential map for Coppice in MWh/m3  
    **output_basename**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Basename for final recommended maps of bioenergy (HF,CC and total)  
    **management**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Map of forest management (1: high forest, 2:coppice)  
    **treatment**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Map of forest treatment (1: final felling, 2:thinning)  
    **restrictions**=*name* [,*name*,...]  
    &nbsp;&nbsp;&nbsp;&nbsp;Area with absolute restrictions (protected areas, urban parks etc.)  
    **hydro**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Rivers network  
    **buffer_hydro**=*integer*  
    &nbsp;&nbsp;&nbsp;&nbsp;Buffer area for rivers  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0*  
    **zone_less**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Civic use  
    **energy_tops_hf**=*float*  
    &nbsp;&nbsp;&nbsp;&nbsp;Energy for tops and branches in high forest in MWh/m3  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0.49*  
    **energy_cormometric_vol_hf**=*float*  
    &nbsp;&nbsp;&nbsp;&nbsp;Energy for tops and branches for high forest in MWh/m3  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1.97*  
    **energy_tops_cop**=*float*  
    &nbsp;&nbsp;&nbsp;&nbsp;Energy for tops and branches for Coppices in MWh/m3  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0.55*  
    **--overwrite**  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **hfmap** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Bioenergy potential map for High Forest in MWh/m3  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **cmap** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Bioenergy potential map for Coppice in MWh/m3  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **output_basename** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Basename for final recommended maps of bioenergy (HF,CC and total)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, , *name*  
    **management** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Map of forest management (1: high forest, 2:coppice)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **treatment** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Map of forest treatment (1: final felling, 2:thinning)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **restrictions** : str | list[str], *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Area with absolute restrictions (protected areas, urban parks etc.)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **hydro** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Rivers network  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **buffer_hydro** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Buffer area for rivers  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0*  
    **zone_less** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Civic use  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **energy_tops_hf** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Energy for tops and branches in high forest in MWh/m3  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0.49*  
    **energy_cormometric_vol_hf** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Energy for tops and branches for high forest in MWh/m3  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1.97*  
    **energy_tops_cop** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Energy for tops and branches for Coppices in MWh/m3  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0.55*  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **hfmap** : str | np.ndarray, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Bioenergy potential map for High Forest in MWh/m3  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **cmap** : str | np.ndarray, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Bioenergy potential map for Coppice in MWh/m3  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **output_basename** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Basename for final recommended maps of bioenergy (HF,CC and total)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, , *name*  
    **management** : str | np.ndarray, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Map of forest management (1: high forest, 2:coppice)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **treatment** : str | np.ndarray, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Map of forest treatment (1: final felling, 2:thinning)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **restrictions** : str | list[str], *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Area with absolute restrictions (protected areas, urban parks etc.)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **hydro** : str | np.ndarray, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Rivers network  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **buffer_hydro** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Buffer area for rivers  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0*  
    **zone_less** : str | np.ndarray, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Civic use  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **energy_tops_hf** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Energy for tops and branches in high forest in MWh/m3  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0.49*  
    **energy_cormometric_vol_hf** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Energy for tops and branches for high forest in MWh/m3  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1.97*  
    **energy_tops_cop** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Energy for tops and branches for Coppices in MWh/m3  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0.55*  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

Compute the biomass forestry residual potential considering extra
constraints.

## NOTES

## EXAMPLE

## REFERENCE

## SEE ALSO

*[r.green](r.green.md), [r.green.biomassfor](r.green.biomassfor.md)*

## AUTHORS

Francesco Geri, Pietro Zambelli, Sandro Sacchelli, Marco Ciolli

## SOURCE CODE

Available at: [r.green.biomassfor.recommended source code](https://github.com/OSGeo/grass-addons/tree/grass8/r.green/r.green.biomassfor/r.green.biomassfor.recommended)
([history](https://github.com/OSGeo/grass-addons/commits/grass8/r.green/r.green.biomassfor/r.green.biomassfor.recommended))  
Latest change: Thursday Feb 20 13:02:26 2025 in commit [53de819](https://github.com/OSGeo/grass-addons/commit/53de8196a10ba5a8a9121898ce87861d227137e3)
