---
name: r.green.gshp.technical.py
description: Calculate the Ground Source Heat Pump technical potential using the ASHRAE method.
keywords: [ raster, geothermal, renewable energy ]
---

# r.green.gshp.technical.py

Calculate the Ground Source Heat Pump technical potential using the ASHRAE method.

=== "Command line"

    **r.green.gshp.technical.py**
    [**-d**]
    **ground_conductivity**=*name*
    [**ground_diffusivity_rast**=*name*]
    [**ground_diffusivity_value**=*double*]
    [**ground_temp_rast**=*name*]
    [**ground_temp_value**=*double*]
    [**g_loads_6h_rast**=*name*]
    [**g_loads_6h_value**=*double*]
    [**g_loads_1m_rast**=*name*]
    [**g_loads_1m_value**=*double*]
    [**g_loads_1y_rast**=*name*]
    [**g_loads_1y_value**=*double*]
    [**fluid_capacity**=*double*]
    [**fluid_massflow**=*double*]
    [**fluid_inlettemp**=*double*]
    [**bh_radius**=*double*]
    [**bh_convection**=*double*]
    [**bh_resistence**=*double*]
    [**pipe_inner_radius**=*double*]
    [**pipe_outer_radius**=*double*]
    [**pipe_distance**=*double*]
    [**k_pipe**=*double*]
    [**k_grout**=*double*]
    [**field_distance**=*double*]
    [**field_number**=*integer*]
    [**field_ratio**=*double*]
    [**bhe_length**=*name*]
    [**bhe_field_length**=*name*]
    [**--overwrite**]
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    r.green.gshp.technical.py ground_conductivity=name
    ```

=== "Python (grass.script)"

    *grass.script.run_command*("***r.green.gshp.technical.py***",
        **ground_conductivity**,
        **ground_diffusivity_rast**=*None*,
        **ground_diffusivity_value**=*0.086*,
        **ground_temp_rast**=*None*,
        **ground_temp_value**=*10.*,
        **g_loads_6h_rast**=*None*,
        **g_loads_6h_value**=*60.*,
        **g_loads_1m_rast**=*None*,
        **g_loads_1m_value**=*15.*,
        **g_loads_1y_rast**=*None*,
        **g_loads_1y_value**=*5.*,
        **fluid_capacity**=*4200.*,
        **fluid_massflow**=*0.050*,
        **fluid_inlettemp**=*2.*,
        **bh_radius**=*0.06*,
        **bh_convection**=*1.52*,
        **bh_resistence**=*nan*,
        **pipe_inner_radius**=*0.01365*,
        **pipe_outer_radius**=*0.0167*,
        **pipe_distance**=*0.0511*,
        **k_pipe**=*0.42*,
        **k_grout**=*1.52*,
        **field_distance**=*6.1*,
        **field_number**=*2*,
        **field_ratio**=*1.2*,
        **bhe_length**=*None*,
        **bhe_field_length**=*None*,
        **flags**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.run_command("r.green.gshp.technical.py", ground_conductivity="name")
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.r_green_gshp_technical_py*(**ground_conductivity**,
        **ground_diffusivity_rast**=*None*,
        **ground_diffusivity_value**=*0.086*,
        **ground_temp_rast**=*None*,
        **ground_temp_value**=*10.*,
        **g_loads_6h_rast**=*None*,
        **g_loads_6h_value**=*60.*,
        **g_loads_1m_rast**=*None*,
        **g_loads_1m_value**=*15.*,
        **g_loads_1y_rast**=*None*,
        **g_loads_1y_value**=*5.*,
        **fluid_capacity**=*4200.*,
        **fluid_massflow**=*0.050*,
        **fluid_inlettemp**=*2.*,
        **bh_radius**=*0.06*,
        **bh_convection**=*1.52*,
        **bh_resistence**=*nan*,
        **pipe_inner_radius**=*0.01365*,
        **pipe_outer_radius**=*0.0167*,
        **pipe_distance**=*0.0511*,
        **k_pipe**=*0.42*,
        **k_grout**=*1.52*,
        **field_distance**=*6.1*,
        **field_number**=*2*,
        **field_ratio**=*1.2*,
        **bhe_length**=*None*,
        **bhe_field_length**=*None*,
        **flags**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.r_green_gshp_technical_py(ground_conductivity="name")
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **ground_conductivity**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Raster with depth-averaged ground thermal conductivity lambda [W m-1 K-1]  
    **ground_diffusivity_rast**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Raster with depth-averaged ground diffusivity [m2 day-1]  
    **ground_diffusivity_value**=*double*  
    &nbsp;&nbsp;&nbsp;&nbsp;Value with depth-averaged ground diffusivity  [m2 day-1]  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0.086*  
    **ground_temp_rast**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Raster with the initial ground temperature T0 [degrees C]  
    **ground_temp_value**=*double*  
    &nbsp;&nbsp;&nbsp;&nbsp;Value with the initial ground temperature T0 [degrees C]  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *10.*  
    **g_loads_6h_rast**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Peak of the maximum 6 hourly ground loads [W]  
    **g_loads_6h_value**=*double*  
    &nbsp;&nbsp;&nbsp;&nbsp;Peak of the maximum 6 hourly ground loads [W]  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *60.*  
    **g_loads_1m_rast**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Month with the maximum ground loads [W]  
    **g_loads_1m_value**=*double*  
    &nbsp;&nbsp;&nbsp;&nbsp;Month with the maximum ground loads [W]  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *15.*  
    **g_loads_1y_rast**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Yearly average ground loads [W]  
    **g_loads_1y_value**=*double*  
    &nbsp;&nbsp;&nbsp;&nbsp;Yearly average ground loads [W]  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *5.*  
    **fluid_capacity**=*double*  
    &nbsp;&nbsp;&nbsp;&nbsp;Fluid capacity Cp [J kg-1 K-1]  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *4200.*  
    **fluid_massflow**=*double*  
    &nbsp;&nbsp;&nbsp;&nbsp;Fluid massflow  [kg s-1 kW-1]  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0.050*  
    **fluid_inlettemp**=*double*  
    &nbsp;&nbsp;&nbsp;&nbsp;Inlet temperature  [degrees C]  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *2.*  
    **bh_radius**=*double*  
    &nbsp;&nbsp;&nbsp;&nbsp;Borehole radius [m]  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0.06*  
    **bh_convection**=*double*  
    &nbsp;&nbsp;&nbsp;&nbsp;Internal convection coefficient [W m-2 K-1]  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1.52*  
    **bh_resistence**=*double*  
    &nbsp;&nbsp;&nbsp;&nbsp;Borehole thermal resistance [m K W-1]  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *nan*  
    **pipe_inner_radius**=*double*  
    &nbsp;&nbsp;&nbsp;&nbsp;Borehole pipe inner radius [m]  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0.01365*  
    **pipe_outer_radius**=*double*  
    &nbsp;&nbsp;&nbsp;&nbsp;Borehole pipe outer radius [m]  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0.0167*  
    **pipe_distance**=*double*  
    &nbsp;&nbsp;&nbsp;&nbsp;Center-to-center distance between pipes [m]  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0.0511*  
    **k_pipe**=*double*  
    &nbsp;&nbsp;&nbsp;&nbsp;Pipe thermal conductivity [W m-1 K-1]  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0.42*  
    **k_grout**=*double*  
    &nbsp;&nbsp;&nbsp;&nbsp;Grout thermal conductivity [W m-1 K-1]  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1.52*  
    **field_distance**=*double*  
    &nbsp;&nbsp;&nbsp;&nbsp;Distance between boreholes heat exchanger  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *6.1*  
    **field_number**=*integer*  
    &nbsp;&nbsp;&nbsp;&nbsp;Number of borehole heat exchanger  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *2*  
    **field_ratio**=*double*  
    &nbsp;&nbsp;&nbsp;&nbsp;Borefield aspect ratio  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1.2*  
    **bhe_length**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of output raster map with the geothermal length of the BHE [m]  
    **bhe_field_length**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of output raster map with the geothermal length of the BHE field [m]  
    **-d**  
    &nbsp;&nbsp;&nbsp;&nbsp;Debug with intermediate maps  
    **--overwrite**  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **ground_conductivity** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Raster with depth-averaged ground thermal conductivity lambda [W m-1 K-1]  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **ground_diffusivity_rast** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Raster with depth-averaged ground diffusivity [m2 day-1]  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **ground_diffusivity_value** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Value with depth-averaged ground diffusivity  [m2 day-1]  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *double*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0.086*  
    **ground_temp_rast** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Raster with the initial ground temperature T0 [degrees C]  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **ground_temp_value** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Value with the initial ground temperature T0 [degrees C]  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *double*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *10.*  
    **g_loads_6h_rast** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Peak of the maximum 6 hourly ground loads [W]  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **g_loads_6h_value** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Peak of the maximum 6 hourly ground loads [W]  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *double*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *60.*  
    **g_loads_1m_rast** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Month with the maximum ground loads [W]  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **g_loads_1m_value** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Month with the maximum ground loads [W]  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *double*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *15.*  
    **g_loads_1y_rast** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Yearly average ground loads [W]  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **g_loads_1y_value** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Yearly average ground loads [W]  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *double*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *5.*  
    **fluid_capacity** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Fluid capacity Cp [J kg-1 K-1]  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *double*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *4200.*  
    **fluid_massflow** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Fluid massflow  [kg s-1 kW-1]  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *double*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0.050*  
    **fluid_inlettemp** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Inlet temperature  [degrees C]  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *double*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *2.*  
    **bh_radius** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Borehole radius [m]  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *double*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0.06*  
    **bh_convection** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Internal convection coefficient [W m-2 K-1]  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *double*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1.52*  
    **bh_resistence** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Borehole thermal resistance [m K W-1]  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *double*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *nan*  
    **pipe_inner_radius** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Borehole pipe inner radius [m]  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *double*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0.01365*  
    **pipe_outer_radius** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Borehole pipe outer radius [m]  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *double*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0.0167*  
    **pipe_distance** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Center-to-center distance between pipes [m]  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *double*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0.0511*  
    **k_pipe** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Pipe thermal conductivity [W m-1 K-1]  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *double*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0.42*  
    **k_grout** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Grout thermal conductivity [W m-1 K-1]  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *double*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1.52*  
    **field_distance** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Distance between boreholes heat exchanger  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *double*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *6.1*  
    **field_number** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Number of borehole heat exchanger  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *integer*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *2*  
    **field_ratio** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Borefield aspect ratio  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *double*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1.2*  
    **bhe_length** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of output raster map with the geothermal length of the BHE [m]  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster, *name*  
    **bhe_field_length** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of output raster map with the geothermal length of the BHE field [m]  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster, *name*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *d*  
    &nbsp;&nbsp;&nbsp;&nbsp;**d**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Debug with intermediate maps  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **ground_conductivity** : str | np.ndarray, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Raster with depth-averaged ground thermal conductivity lambda [W m-1 K-1]  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **ground_diffusivity_rast** : str | np.ndarray, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Raster with depth-averaged ground diffusivity [m2 day-1]  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **ground_diffusivity_value** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Value with depth-averaged ground diffusivity  [m2 day-1]  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *double*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0.086*  
    **ground_temp_rast** : str | np.ndarray, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Raster with the initial ground temperature T0 [degrees C]  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **ground_temp_value** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Value with the initial ground temperature T0 [degrees C]  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *double*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *10.*  
    **g_loads_6h_rast** : str | np.ndarray, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Peak of the maximum 6 hourly ground loads [W]  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **g_loads_6h_value** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Peak of the maximum 6 hourly ground loads [W]  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *double*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *60.*  
    **g_loads_1m_rast** : str | np.ndarray, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Month with the maximum ground loads [W]  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **g_loads_1m_value** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Month with the maximum ground loads [W]  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *double*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *15.*  
    **g_loads_1y_rast** : str | np.ndarray, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Yearly average ground loads [W]  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **g_loads_1y_value** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Yearly average ground loads [W]  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *double*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *5.*  
    **fluid_capacity** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Fluid capacity Cp [J kg-1 K-1]  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *double*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *4200.*  
    **fluid_massflow** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Fluid massflow  [kg s-1 kW-1]  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *double*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0.050*  
    **fluid_inlettemp** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Inlet temperature  [degrees C]  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *double*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *2.*  
    **bh_radius** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Borehole radius [m]  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *double*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0.06*  
    **bh_convection** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Internal convection coefficient [W m-2 K-1]  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *double*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1.52*  
    **bh_resistence** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Borehole thermal resistance [m K W-1]  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *double*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *nan*  
    **pipe_inner_radius** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Borehole pipe inner radius [m]  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *double*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0.01365*  
    **pipe_outer_radius** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Borehole pipe outer radius [m]  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *double*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0.0167*  
    **pipe_distance** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Center-to-center distance between pipes [m]  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *double*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0.0511*  
    **k_pipe** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Pipe thermal conductivity [W m-1 K-1]  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *double*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0.42*  
    **k_grout** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Grout thermal conductivity [W m-1 K-1]  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *double*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1.52*  
    **field_distance** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Distance between boreholes heat exchanger  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *double*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *6.1*  
    **field_number** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Number of borehole heat exchanger  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *integer*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *2*  
    **field_ratio** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Borefield aspect ratio  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *double*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1.2*  
    **bhe_length** : str | type(np.ndarray) | type(np.array) | type(gs.array.array), *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of output raster map with the geothermal length of the BHE [m]  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster, *name*  
    **bhe_field_length** : str | type(np.ndarray) | type(np.array) | type(gs.array.array), *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of output raster map with the geothermal length of the BHE field [m]  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster, *name*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *d*  
    &nbsp;&nbsp;&nbsp;&nbsp;**d**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Debug with intermediate maps  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | np.ndarray | tuple[np.ndarray] | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned. If an array type (e.g., *np.ndarray*) is used for one of the raster outputs, the result will be an array and will have the shape corresponding to the computational region. If an array type is used for more than one raster output, the result will be a tuple of arrays.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

*r.green.gshp.technical* calculates the lenght of the borehole for Groud
Source Heat Pump plants.

## NOTES

The required inputs are the ground source conductivity and the ground
loads.

## EXAMPLES

```sh
python r.green.gshp.technical.py --overwrite ground_conductivity=g_conductivity ground_diffusivity_rast=g_diffusivity ground_temp_rast=g_temperature g_loads_6h_rast=g_loads_6h g_loads_1m_rast=g_loads_1m g_loads_1y_rast=g_loads_1y fluid_capacity=4000. fluid_massflow=0.074 fluid_inlettemp=4.44 bh_radius=0.054 pipe_inner_radius=0.01365 pipe_outer_radius=0.0167 bh_convection=1000. pipe_distance=0.0471 k_pipe=0.45 k_grout=1.73 field_distance=6.1 field_number=120 field_ratio=1.2 bhe_length=len_bhe bhe_field_length=len_bhe_field -d
```

## SEE ALSO

*[r.green.gshp.technical](r.green.gshp.technical.md)*

## AUTHOR

Pietro Zambelli (Eurac Research, Bolzano, Italy)

## SOURCE CODE

Available at: [r.green.gshp.technical source code](https://github.com/OSGeo/grass-addons/tree/grass8/r.green/r.green.gshp/r.green.gshp.technical)
([history](https://github.com/OSGeo/grass-addons/commits/grass8/r.green/r.green.gshp/r.green.gshp.technical))  
Latest change: Saturday Oct 18 14:02:41 2025 in commit [5cb968f](https://github.com/OSGeo/grass-addons/commit/5cb968f55a99751846ac9af8070831e07b9710e5)
