---
name: r.green.hydro.delplants.py
description: Delete segments where there is an existing plant
keywords: [  ]
---

# r.green.hydro.delplants.py

Delete segments where there is an existing plant

=== "Command line"

    **r.green.hydro.delplants.py**
    [**-d**]
    **hydro**=*name*
    [**hydro_layer**=*string*]
    **river**=*name*
    **output_streams**=*string*
    [**output_plants**=*string*]
    [**hydro_kind_intake**=*string*]
    [**hydro_kind_turbine**=*string*]
    **elevation**=*name*
    [**other**=*name*]
    [**other_layer**=*name*]
    [**other_kind_intake**=*string*]
    [**other_kind_turbine**=*string*]
    [**--overwrite**]
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    r.green.hydro.delplants.py hydro=name river=name output_streams=string elevation=name
    ```

=== "Python (grass.script)"

    *grass.script.run_command*("***r.green.hydro.delplants.py***",
        **hydro**,
        **hydro_layer**=*"1"*,
        **river**,
        **output_streams**,
        **output_plants**=*None*,
        **hydro_kind_intake**=*"intake"*,
        **hydro_kind_turbine**=*"restitution"*,
        **elevation**,
        **other**=*None*,
        **other_layer**=*"1"*,
        **other_kind_intake**=*"intake"*,
        **other_kind_turbine**=*"restitution"*,
        **flags**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.run_command("r.green.hydro.delplants.py", hydro="name", river="name", output_streams="string", elevation="name")
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.r_green_hydro_delplants_py*(**hydro**,
        **hydro_layer**=*"1"*,
        **river**,
        **output_streams**,
        **output_plants**=*None*,
        **hydro_kind_intake**=*"intake"*,
        **hydro_kind_turbine**=*"restitution"*,
        **elevation**,
        **other**=*None*,
        **other_layer**=*"1"*,
        **other_kind_intake**=*"intake"*,
        **other_kind_turbine**=*"restitution"*,
        **flags**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.r_green_hydro_delplants_py(hydro="name", river="name", output_streams="string", elevation="name")
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **hydro**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of the vector map with the points (intake and restitution) of hydropower plants  
    &nbsp;&nbsp;&nbsp;&nbsp;Or data source for direct OGR access  
    **hydro_layer**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of the vector map layer of the hydropower plants, with the following attributes: kind_label (intake/restitution), discharge [m3/s], id_point, id_plant  
    &nbsp;&nbsp;&nbsp;&nbsp;Vector features can have category values in different layers. This number determines which layer to use. When used with direct OGR access this is the layer name.  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1*  
    **river**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of the vector map with the streams  
    &nbsp;&nbsp;&nbsp;&nbsp;Or data source for direct OGR access  
    **output_streams**=*string* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of the vector map with the stream segments without plants  
    **output_plants**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of the vector map with the stream segments of the existing plants  
    **hydro_kind_intake**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Value contained in the column kind_label that indicates the plant is an intake  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *intake*  
    **hydro_kind_turbine**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Value contained in the column kind_label that indicates the plant is a restitution  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *restitution*  
    **elevation**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input elevation raster map  
    **other**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of the vector map with points (intake and restitution) of other plants such as irrigation, acqueducts, etc.  
    &nbsp;&nbsp;&nbsp;&nbsp;Or data source for direct OGR access  
    **other_layer**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of the vector map layer of other plants, with the following attributes: kind_label (intake/restitution), discharge [m3/s], id_point, id_plant  
    &nbsp;&nbsp;&nbsp;&nbsp;Or data source for direct OGR access  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1*  
    **other_kind_intake**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Value contained in the column kind_label that indicates the plant is an intake  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *intake*  
    **other_kind_turbine**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Value contained in the column kind_label that indicates the plant is a restitution  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *restitution*  
    **-d**  
    &nbsp;&nbsp;&nbsp;&nbsp;Debug with intermediate maps  
    **--overwrite**  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **hydro** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of the vector map with the points (intake and restitution) of hydropower plants  
    &nbsp;&nbsp;&nbsp;&nbsp;Or data source for direct OGR access  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, vector, *name*  
    **hydro_layer** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of the vector map layer of the hydropower plants, with the following attributes: kind_label (intake/restitution), discharge [m3/s], id_point, id_plant  
    &nbsp;&nbsp;&nbsp;&nbsp;Vector features can have category values in different layers. This number determines which layer to use. When used with direct OGR access this is the layer name.  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, layer  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1*  
    **river** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of the vector map with the streams  
    &nbsp;&nbsp;&nbsp;&nbsp;Or data source for direct OGR access  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, vector, *name*  
    **output_streams** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of the vector map with the stream segments without plants  
    **output_plants** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of the vector map with the stream segments of the existing plants  
    **hydro_kind_intake** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Value contained in the column kind_label that indicates the plant is an intake  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *intake*  
    **hydro_kind_turbine** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Value contained in the column kind_label that indicates the plant is a restitution  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *restitution*  
    **elevation** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input elevation raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **other** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of the vector map with points (intake and restitution) of other plants such as irrigation, acqueducts, etc.  
    &nbsp;&nbsp;&nbsp;&nbsp;Or data source for direct OGR access  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, vector, *name*  
    **other_layer** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of the vector map layer of other plants, with the following attributes: kind_label (intake/restitution), discharge [m3/s], id_point, id_plant  
    &nbsp;&nbsp;&nbsp;&nbsp;Or data source for direct OGR access  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, vector, *name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1*  
    **other_kind_intake** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Value contained in the column kind_label that indicates the plant is an intake  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *intake*  
    **other_kind_turbine** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Value contained in the column kind_label that indicates the plant is a restitution  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *restitution*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *d*  
    &nbsp;&nbsp;&nbsp;&nbsp;**d**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Debug with intermediate maps  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **hydro** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of the vector map with the points (intake and restitution) of hydropower plants  
    &nbsp;&nbsp;&nbsp;&nbsp;Or data source for direct OGR access  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, vector, *name*  
    **hydro_layer** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of the vector map layer of the hydropower plants, with the following attributes: kind_label (intake/restitution), discharge [m3/s], id_point, id_plant  
    &nbsp;&nbsp;&nbsp;&nbsp;Vector features can have category values in different layers. This number determines which layer to use. When used with direct OGR access this is the layer name.  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, layer  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1*  
    **river** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of the vector map with the streams  
    &nbsp;&nbsp;&nbsp;&nbsp;Or data source for direct OGR access  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, vector, *name*  
    **output_streams** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of the vector map with the stream segments without plants  
    **output_plants** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of the vector map with the stream segments of the existing plants  
    **hydro_kind_intake** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Value contained in the column kind_label that indicates the plant is an intake  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *intake*  
    **hydro_kind_turbine** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Value contained in the column kind_label that indicates the plant is a restitution  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *restitution*  
    **elevation** : str | np.ndarray, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input elevation raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **other** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of the vector map with points (intake and restitution) of other plants such as irrigation, acqueducts, etc.  
    &nbsp;&nbsp;&nbsp;&nbsp;Or data source for direct OGR access  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, vector, *name*  
    **other_layer** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of the vector map layer of other plants, with the following attributes: kind_label (intake/restitution), discharge [m3/s], id_point, id_plant  
    &nbsp;&nbsp;&nbsp;&nbsp;Or data source for direct OGR access  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, vector, *name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1*  
    **other_kind_intake** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Value contained in the column kind_label that indicates the plant is an intake  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *intake*  
    **other_kind_turbine** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Value contained in the column kind_label that indicates the plant is a restitution  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *restitution*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *d*  
    &nbsp;&nbsp;&nbsp;&nbsp;**d**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Debug with intermediate maps  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

*r.green.hydro.delplants* deletes segments of river where there is an
existing plant.

## NOTES

This command is used to select the segments of river which are not
already exploited by a plant or another structure.  
The required inputs are the elevation raster map, the map with the
streams and the one with the intakes and restitution of the existing
plants. In option, it is possible to add the map with the intakes and
restitution of the other structures such aqueducts or irrigation in
order to delete these segments too.  
It is necessary to verify in "Optional" that the intakes and restitution
are well reported in the table of the input maps (hydro and other).

## EXAMPLE

This example is based on the case-study of Mis valley in Belluno
province, Veneto, Italy.  
  
![image-alt](r_green_hydro_delplants_input.png)  
Input vector maps : streams of Mis Valley in black and intakes and
restitution of existing plants in red

We use the following code to compute the available streams and obtain
the next map :

```sh
r.green.hydro.delplants hydro=existingplants river=streams output=availablestreams elevation=elevation

d.vect map=existingplants color=red
```

![image-alt](r_green_hydro_delplants_output.png)  
Output vector map in black : streams of Mis Valley without the existing
plants (intakes and restitution of existing plants are added there in
red)

## SEE ALSO

*[r.green.hydro.discharge](r.green.hydro.discharge.md)  
[r.green.hydro.financial](r.green.hydro.financial.md)  
[r.green.hydro.theoretical](r.green.hydro.theoretical.md)  
[r.green.hydro.optimal](r.green.hydro.optimal.md)  
[r.green.hydro.recommended](r.green.hydro.recommended.md)  
[r.green.hydro.structure](r.green.hydro.structure.md)  
[r.green.hydro.technical](r.green.hydro.technical.md)  
*

## AUTHORS

Giulia Garegnani and Pietro Zambelli (Eurac Research, Bolzano, Italy),
Manual written by Julie Gros.

## SOURCE CODE

Available at: [r.green.hydro.delplants source code](https://github.com/OSGeo/grass-addons/tree/grass8/r.green/r.green.hydro/r.green.hydro.delplants)
([history](https://github.com/OSGeo/grass-addons/commits/grass8/r.green/r.green.hydro/r.green.hydro.delplants))  
Latest change: Friday Feb 21 10:10:05 2025 in commit [7d78fe3](https://github.com/OSGeo/grass-addons/commit/7d78fe34868674c3b6050ba1924e1c5675d155c9)
