---
name: r.hydrodem
description: Hydrological conditioning, sink removal
keywords: [ raster, hydrology ]
---

# r.hydrodem

Hydrological conditioning, sink removal

=== "Command line"

    **r.hydrodem**
    [**-afc**]
    **input**=*name*
    [**depression**=*name*]
    [**memory**=*integer*]
    **output**=*name*
    **mod**=*integer*
    **size**=*integer*
    [**--overwrite**]
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    r.hydrodem input=name output=name mod=4 size=4
    ```

=== "Python (grass.script)"

    *grass.script.run_command*("***r.hydrodem***",
        **input**,
        **depression**=*None*,
        **memory**=*300*,
        **output**,
        **mod**=*4*,
        **size**=*4*,
        **flags**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.run_command("r.hydrodem", input="name", output="name", mod=4, size=4)
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.r_hydrodem*(**input**,
        **depression**=*None*,
        **memory**=*300*,
        **output**,
        **mod**=*4*,
        **size**=*4*,
        **flags**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.r_hydrodem(input="name", output="name", mod=4, size=4)
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **input**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Elevation map  
    &nbsp;&nbsp;&nbsp;&nbsp;Elevation map to be hydrologically corrected  
    **depression**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Depression map  
    &nbsp;&nbsp;&nbsp;&nbsp;Map indicating real depressions that must not be modified  
    **memory**=*integer*  
    &nbsp;&nbsp;&nbsp;&nbsp;Maximum memory to be used in MB  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *300*  
    **output**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of hydrologically conditioned raster map  
    **mod**=*integer* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Only remove sinks requiring not more than &lt;mod&gt; cell modifications.  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *4*  
    **size**=*integer* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Only remove sinks not larger than &lt;size&gt; cells.  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *4*  
    **-a**  
    &nbsp;&nbsp;&nbsp;&nbsp;Remove all sinks.  
    &nbsp;&nbsp;&nbsp;&nbsp;By default only minor corrections are done to the DEM and the result will not be 100% hydrologically correct.Use this flag to override default.  
    **-f**  
    &nbsp;&nbsp;&nbsp;&nbsp;Fill sinks.  
    &nbsp;&nbsp;&nbsp;&nbsp;By default a least impact approach is used to modify the DEM.Use this flag to force filling of sinks.  
    **-c**  
    &nbsp;&nbsp;&nbsp;&nbsp;Carve out of sinks.  
    &nbsp;&nbsp;&nbsp;&nbsp;By default a least impact approach is used to modify the DEM.Use this flag to force carving out of sinks.  
    **--overwrite**  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **input** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Elevation map  
    &nbsp;&nbsp;&nbsp;&nbsp;Elevation map to be hydrologically corrected  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **depression** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Depression map  
    &nbsp;&nbsp;&nbsp;&nbsp;Map indicating real depressions that must not be modified  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **memory** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Maximum memory to be used in MB  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *300*  
    **output** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of hydrologically conditioned raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster, *name*  
    **mod** : int, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Only remove sinks requiring not more than &lt;mod&gt; cell modifications.  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *4*  
    **size** : int, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Only remove sinks not larger than &lt;size&gt; cells.  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *4*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *a*, *f*, *c*  
    &nbsp;&nbsp;&nbsp;&nbsp;**a**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Remove all sinks.  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;By default only minor corrections are done to the DEM and the result will not be 100% hydrologically correct.Use this flag to override default.  
    &nbsp;&nbsp;&nbsp;&nbsp;**f**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Fill sinks.  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;By default a least impact approach is used to modify the DEM.Use this flag to force filling of sinks.  
    &nbsp;&nbsp;&nbsp;&nbsp;**c**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Carve out of sinks.  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;By default a least impact approach is used to modify the DEM.Use this flag to force carving out of sinks.  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **input** : str | np.ndarray, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Elevation map  
    &nbsp;&nbsp;&nbsp;&nbsp;Elevation map to be hydrologically corrected  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **depression** : str | np.ndarray, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Depression map  
    &nbsp;&nbsp;&nbsp;&nbsp;Map indicating real depressions that must not be modified  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **memory** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Maximum memory to be used in MB  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *300*  
    **output** : str | type(np.ndarray) | type(np.array) | type(gs.array.array), *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of hydrologically conditioned raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster, *name*  
    **mod** : int, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Only remove sinks requiring not more than &lt;mod&gt; cell modifications.  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *4*  
    **size** : int, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Only remove sinks not larger than &lt;size&gt; cells.  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *4*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *a*, *f*, *c*  
    &nbsp;&nbsp;&nbsp;&nbsp;**a**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Remove all sinks.  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;By default only minor corrections are done to the DEM and the result will not be 100% hydrologically correct.Use this flag to override default.  
    &nbsp;&nbsp;&nbsp;&nbsp;**f**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Fill sinks.  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;By default a least impact approach is used to modify the DEM.Use this flag to force filling of sinks.  
    &nbsp;&nbsp;&nbsp;&nbsp;**c**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Carve out of sinks.  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;By default a least impact approach is used to modify the DEM.Use this flag to force carving out of sinks.  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | np.ndarray | tuple[np.ndarray] | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned. If an array type (e.g., *np.ndarray*) is used for one of the raster outputs, the result will be an array and will have the shape corresponding to the computational region. If an array type is used for more than one raster output, the result will be a tuple of arrays.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

*r.hydrodem* applies hydrological conditioning (sink removal) to a
required input *elevation* map. If the conditioned elevation map is
going to be used as input elevation for *r.watershed*, only small sinks
should be removed and the amount of modifications restricted with the
**mod** option. For other modules such as *r.terraflow* or third-party
software, full sink removal is recommended.

## OPTIONS

- **input**  
    Input map, required: Digital elevation model to be corrected. Gaps
    in the elevation map that are located within the area of interest
    should be filled beforehand, e.g. with *r.fillnulls* or
    *r.resamp.bspline*, to avoid distortions.
- **output**  
    Output map, required: Hydrologically conditioned digital elevation
    model. By default, only minor modifications are done and not all
    sinks are removed.
- **size**  
    All sinks of up to **size** cells will be removed. Default is 4, if
    in doubt, decrease and not increase.
- **mod**  
    All sinks will be removed that require not more than **mod** cells
    to be modifed. Often, rather large sinks can be removed by carving
    through only few cells. Default is 4, if in doubt, increase and not
    decrease.
- **-a**  
    **Not recommended if input for *r.watershed* is generated.**  
    With the **-a** flag set, all sinks will be removed using an impact
    reduction approach based on Lindsay & Creed (2005). The output will
    be a depression-less digital elevation model, suitable for e.g.
    *r.terraflow* or other hydrological analyses that require a
    depression-less DEM as input.

## NOTES

This module is designed for *r.watershed* with the purpose to slightly
denoise a DEM prior to analysis. First, all one-cell peaks and pits are
removed, then the actual hydrological corrections are applied. In most
cases, the removal of one-cell extrema could already be sufficient to
improve *r.watershed* results in difficult terrain, particularly nearly
flat areas.

The impact reduction algorithm used by *r.hydrodem* is based on Lindsay
& Creed (2005), with some additional checks for hydrological
consistency. With complete sink removal, results of *r.terraflow* are
very similar to results of *r.watershed*.

*r.hydrodem* uses the same method to determine drainage directions like
*r.watershed*.

## REFERENCES

Lindsay, J. B., and Creed, I. F. 2005. Removal of artifact depressions
from digital elevation models: towards a minimum impact approach.
Hydrological Processes 19, 3113-3126. DOI:
[10.1002/hyp.5835](https://doi.org/10.1002/hyp.5835)

## SEE ALSO

*[r.watershed](https://grass.osgeo.org/grass-stable/manuals/r.watershed.html),
[r.terraflow](https://grass.osgeo.org/grass-stable/manuals/r.terraflow.html),
[r.fill.dir](https://grass.osgeo.org/grass-stable/manuals/r.fill.dir.html),
[r.fillnulls](https://grass.osgeo.org/grass-stable/manuals/r.fillnulls.html),
[r.resamp.bspline](https://grass.osgeo.org/grass-stable/manuals/r.resamp.bspline.html)*

## AUTHOR

Markus Metz

## SOURCE CODE

Available at: [r.hydrodem source code](https://github.com/OSGeo/grass-addons/tree/grass8/src/raster/r.hydrodem)
([history](https://github.com/OSGeo/grass-addons/commits/grass8/src/raster/r.hydrodem))  
Latest change: Friday Feb 21 10:10:05 2025 in commit [7d78fe3](https://github.com/OSGeo/grass-addons/commit/7d78fe34868674c3b6050ba1924e1c5675d155c9)
