---
name: r.hypso.py
description: Outputs a hypsometric and hypsographic graph.
keywords: [ raster ]
---

# r.hypso.py

Outputs a hypsometric and hypsographic graph.

=== "Command line"

    **r.hypso.py**
    [**-ab**]
    **map**=*name*
    **image**=*image*
    [**--overwrite**]
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    r.hypso.py map=name image=image
    ```

=== "Python (grass.script)"

    *grass.script.run_command*("***r.hypso.py***",
        **map**,
        **image**,
        **flags**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.run_command("r.hypso.py", map="name", image="image")
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.r_hypso_py*(**map**,
        **image**,
        **flags**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.r_hypso_py(map="name", image="image")
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **map**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input elevation raster map  
    **image**=*image* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output graph file (png)  
    **-a**  
    &nbsp;&nbsp;&nbsp;&nbsp;Generate hypsometric curve  
    **-b**  
    &nbsp;&nbsp;&nbsp;&nbsp;Generate hypsographic curve  
    **--overwrite**  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **map** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input elevation raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **image** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output graph file (png)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, file, *image*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *a*, *b*  
    &nbsp;&nbsp;&nbsp;&nbsp;**a**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Generate hypsometric curve  
    &nbsp;&nbsp;&nbsp;&nbsp;**b**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Generate hypsographic curve  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **map** : str | np.ndarray, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input elevation raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **image** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output graph file (png)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, file, *image*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *a*, *b*  
    &nbsp;&nbsp;&nbsp;&nbsp;**a**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Generate hypsometric curve  
    &nbsp;&nbsp;&nbsp;&nbsp;**b**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Generate hypsographic curve  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

*r.hypso* produces the hypsometric and hypsographic curve related to a
digital elevation model and prints the percentiles.

## NOTES

The *hypsographic curve* gives the distribution of surfaces in different
altitude ranges. Each point on the function reports on the y-axis the
elevation and on the x-axis the portion of the basin surface placed
above such elevation value. The *hypsometric curve* uses adimensional
axes.

## Flags

\-a: generates hypsometric curve

\-b: generates hyposographic curve

## EXAMPLE

```sh
r.hypso -b map=elevation image=/tmp/hypso
```

generates hypsographic curve, and

```sh
r.hypso -a map=elevation image=/tmp/hypso
```

generates hypsometric curve.

### Dependencies

- Matplotlib

## SEE ALSO

*[r.basin](https://grass.osgeo.org/grass-stable/manuals/r.basin.html),*

## REFERENCES

*Rodriguez-Iturbe I., Rinaldo A. — Fractal River Basins, Chance and
Self-Organization. Cambridge Press (2001)*

*In Italian: Di Leo M., Di Stefano M., Claps P., Sole A. —
Caratterizzazione morfometrica del bacino idrografico in GRASS GIS
(Morphometric characterization of the catchment in GRASS GIS
environment), [Geomatics
Workbooks](https://www.geolab.polimi.it/volume-9/), n. 9 (2010)*

## AUTHORS

Margherita Di Leo (grass-dev AT lists DOT osgeo DOT org), Massimo Di
Stefano, Francesco Di Stefano

## SOURCE CODE

Available at: [r.hypso source code](https://github.com/OSGeo/grass-addons/tree/grass8/src/raster/r.hypso)
([history](https://github.com/OSGeo/grass-addons/commits/grass8/src/raster/r.hypso))  
Latest change: Tuesday Jan 06 21:39:11 2026 in commit [22f101f](https://github.com/OSGeo/grass-addons/commit/22f101f1686a37f902e9631c79a905d905c66bf2)
