---
name: r.import.py
description: Imports raster data into a GRASS raster map using GDAL library and reprojects on the fly.
keywords: [ raster, import, projection ]
---

# r.import.py

Imports raster data into a GRASS raster map using GDAL library and reprojects on the fly.

=== "Command line"

    **r.import.py**
    [**-enlo**]
    **input**=*name*
    [**band**=*integer* [,*integer*,...]]
    [**memory**=*memory in MB*]
    [**output**=*name*]
    [**resample**=*string*]
    [**extent**=*string*]
    [**resolution**=*string*]
    [**resolution_value**=*float*]
    [**title**=*phrase*]
    [**--overwrite**]
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    r.import.py input=name output=name
    ```

=== "Python (grass.script)"

    *grass.script.run_command*("***r.import.py***",
        **input**,
        **band**=*None*,
        **memory**=*300*,
        **output**=*None*,
        **resample**=*"nearest"*,
        **extent**=*"input"*,
        **resolution**=*"estimated"*,
        **resolution_value**=*None*,
        **title**=*None*,
        **flags**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.run_command("r.import.py", input="name", output="name")
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.r_import_py*(**input**,
        **band**=*None*,
        **memory**=*300*,
        **output**=*None*,
        **resample**=*"nearest"*,
        **extent**=*"input"*,
        **resolution**=*"estimated"*,
        **resolution_value**=*None*,
        **title**=*None*,
        **flags**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.r_import_py(input="name", output="name")
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **input**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of GDAL dataset to be imported  
    **band**=*integer* [,*integer*,...]  
    &nbsp;&nbsp;&nbsp;&nbsp;Input band(s) to select (default is all bands)  
    **memory**=*memory in MB*  
    &nbsp;&nbsp;&nbsp;&nbsp;Maximum memory to be used (in MB)  
    &nbsp;&nbsp;&nbsp;&nbsp;Cache size for raster rows  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *300*  
    **output**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output raster map  
    **resample**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Resampling method to use for reprojection  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *nearest, bilinear, bicubic, lanczos, bilinear_f, bicubic_f, lanczos_f*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *nearest*  
    &nbsp;&nbsp;&nbsp;&nbsp;**nearest**: nearest neighbor  
    &nbsp;&nbsp;&nbsp;&nbsp;**bilinear**: bilinear interpolation  
    &nbsp;&nbsp;&nbsp;&nbsp;**bicubic**: bicubic interpolation  
    &nbsp;&nbsp;&nbsp;&nbsp;**lanczos**: lanczos filter  
    &nbsp;&nbsp;&nbsp;&nbsp;**bilinear_f**: bilinear interpolation with fallback  
    &nbsp;&nbsp;&nbsp;&nbsp;**bicubic_f**: bicubic interpolation with fallback  
    &nbsp;&nbsp;&nbsp;&nbsp;**lanczos_f**: lanczos filter with fallback  
    **extent**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Output raster map extent  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *input, region*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *input*  
    &nbsp;&nbsp;&nbsp;&nbsp;**input**: extent of input map  
    &nbsp;&nbsp;&nbsp;&nbsp;**region**: extent of current region  
    **resolution**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Resolution of output raster map (default: estimated)  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *estimated, value, region*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *estimated*  
    &nbsp;&nbsp;&nbsp;&nbsp;**estimated**: estimated resolution  
    &nbsp;&nbsp;&nbsp;&nbsp;**value**: user-specified resolution  
    &nbsp;&nbsp;&nbsp;&nbsp;**region**: current region resolution  
    **resolution_value**=*float*  
    &nbsp;&nbsp;&nbsp;&nbsp;Resolution of output raster map (use with option resolution=value)  
    **title**=*phrase*  
    &nbsp;&nbsp;&nbsp;&nbsp;Title for resultant raster map  
    **-e**  
    &nbsp;&nbsp;&nbsp;&nbsp;Estimate resolution only  
    **-n**  
    &nbsp;&nbsp;&nbsp;&nbsp;Do not perform region cropping optimization  
    **-l**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force Lat/Lon maps to fit into geographic coordinates (90N,S; 180E,W)  
    **-o**  
    &nbsp;&nbsp;&nbsp;&nbsp;Override projection check (use current project's CRS)  
    &nbsp;&nbsp;&nbsp;&nbsp;Assume that the dataset has the same coordinate reference system (CRS) as the current project  
    **--overwrite**  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **input** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of GDAL dataset to be imported  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, file, *name*  
    **band** : int | list[int] | str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Input band(s) to select (default is all bands)  
    **memory** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Maximum memory to be used (in MB)  
    &nbsp;&nbsp;&nbsp;&nbsp;Cache size for raster rows  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *memory in MB*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *300*  
    **output** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster, *name*  
    **resample** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Resampling method to use for reprojection  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *nearest, bilinear, bicubic, lanczos, bilinear_f, bicubic_f, lanczos_f*  
    &nbsp;&nbsp;&nbsp;&nbsp;**nearest**: nearest neighbor  
    &nbsp;&nbsp;&nbsp;&nbsp;**bilinear**: bilinear interpolation  
    &nbsp;&nbsp;&nbsp;&nbsp;**bicubic**: bicubic interpolation  
    &nbsp;&nbsp;&nbsp;&nbsp;**lanczos**: lanczos filter  
    &nbsp;&nbsp;&nbsp;&nbsp;**bilinear_f**: bilinear interpolation with fallback  
    &nbsp;&nbsp;&nbsp;&nbsp;**bicubic_f**: bicubic interpolation with fallback  
    &nbsp;&nbsp;&nbsp;&nbsp;**lanczos_f**: lanczos filter with fallback  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *nearest*  
    **extent** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Output raster map extent  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *input, region*  
    &nbsp;&nbsp;&nbsp;&nbsp;**input**: extent of input map  
    &nbsp;&nbsp;&nbsp;&nbsp;**region**: extent of current region  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *input*  
    **resolution** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Resolution of output raster map (default: estimated)  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *estimated, value, region*  
    &nbsp;&nbsp;&nbsp;&nbsp;**estimated**: estimated resolution  
    &nbsp;&nbsp;&nbsp;&nbsp;**value**: user-specified resolution  
    &nbsp;&nbsp;&nbsp;&nbsp;**region**: current region resolution  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *estimated*  
    **resolution_value** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Resolution of output raster map (use with option resolution=value)  
    **title** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Title for resultant raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *phrase*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *e*, *n*, *l*, *o*  
    &nbsp;&nbsp;&nbsp;&nbsp;**e**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Estimate resolution only  
    &nbsp;&nbsp;&nbsp;&nbsp;**n**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Do not perform region cropping optimization  
    &nbsp;&nbsp;&nbsp;&nbsp;**l**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Force Lat/Lon maps to fit into geographic coordinates (90N,S; 180E,W)  
    &nbsp;&nbsp;&nbsp;&nbsp;**o**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Override projection check (use current project's CRS)  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Assume that the dataset has the same coordinate reference system (CRS) as the current project  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **input** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of GDAL dataset to be imported  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, file, *name*  
    **band** : int | list[int] | str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Input band(s) to select (default is all bands)  
    **memory** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Maximum memory to be used (in MB)  
    &nbsp;&nbsp;&nbsp;&nbsp;Cache size for raster rows  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *memory in MB*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *300*  
    **output** : str | type(np.ndarray) | type(np.array) | type(gs.array.array), *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster, *name*  
    **resample** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Resampling method to use for reprojection  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *nearest, bilinear, bicubic, lanczos, bilinear_f, bicubic_f, lanczos_f*  
    &nbsp;&nbsp;&nbsp;&nbsp;**nearest**: nearest neighbor  
    &nbsp;&nbsp;&nbsp;&nbsp;**bilinear**: bilinear interpolation  
    &nbsp;&nbsp;&nbsp;&nbsp;**bicubic**: bicubic interpolation  
    &nbsp;&nbsp;&nbsp;&nbsp;**lanczos**: lanczos filter  
    &nbsp;&nbsp;&nbsp;&nbsp;**bilinear_f**: bilinear interpolation with fallback  
    &nbsp;&nbsp;&nbsp;&nbsp;**bicubic_f**: bicubic interpolation with fallback  
    &nbsp;&nbsp;&nbsp;&nbsp;**lanczos_f**: lanczos filter with fallback  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *nearest*  
    **extent** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Output raster map extent  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *input, region*  
    &nbsp;&nbsp;&nbsp;&nbsp;**input**: extent of input map  
    &nbsp;&nbsp;&nbsp;&nbsp;**region**: extent of current region  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *input*  
    **resolution** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Resolution of output raster map (default: estimated)  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *estimated, value, region*  
    &nbsp;&nbsp;&nbsp;&nbsp;**estimated**: estimated resolution  
    &nbsp;&nbsp;&nbsp;&nbsp;**value**: user-specified resolution  
    &nbsp;&nbsp;&nbsp;&nbsp;**region**: current region resolution  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *estimated*  
    **resolution_value** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Resolution of output raster map (use with option resolution=value)  
    **title** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Title for resultant raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *phrase*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *e*, *n*, *l*, *o*  
    &nbsp;&nbsp;&nbsp;&nbsp;**e**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Estimate resolution only  
    &nbsp;&nbsp;&nbsp;&nbsp;**n**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Do not perform region cropping optimization  
    &nbsp;&nbsp;&nbsp;&nbsp;**l**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Force Lat/Lon maps to fit into geographic coordinates (90N,S; 180E,W)  
    &nbsp;&nbsp;&nbsp;&nbsp;**o**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Override projection check (use current project's CRS)  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Assume that the dataset has the same coordinate reference system (CRS) as the current project  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | np.ndarray | tuple[np.ndarray] | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned. If an array type (e.g., *np.ndarray*) is used for one of the raster outputs, the result will be an array and will have the shape corresponding to the computational region. If an array type is used for more than one raster output, the result will be a tuple of arrays.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

*r.import* imports a map or selected bands from a GDAL raster datasource
into the current project (previously called location) and mapset. If the
coordinate reference system (CRS) of the input does not match the CRS of
the project, the input is reprojected into the current project. If the
CRS of the input does match the CRS of the project, the input is
imported directly with [r.in.gdal](r.in.gdal.md).

## NOTES

*r.import* checks the CRS metadata of the dataset to be imported against
the current project's CRS. If not identical a related error message is
shown.  
To override this projection check (i.e. to use current project's CRS) by
assuming that the dataset has the same CRS as the current project the
**-o** flag can be used. This is also useful when geodata to be imported
do not contain any CRS metadata at all. The user must be sure that the
CRS is identical in order to avoid introducing data errors.

### Resolution

*r.import* reports the estimated target resolution for each input band.
The estimated resolution will usually be some floating point number,
e.g. 271.301. In case option **resolution** is set to *estimated*
(default), this floating point number will be used as target resolution.
Since the target resolution should be typically the rounded estimated
resolution, e.g. 250 or 300 instead of 271.301, flag **-e** can be used
first to obtain the estimate without importing the raster bands. Then
the desired resolution is set with option **resolution_value** and
option **resolution**=*value*. For latlong projects, the resolution
might be set to arc seconds, e.g. 1, 3, 7.5, 15, and 30 arc seconds are
commonly used resolutions.

### Resampling methods

When reprojecting a map to a new spatial reference system, the projected
data is resampled with one of four different methods: nearest neighbor,
bilinear, bicubic interpolation or lanczos.

In the following, common use cases are:

**nearest** is the simplest method and the only possible method for
categorical data.

**bilinear** does linear interpolation and provides smoother output than
**nearest**. **bilinear** is recommended when reprojecting a DEM for
hydrological analysis or for surfaces where overshoots must be avoided,
e.g. precipitation should not become negative.

**bicubic** produces smoother output than **bilinear**, at the cost of
overshoots. Here, valid pixels that are adjacent to NULL pixels or edge
pixels are set to NULL.

**lanczos** produces the smoothest output of all methods and preserves
contrast best. **lanczos** is recommended for imagery. Both **bicubic**
and **lanczos** preserve linear features. With **nearest** or
**bilinear**, linear features can become zigzag features after
reprojection.

In the bilinear, bicubic and lanczos methods, if any of the surrounding
cells used to interpolate the new cell value are NULL, the resulting
cell will be NULL, even if the nearest cell is not NULL. This will cause
some thinning along NULL borders, such as the coasts of land areas in a
DEM. The bilinear_f, bicubic_f and lanczos_f interpolation methods can
be used if thinning along NULL edges is not desired. These methods "fall
back" to simpler interpolation methods along NULL borders. That is, from
lanczos to bicubic to bilinear to nearest.

For explanation of the **-l** flag, please refer to the
[r.in.gdal](r.in.gdal.md) manual.

When importing whole-world maps the user should disable map-trimming
with the **-n** flag. For further explanations of **-n** flag, please
refer the to [r.proj](r.proj.md) manual.

## EXAMPLES

### Import of SRTM V3 global data at 1 arc-seconds resolution

The SRTM V3 1 arc-second global data (~30 meters resolution) are
available from EarthExplorer (<https://earthexplorer.usgs.gov/>). The
SRTM collections are located under the "Digital Elevation" category.

Example for North Carolina sample dataset (the tile name is
"n35_w079_1arc_v3.tif"):

```sh
# set computational region to e.g. 10m elevation model:
g.region raster=elevation -p

# Import with reprojection on the fly. Recommended parameters:
# resample   Resampling method to use for reprojection - bilinear
# extent     Output raster map extent - region: extent of current region
# resolution Resolution of output raster map
#  - region: current region resolution - limit to g.region setting from above
r.import input=n35_w079_1arc_v3.tif output=srtmv3_resamp10m resample=bilinear \
  extent=region resolution=region title="SRTM V3 resampled to 10m resolution"

# beautify colors:
r.colors srtmv3_resamp10m color=elevation
```

### Import of WorldClim data

Import of a subset from WorldClim [Bioclim data
set](https://www.worldclim.org/data/bioclim.html), to be reprojected to
current project CRS (North Carolina sample dataset). Different
resolutions are available, in this example we use the 2.5 arc-minutes
resolution data. During import, we spatially subset the world data to
the North Carolina region using the *extent* parameter:

```sh
# download selected Bioclim data (2.5 arc-minutes resolution)
# optionally tiles are available for the 30 arc-sec resolution
wget https://geodata.ucdavis.edu/climate/worldclim/1_4/grid/cur/bio_2-5m_bil.zip

# extract BIO1 from package (BIO1 = Annual Mean Temperature):
unzip bio_2-5m_bil.zip bio1.bil bio1.hdr

# prior to import, fix broken WorldClim extent using GDAL tool
gdal_translate -a_ullr -180 90 180 -60 bio1.bil bio1_fixed.tif

# set computational region to North Carolina, 4000 m target pixel resolution
g.region -d res=4000 -ap

# subset to current region and reproject on the fly to current project CRS,
# using -n since whole-world map is imported:
r.import input=bio1_fixed.tif output=bioclim01 resample=bilinear \
         extent=region resolution=region -n

# temperature data are in °C * 10
r.info bioclim01
r.univar -e bioclim01
```

## SEE ALSO

*[r.in.gdal](r.in.gdal.md), [r.proj](r.proj.md)*

## AUTHORS

Markus Metz  
Improvements: Martin Landa, Anna Petrasova

## SOURCE CODE

Available at: [r.import source code](https://github.com/OSGeo/grass/tree/main/scripts/r.import)
([history](https://github.com/OSGeo/grass/commits/main/scripts/r.import))  
Latest change: Monday Nov 17 16:57:46 2025 in commit [122fd23](https://github.com/OSGeo/grass/commit/122fd2385a6bd23bd91ead6c9b8327b1c9190baa)
