---
name: r.in.ogc.coverages.py
description: Downloads and imports data from OGC API Coverages server.
keywords: [ raster, import, ogc, coverages ]
---

# r.in.ogc.coverages.py

Downloads and imports data from OGC API Coverages server.

=== "Command line"

    **r.in.ogc.coverages.py**
    [**-l**]
    **url**=*string*
    [**layer**=*string*]
    [**output**=*name*]
    [**--overwrite**]
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    r.in.ogc.coverages.py url=string
    ```

=== "Python (grass.script)"

    *grass.script.run_command*("***r.in.ogc.coverages.py***",
        **url**,
        **layer**=*None*,
        **output**=*None*,
        **flags**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.run_command("r.in.ogc.coverages.py", url="string")
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.r_in_ogc_coverages_py*(**url**,
        **layer**=*None*,
        **output**=*None*,
        **flags**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.r_in_ogc_coverages_py(url="string")
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **url**=*string* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;URL of OGC API Coverages server  
    **layer**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Layer to request from server  
    **output**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output raster map  
    **-l**  
    &nbsp;&nbsp;&nbsp;&nbsp;Get layers from the server  
    **--overwrite**  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **url** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;URL of OGC API Coverages server  
    **layer** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Layer to request from server  
    **output** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster, *name*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *l*  
    &nbsp;&nbsp;&nbsp;&nbsp;**l**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Get layers from the server  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **url** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;URL of OGC API Coverages server  
    **layer** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Layer to request from server  
    **output** : str | type(np.ndarray) | type(np.array) | type(gs.array.array), *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster, *name*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *l*  
    &nbsp;&nbsp;&nbsp;&nbsp;**l**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Get layers from the server  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | np.ndarray | tuple[np.ndarray] | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned. If an array type (e.g., *np.ndarray*) is used for one of the raster outputs, the result will be an array and will have the shape corresponding to the computational region. If an array type is used for more than one raster output, the result will be a tuple of arrays.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

*r.in.ogc.coverages* is able to import data from an OGC API Coverages
Service.

## EXAMPLES

```sh
r.in.ogc.coverages url=https://test.cubewerx.com/cubewerx/cubeserv/demo/ogcapi/Daraa -l

r.in.ogc.coverages url=https://test.cubewerx.com/cubewerx/cubeserv/demo/ogcapi/Daraa layer=Daraa_DTED output=Daraa_DTED
```

## SEE ALSO

More info about [OGC API Coverages](https://ogcapi.ogc.org/coverages/).
*[r.in.ogc](r.in.ogc.md), [v.in.ogc](v.in.ogc.md)*

## AUTHOR

Luca Delucchi, Fondazione Edmund Mach, during Joint OGC OSGeo ASF Code
Sprint 2021.

## SOURCE CODE

Available at: [r.in.ogc.coverages source code](https://github.com/OSGeo/grass-addons/tree/grass8/raster/r.in.ogc/r.in.ogc.coverages)
([history](https://github.com/OSGeo/grass-addons/commits/grass8/raster/r.in.ogc/r.in.ogc.coverages))  
Latest change: Thursday Feb 20 13:02:26 2025 in commit [53de819](https://github.com/OSGeo/grass-addons/commit/53de8196a10ba5a8a9121898ce87861d227137e3)
