---
name: r.info.iso.py
description: Creates metadata based on ISO standard for specified raster map.
keywords: [ raster, metadata, iso ]
---

# r.info.iso.py

Creates metadata based on ISO standard for specified raster map.

=== "Command line"

    **r.info.iso.py**
    **map**=*name*
    [**profile**=*string*]
    [**output**=*name*]
    [**--overwrite**]
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    r.info.iso.py map=name
    ```

=== "Python (grass.script)"

    *grass.script.run_command*("***r.info.iso.py***",
        **map**,
        **profile**=*"basic"*,
        **output**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.run_command("r.info.iso.py", map="name")
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.r_info_iso_py*(**map**,
        **profile**=*"basic"*,
        **output**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.r_info_iso_py(map="name")
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **map**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of raster map  
    **profile**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Metadata profile based on ISO  
    &nbsp;&nbsp;&nbsp;&nbsp;INSPIRE profile is not filled properly (unknown values are filled with '$NULL')  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *basic,  inspire*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *basic*  
    **output**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output file  
    **--overwrite**  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **map** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **profile** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Metadata profile based on ISO  
    &nbsp;&nbsp;&nbsp;&nbsp;INSPIRE profile is not filled properly (unknown values are filled with '$NULL')  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *basic,  inspire*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *basic*  
    **output** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output file  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, file, *name*  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **map** : str | np.ndarray, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **profile** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Metadata profile based on ISO  
    &nbsp;&nbsp;&nbsp;&nbsp;INSPIRE profile is not filled properly (unknown values are filled with '$NULL')  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *basic,  inspire*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *basic*  
    **output** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output file  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, file, *name*  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

*r.info.iso* creates metadata of raster maps according to [ISO
19115](https://www.iso.org/standard/26020.html).

The module also allows conversion of metadata from native GRASS
format to ISO-based format.

## NOTES

For dependencies and installation instructions see [wiki
page](https://grasswiki.osgeo.org/wiki/ISO/INSPIRE_Metadata_Support).

### Naming of metadata files and storage

Default location for exported metadata files is *metadata* directory in
the map's mapset. If the name for output metadata file is not specified
by **output** option than the name is built from map's type and its
name. For raster maps, the prefix derived from the current nomenclature
is *raster*, for vector maps *vector*. File ends with *.xml* extension.

For example default metadata file name for raster map "elevation" is
*cell\_elevation.xml*.

### Metadata profile

The *basic* profile is substituted from intersection between items
stored in GRASS native metadata format and INSPIRE profile. The
intersect (subset) includes all available GRASS metadata. Metadata which
cannot be assigned to ISO based attributes are stored in metadata
attribute *abstract*. The *inspire* profile fulfills the criteria of
INSPIRE profile. Values which are not able to get from native GRASS
metadata are filled by text string `'$NULL'`. This rule applies to both
profiles.

## EXAMPLES

Export metadata using *basic* profile (default):

```sh
r.info.iso map=elevation
```

Export metadata using *inspire* profile:

```sh
r.info.iso map=elevation profile=inspire
```

## SEE ALSO

*[r.info](https://grass.osgeo.org/grass-stable/manuals/r.info.html),
[v.info.iso](v.info.iso.md), [g.gui.metadata](g.gui.metadata.md)*

See also related [wiki
page](https://grasswiki.osgeo.org/wiki/ISO/INSPIRE_Metadata_Support).

## AUTHORS

Matej Krejci, [OSGeoREL](https://geo.fsv.cvut.cz/gwiki/osgeorel) at the
Czech Technical University in Prague, developed during [Google Summer of
Code 2014](https://trac.osgeo.org/grass/wiki/GSoC/2014/MetadataForGRASS)
(mentors: Margherita Di Leo, Martin Landa)

## SOURCE CODE

Available at: [r.info.iso source code](https://github.com/OSGeo/grass-addons/tree/grass8/wxpython/wx.metadata/r.info.iso)
([history](https://github.com/OSGeo/grass-addons/commits/grass8/wxpython/wx.metadata/r.info.iso))  
Latest change: Tuesday Jan 06 21:39:11 2026 in commit [22f101f](https://github.com/OSGeo/grass-addons/commit/22f101f1686a37f902e9631c79a905d905c66bf2)
