---
name: r.lake.series.py
description: Fills lake at given point(s) to given levels.
keywords: [ raster, hydrology, hazard, flood ]
---

# r.lake.series.py

Fills lake at given point(s) to given levels.

=== "Command line"

    **r.lake.series.py**
    [**-nc**]
    **elevation**=*name*
    **output**=*name*
    **start_water_level**=*float*
    **end_water_level**=*float*
    **water_level_step**=*float*
    [**coordinates**=*east,north*]
    [**seed_raster**=*name*]
    [**time_step**=*integer*]
    [**time_unit**=*string*]
    [**nproc**=*integer*]
    [**--overwrite**]
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    r.lake.series.py elevation=name output=name start_water_level=0.0 end_water_level=0.0 water_level_step=0.0
    ```

=== "Python (grass.script)"

    *grass.script.run_command*("***r.lake.series.py***",
        **elevation**,
        **output**,
        **start_water_level**,
        **end_water_level**,
        **water_level_step**,
        **coordinates**=*None*,
        **seed_raster**=*None*,
        **time_step**=*30*,
        **time_unit**=*"minutes"*,
        **nproc**=*1*,
        **flags**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.run_command("r.lake.series.py", elevation="name", output="name", start_water_level=0.0, end_water_level=0.0, water_level_step=0.0)
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.r_lake_series_py*(**elevation**,
        **output**,
        **start_water_level**,
        **end_water_level**,
        **water_level_step**,
        **coordinates**=*None*,
        **seed_raster**=*None*,
        **time_step**=*30*,
        **time_unit**=*"minutes"*,
        **nproc**=*1*,
        **flags**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.r_lake_series_py(elevation="name", output="name", start_water_level=0.0, end_water_level=0.0, water_level_step=0.0)
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **elevation**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input elevation raster map  
    **output**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of the output space time raster dataset  
    &nbsp;&nbsp;&nbsp;&nbsp;The name of the dataset is used as a base name for created output maps. Map names will consist of a base name, underscore and water level value or number depending on -c flag.  
    **start_water_level**=*float* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Start water level  
    &nbsp;&nbsp;&nbsp;&nbsp;Units should be meters?  
    **end_water_level**=*float* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Final (maximal) water level  
    &nbsp;&nbsp;&nbsp;&nbsp;Units should be meters?  
    **water_level_step**=*float* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Water level step  
    &nbsp;&nbsp;&nbsp;&nbsp;Units should be meters?  
    **coordinates**=*east,north*  
    &nbsp;&nbsp;&nbsp;&nbsp;Seed point coordinates  
    &nbsp;&nbsp;&nbsp;&nbsp;Either this coordinates pair or a seed map name have to be specified.  
    **seed_raster**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input raster map with given starting point(s) (at least 1 cell &gt; 0)  
    &nbsp;&nbsp;&nbsp;&nbsp;Either this parameter or a coordinates pair have to be specified.  
    **time_step**=*integer*  
    &nbsp;&nbsp;&nbsp;&nbsp;Time increment  
    &nbsp;&nbsp;&nbsp;&nbsp;Time increment between two states (maps) used to register output maps in space-time raster dataset. Used together with time_units parameter.  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *0-*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *30*  
    **time_unit**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Time units  
    &nbsp;&nbsp;&nbsp;&nbsp;Time units used to register output maps in space-time raster dataset. Used together with time_step parameter.  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *years, months, days, hours, minutes, seconds*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *minutes*  
    **nproc**=*integer*  
    &nbsp;&nbsp;&nbsp;&nbsp;Number of processes to run in parallel (currently ignored)  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *1-*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1*  
    **-n**  
    &nbsp;&nbsp;&nbsp;&nbsp;Use negative depth values for lake raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;This flag is passed to r.lake module.  
    **-c**  
    &nbsp;&nbsp;&nbsp;&nbsp;Use map number instead of the water level in map name (currently ignored)  
    &nbsp;&nbsp;&nbsp;&nbsp;This names are always in the right alphabetical order and are also valid vector map names.  
    **--overwrite**  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **elevation** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input elevation raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **output** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of the output space time raster dataset  
    &nbsp;&nbsp;&nbsp;&nbsp;The name of the dataset is used as a base name for created output maps. Map names will consist of a base name, underscore and water level value or number depending on -c flag.  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, strds, *name*  
    **start_water_level** : float, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Start water level  
    &nbsp;&nbsp;&nbsp;&nbsp;Units should be meters?  
    **end_water_level** : float, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Final (maximal) water level  
    &nbsp;&nbsp;&nbsp;&nbsp;Units should be meters?  
    **water_level_step** : float, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Water level step  
    &nbsp;&nbsp;&nbsp;&nbsp;Units should be meters?  
    **coordinates** : tuple[float, float] | list[float] | str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Seed point coordinates  
    &nbsp;&nbsp;&nbsp;&nbsp;Either this coordinates pair or a seed map name have to be specified.  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, coords, *east,north*  
    **seed_raster** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input raster map with given starting point(s) (at least 1 cell &gt; 0)  
    &nbsp;&nbsp;&nbsp;&nbsp;Either this parameter or a coordinates pair have to be specified.  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **time_step** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Time increment  
    &nbsp;&nbsp;&nbsp;&nbsp;Time increment between two states (maps) used to register output maps in space-time raster dataset. Used together with time_units parameter.  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *0-*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *30*  
    **time_unit** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Time units  
    &nbsp;&nbsp;&nbsp;&nbsp;Time units used to register output maps in space-time raster dataset. Used together with time_step parameter.  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *years, months, days, hours, minutes, seconds*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *minutes*  
    **nproc** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Number of processes to run in parallel (currently ignored)  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *1-*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *n*, *c*  
    &nbsp;&nbsp;&nbsp;&nbsp;**n**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Use negative depth values for lake raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;This flag is passed to r.lake module.  
    &nbsp;&nbsp;&nbsp;&nbsp;**c**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Use map number instead of the water level in map name (currently ignored)  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;This names are always in the right alphabetical order and are also valid vector map names.  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **elevation** : str | np.ndarray, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input elevation raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **output** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of the output space time raster dataset  
    &nbsp;&nbsp;&nbsp;&nbsp;The name of the dataset is used as a base name for created output maps. Map names will consist of a base name, underscore and water level value or number depending on -c flag.  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, strds, *name*  
    **start_water_level** : float, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Start water level  
    &nbsp;&nbsp;&nbsp;&nbsp;Units should be meters?  
    **end_water_level** : float, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Final (maximal) water level  
    &nbsp;&nbsp;&nbsp;&nbsp;Units should be meters?  
    **water_level_step** : float, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Water level step  
    &nbsp;&nbsp;&nbsp;&nbsp;Units should be meters?  
    **coordinates** : tuple[float, float] | list[float] | str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Seed point coordinates  
    &nbsp;&nbsp;&nbsp;&nbsp;Either this coordinates pair or a seed map name have to be specified.  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, coords, *east,north*  
    **seed_raster** : str | np.ndarray, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input raster map with given starting point(s) (at least 1 cell &gt; 0)  
    &nbsp;&nbsp;&nbsp;&nbsp;Either this parameter or a coordinates pair have to be specified.  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **time_step** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Time increment  
    &nbsp;&nbsp;&nbsp;&nbsp;Time increment between two states (maps) used to register output maps in space-time raster dataset. Used together with time_units parameter.  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *0-*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *30*  
    **time_unit** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Time units  
    &nbsp;&nbsp;&nbsp;&nbsp;Time units used to register output maps in space-time raster dataset. Used together with time_step parameter.  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *years, months, days, hours, minutes, seconds*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *minutes*  
    **nproc** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Number of processes to run in parallel (currently ignored)  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *1-*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *n*, *c*  
    &nbsp;&nbsp;&nbsp;&nbsp;**n**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Use negative depth values for lake raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;This flag is passed to r.lake module.  
    &nbsp;&nbsp;&nbsp;&nbsp;**c**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Use map number instead of the water level in map name (currently ignored)  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;This names are always in the right alphabetical order and are also valid vector map names.  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

***r.lake.series*** fills a lake or any area from a given start point or
areas specified by raster map (`seed_raster` option). The module
generates one map containing filled areas for each water level specified
by water level options (`start_water_level`, `end_water_level`,
`water_level_step`). This module uses
*[r.lake](https://grass.osgeo.org/grass-stable/manuals/r.lake.html)*
module to generate individual maps for the map series. See
*[r.lake](https://grass.osgeo.org/grass-stable/manuals/r.lake.html)*
manual for further discussion. Note that water level is absolute height,
so it should be in same range as you digital elevation model. On the
other hand, water depth in output maps is relative to the water level.

This module outputs:

- a space-time raster dataset containing a map series
- a map series containing maps of areas with water for each water
    level

## EXAMPLE

The following example presents a bigger flooding in rural area of North
Carolina sample dataset and included also visualization examples.

```sh
# using unix-like shell syntax

# set computational region
g.region raster=elev_lid792_1m
# prepare input data
v.to.rast -d input=streams output=rural_streams use=val val=1

# compute a flooding scenario
r.lake.series elevation=elev_lid792_1m seed=rural_streams \
              start_wl=104.0 end_wl=115.0 wl_step=0.2 output=flooding

# visualize the flooding space-time raster dataset
g.gui.animation strds=flooding

# alternatively explore maps from dataset
# prepare shaded relief map
r.relief input=elev_lid792_1m output=elev_lid792_1m_shade
# set color table for streams
r.colors map=rural_streams rules=- <<EOF
1 blue
EOF

# open d.mon or map display
d.mon wx1

# show base maps
d.rast elev_lid792_1m_shade
d.rast rural_streams

# show particular flooding maps
d.rast flooding_105.0
d.rast flooding_108.0
d.rast flooding_114.0
```

![image-alt](rural_flooding_105.jpg)
![image-alt](rural_flooding_108.jpg) ![image-alt](r.lake.series.jpg)

Figure: A bigger flooding in rural area of North Carolina sample dataset
with water level at 105, 108 and 114 meters (water depth differs in
different areas).

## SEE ALSO

*[r.lake](https://grass.osgeo.org/grass-stable/manuals/r.lake.html)*

## AUTHORS

Vaclav Petras, [NCSU OSGeoREL](http://gis.ncsu.edu/osgeorel/),  
Maris Nartiss (author of
*[r.lake](https://grass.osgeo.org/grass-stable/manuals/r.lake.html)*)

## SOURCE CODE

Available at: [r.lake.series source code](https://github.com/OSGeo/grass-addons/tree/grass8/src/raster/r.lake.series)
([history](https://github.com/OSGeo/grass-addons/commits/grass8/src/raster/r.lake.series))  
Latest change: Friday Feb 21 10:10:05 2025 in commit [7d78fe3](https://github.com/OSGeo/grass-addons/commit/7d78fe34868674c3b6050ba1924e1c5675d155c9)
