---
name: r.maxent.lambdas.py
description: Computes raw or logistic prediction maps from MaxEnt lambdas files
keywords: [ raster, maxent, ecology, niche, parallel ]
---

# r.maxent.lambdas.py

Computes raw or logistic prediction maps from MaxEnt lambdas files

=== "Command line"

    **r.maxent.lambdas.py**
    [**-pnNc**]
    **lambdas_file**=*name*
    [**alias_file**=*name*]
    [**logistic**=*name*]
    [**raw**=*name*]
    [**ndigits**=*integer*]
    [**nprocs**=*integer*]
    **width**=*integer*
    **height**=*integer*
    [**--overwrite**]
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    r.maxent.lambdas.py lambdas_file=name logistic=name width=1000 height=1000
    ```

=== "Python (grass.script)"

    *grass.script.run_command*("***r.maxent.lambdas.py***",
        **lambdas_file**,
        **alias_file**=*None*,
        **logistic**=*None*,
        **raw**=*None*,
        **ndigits**=*0*,
        **nprocs**=*1*,
        **width**=*1000*,
        **height**=*1000*,
        **flags**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.run_command("r.maxent.lambdas.py", lambdas_file="name", logistic="name", width=1000, height=1000)
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.r_maxent_lambdas_py*(**lambdas_file**,
        **alias_file**=*None*,
        **logistic**=*None*,
        **raw**=*None*,
        **ndigits**=*0*,
        **nprocs**=*1*,
        **width**=*1000*,
        **height**=*1000*,
        **flags**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.r_maxent_lambdas_py(lambdas_file="name", logistic="name", width=1000, height=1000)
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **lambdas_file**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;MaxEnt lambdas-file to compute distribution-model from  
    **alias_file**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;CSV-file to replace alias names from MaxEnt by GRASS map names  
    **logistic**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Raster map with logistic output  
    **raw**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Raster map with raw output  
    **ndigits**=*integer*  
    &nbsp;&nbsp;&nbsp;&nbsp;Produce logistic output as integer map with this number of digits preserved  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0*  
    **nprocs**=*integer*  
    &nbsp;&nbsp;&nbsp;&nbsp;Number of r.mapcalc processes to run in parallel (requires r.mapcalc.tiled addon)  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *1-*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1*  
    **width**=*integer* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Width of tiles (columns) (requires r.mapcalc.tiled addon and nprocs &gt; 1)  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1000*  
    **height**=*integer* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Height of tiles (requires r.mapcalc.tiled addon and nprocs &gt; 1)  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1000*  
    **-p**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print only  
    &nbsp;&nbsp;&nbsp;&nbsp;Print mapcalculator expressions and exit  
    **-n**  
    &nbsp;&nbsp;&nbsp;&nbsp;Do not include cells where any variabel contains no data  
  
    **-N**  
    &nbsp;&nbsp;&nbsp;&nbsp;Do not include cells where all variabels contain no data  
  
    **-c**  
    &nbsp;&nbsp;&nbsp;&nbsp;Clamp values in raster maps to value range seen by the MaxEnt model  
  
    **--overwrite**  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **lambdas_file** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;MaxEnt lambdas-file to compute distribution-model from  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, file, *name*  
    **alias_file** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;CSV-file to replace alias names from MaxEnt by GRASS map names  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, file, *name*  
    **logistic** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Raster map with logistic output  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster, *name*  
    **raw** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Raster map with raw output  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster, *name*  
    **ndigits** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Produce logistic output as integer map with this number of digits preserved  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0*  
    **nprocs** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Number of r.mapcalc processes to run in parallel (requires r.mapcalc.tiled addon)  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *1-*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1*  
    **width** : int, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Width of tiles (columns) (requires r.mapcalc.tiled addon and nprocs &gt; 1)  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1000*  
    **height** : int, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Height of tiles (requires r.mapcalc.tiled addon and nprocs &gt; 1)  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1000*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *p*, *n*, *N*, *c*  
    &nbsp;&nbsp;&nbsp;&nbsp;**p**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Print only  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Print mapcalculator expressions and exit  
    &nbsp;&nbsp;&nbsp;&nbsp;**n**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Do not include cells where any variabel contains no data  
  
    &nbsp;&nbsp;&nbsp;&nbsp;**N**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Do not include cells where all variabels contain no data  
  
    &nbsp;&nbsp;&nbsp;&nbsp;**c**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Clamp values in raster maps to value range seen by the MaxEnt model  
  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **lambdas_file** : str | io.StringIO, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;MaxEnt lambdas-file to compute distribution-model from  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, file, *name*  
    **alias_file** : str | io.StringIO, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;CSV-file to replace alias names from MaxEnt by GRASS map names  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, file, *name*  
    **logistic** : str | type(np.ndarray) | type(np.array) | type(gs.array.array), *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Raster map with logistic output  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster, *name*  
    **raw** : str | type(np.ndarray) | type(np.array) | type(gs.array.array), *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Raster map with raw output  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster, *name*  
    **ndigits** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Produce logistic output as integer map with this number of digits preserved  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0*  
    **nprocs** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Number of r.mapcalc processes to run in parallel (requires r.mapcalc.tiled addon)  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *1-*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1*  
    **width** : int, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Width of tiles (columns) (requires r.mapcalc.tiled addon and nprocs &gt; 1)  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1000*  
    **height** : int, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Height of tiles (requires r.mapcalc.tiled addon and nprocs &gt; 1)  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1000*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *p*, *n*, *N*, *c*  
    &nbsp;&nbsp;&nbsp;&nbsp;**p**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Print only  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Print mapcalculator expressions and exit  
    &nbsp;&nbsp;&nbsp;&nbsp;**n**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Do not include cells where any variabel contains no data  
  
    &nbsp;&nbsp;&nbsp;&nbsp;**N**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Do not include cells where all variabels contain no data  
  
    &nbsp;&nbsp;&nbsp;&nbsp;**c**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Clamp values in raster maps to value range seen by the MaxEnt model  
  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | np.ndarray | tuple[np.ndarray] | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned. If an array type (e.g., *np.ndarray*) is used for one of the raster outputs, the result will be an array and will have the shape corresponding to the computational region. If an array type is used for more than one raster output, the result will be a tuple of arrays.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

The script is intended to compute (**raw**) or (**logistic**) prediction
maps from a lambdas file produced with MaxEnt \>= 3.3.3e.

It will parse the specified **lambdas\_file** from MaxEnt \>= 3.3.3e and
translate it into an r.mapcalc-expression. If alias names had been used
in MaxEnt, these alias names can automatically be replaced according to
a CSV-like file (**alias\_file**) provided by the user, as it can be
produced with
[r.out.maxent\_swd](https://grass.osgeo.org/grass-stable/manuals/addonsr.out.maxent_swd.html).
This file should contain alias names in the first column and map names
in the second column, separated by comma, without header. It should look
e.g. like this:

```csv
alias_1,map_1
alias_2,map_2
...,...
```

If such a CSV-file with alias names used in MaxEnt is provided, the
alias names from MaxEnt are replaced by raster map names.

The logistic map can be produced as an integer map. To do so the user
has to specify the number of decimal places, that should be preserved in
integer output in the **ndigits** option.

Optionally the map calculator expressions can be printed to stdout with
the **p**-flag for inspection or documentation as they likely exceed the
space in the map history.

By default, NoData for each function in the lambdas file is set to zero.
The user can however choose to set pixels to null where a single
variable contains NoData (**n**-flag) or where all variables produce
NoData (**N**-flag).

Extraction of random points in MaxEnt can be a reason why values in
raster maps exceed values seen by the MaxEnt model. To limit raster map
values to the valid range for the model, raster map values can be
clamped to the value range in the model with the **c**-flag.

Complex models (and thus mapcalculator expressions) can become CPU
intensive to process. On multicore computers, processing such large
models can benefit from tiled, parallel processing (**nprocs** larger
than 1). This requires that the
[r.mapcalc.tiled](https://grass.osgeo.org/grass-stable/manuals/addons/r.mapcalc.tiled.html)
addon is installed. The size of tiles can be controlled by the
**height** and **width** options.

## NOTES

This script works only if the maps containing the input data to MaxEnt
are accessible from the current region.

Due to conversion from double to floating-point in exp()-function, a
loss of precision from the 7th decimal place onwards may occur in the
logistic output. Differences to logistic predictions from MaxEnt are
supposed to be below 0.0001. This can be checked by importing sample or
background predictions from the MaxEnt output (e.g. with
[r.in.xyz](https://grass.osgeo.org/grass-stable/manuals/r.in.xyz.html)).

## REFERENCES

- Wilson, Peter D. 2009: Guidelines for computing MaxEnt model output
    values from a lambdas file. (Available at
    <https://gsp.humboldt.edu/OLM/Courses/GSP_570/Learning-Modules/10-BlueSpray_Maxent_Uncertinaty/MaxEnt-lambda-files.pdf>)
- Steven J. Phillips, Miroslav Dudík, Robert E. Schapire. 2020: Maxent
    software for modeling species niches and distributions (Version
    3.4.1). Available from url:
    <https://biodiversityinformatics.amnh.org/open_source/maxent> and
    <https://github.com/mrmaxent/Maxent>
- Steven J. Phillips, Miroslav Dudík, Robert E. Schapire. 2004: A
    maximum entropy approach to species distribution modeling. In
    Proceedings of the Twenty-First International Conference on Machine
    Learning, pages 655-662, 2004.
- Steven J. Phillips, Robert P. Anderson, Robert E. Schapire. 2006:
    Maximum entropy modeling of species geographic distributions.
    Ecological Modelling, 190:231-259, 2006.
- Jane Elith, Steven J. Phillips, Trevor Hastie, Miroslav Dudík, Yung
    En Chee, Colin J. Yates. 2011: A statistical explanation of MaxEnt
    for ecologists. Diversity and Distributions, 17:43-57, 2011.

## SEE ALSO

*[r.in.xyz](https://grass.osgeo.org/grass-stable/manuals/r.in.xyz.html),
[r.mapcalc](https://grass.osgeo.org/grass-stable/manuals/r.mapcalc.html),
[r.mapcalc.tiled](https://grass.osgeo.org/grass-stable/manuals/addons/r.mapcalc.tiled.html)
(Addon)
[r.out.maxent\_swd](https://grass.osgeo.org/grass-stable/manuals/addons/r.out.maxent_swd.html)
(Addon)*

## AUTHOR

Stefan Blumentrath, Norwegian Institute for Nature Research (NINA),
<https://www.nina.no>

## SOURCE CODE

Available at: [r.maxent.lambdas source code](https://github.com/OSGeo/grass-addons/tree/grass8/src/raster/r.maxent.lambdas)
([history](https://github.com/OSGeo/grass-addons/commits/grass8/src/raster/r.maxent.lambdas))  
Latest change: Thursday Mar 20 21:36:57 2025 in commit [7286ecf](https://github.com/OSGeo/grass-addons/commit/7286ecf7af235bfd089fb9b1b82fb383cf95f3fc)
