---
name: r.mcda.input.py
description: Generates a raster map classified with Dominance Rough Set Approach. Use *.rls file from JAMM, 4eMka2 etc.
keywords: [ raster, Dominance Rough Set Approach, Multi Criteria Decision Analysis (MCDA) ]
---

# r.mcda.input.py

Generates a raster map classified with Dominance Rough Set Approach. Use *.rls file from JAMM, 4eMka2 etc.

=== "Command line"

    **r.mcda.input.py**
    [**-kjl**]
    **input**=*string*
    **output**=*string*
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    r.mcda.input.py input=string output=string
    ```

=== "Python (grass.script)"

    *grass.script.run_command*("***r.mcda.input.py***",
        **input**,
        **output**,
        **flags**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.run_command("r.mcda.input.py", input="string", output="string")
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.r_mcda_input_py*(**input**,
        **output**,
        **flags**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.r_mcda_input_py(input="string", output="string")
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **input**=*string* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;File name with rules (\*.rls)  
    **output**=*string* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;output classified raster map  
    **-k**  
    &nbsp;&nbsp;&nbsp;&nbsp;file \*.rls from software 4eMka2  
    **-j**  
    &nbsp;&nbsp;&nbsp;&nbsp;file \*.rls from software jMAF (NOT YET IMPLEMENTED)  
    **-l**  
    &nbsp;&nbsp;&nbsp;&nbsp;do not remove single rules in vector format  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **input** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;File name with rules (\*.rls)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, input  
    **output** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;output classified raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *k*, *j*, *l*  
    &nbsp;&nbsp;&nbsp;&nbsp;**k**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;file \*.rls from software 4eMka2  
    &nbsp;&nbsp;&nbsp;&nbsp;**j**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;file \*.rls from software jMAF (NOT YET IMPLEMENTED)  
    &nbsp;&nbsp;&nbsp;&nbsp;**l**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;do not remove single rules in vector format  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **input** : str | io.StringIO, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;File name with rules (\*.rls)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, input  
    **output** : str | type(np.ndarray) | type(np.array) | type(gs.array.array), *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;output classified raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *k*, *j*, *l*  
    &nbsp;&nbsp;&nbsp;&nbsp;**k**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;file \*.rls from software 4eMka2  
    &nbsp;&nbsp;&nbsp;&nbsp;**j**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;file \*.rls from software jMAF (NOT YET IMPLEMENTED)  
    &nbsp;&nbsp;&nbsp;&nbsp;**l**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;do not remove single rules in vector format  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | np.ndarray | tuple[np.ndarray] | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned. If an array type (e.g., *np.ndarray*) is used for one of the raster outputs, the result will be an array and will have the shape corresponding to the computational region. If an array type is used for more than one raster output, the result will be a tuple of arrays.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

The *r.mcda.input* module will read a \*rls file output from jMAF, JAMM
or 4eMka2 sofware [Laboratory of Intelligent Decision Support Systems -
Poznan University.](http://idss.cs.put.poznan.pl/) and returns maps of
the rules

## SEE ALSO

*[r.roughset](r.roughset.md), [r.mcda.regime](r.mcda.regime.md),
[r.mcda.fuzzy](r.mcda.fuzzy.md) [r.mcda.electre](r.mcda.electre.md),
[r.mcda.ahp](r.mcda.ahp.md) [r.mcda.roughset](r.mcda.roughset.md)
[r.mcda.input](r.mcda.input.md) [r.mcda.output](r.mcda.output.md)*

## AUTHORS

Antonio Boggia - Gianluca Massei  
Department of Economics and Appraisal - University of Perugia - Italy

## SOURCE CODE

Available at: [r.mcda.input source code](https://github.com/OSGeo/grass-addons/tree/grass8/src/raster/r.mcda.input)
([history](https://github.com/OSGeo/grass-addons/commits/grass8/src/raster/r.mcda.input))  
Latest change: Thursday Feb 20 20:36:19 2025 in commit [158e314](https://github.com/OSGeo/grass-addons/commit/158e314c788f983e3a448ec1b1ba3f226b5ca3e9)
