---
name: r.mwprecip.py
description: Module for working with microwave links
keywords: [ raster, microwave ]
---

# r.mwprecip.py

Module for working with microwave links

=== "Command line"

    **r.mwprecip.py**
    [**-gqpr**]
    **database**=*name*
    [**statfce**=*string*]
    [**quantile**=*integer*]
    [**roundm**=*integer*]
    [**aw**=*float*]
    [**baseltime**=*name*]
    [**baselfile**=*name*]
    [**interval**=*string*]
    [**fromtime**=*string*]
    [**totime**=*string*]
    [**lignore**=*name*]
    [**rgauges**=*name*]
    [**interpolation**=*string*]
    [**isettings**=*string*]
    [**pmethod**=*string*]
    [**step**=*integer*]
    [**color**=*name*]
    [**user**=*string*]
    [**password**=*string*]
    [**schema**=*string*]
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    r.mwprecip.py database=name
    ```

=== "Python (grass.script)"

    *grass.script.parse_command*("***r.mwprecip.py***",
        **database**,
        **statfce**=*"mode"*,
        **quantile**=*96*,
        **roundm**=*3*,
        **aw**=*1.5*,
        **baseltime**=*None*,
        **baselfile**=*None*,
        **interval**=*"minute"*,
        **fromtime**=*None*,
        **totime**=*None*,
        **lignore**=*None*,
        **rgauges**=*None*,
        **interpolation**=*"rst"*,
        **isettings**=*None*,
        **pmethod**=*"count"*,
        **step**=*1*,
        **color**=*None*,
        **user**=*None*,
        **password**=*None*,
        **schema**=*"temp4"*,
        **flags**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.parse_command("r.mwprecip.py", database="name")
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.r_mwprecip_py*(**database**,
        **statfce**=*"mode"*,
        **quantile**=*96*,
        **roundm**=*3*,
        **aw**=*1.5*,
        **baseltime**=*None*,
        **baselfile**=*None*,
        **interval**=*"minute"*,
        **fromtime**=*None*,
        **totime**=*None*,
        **lignore**=*None*,
        **rgauges**=*None*,
        **interpolation**=*"rst"*,
        **isettings**=*None*,
        **pmethod**=*"count"*,
        **step**=*1*,
        **color**=*None*,
        **user**=*None*,
        **password**=*None*,
        **schema**=*"temp4"*,
        **flags**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.r_mwprecip_py(database="name")
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **database**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;PostgreSQL database containing input data  
    **statfce**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Choose method for compute bs from time intervals  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *avg, mode, quantile*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *mode*  
    **quantile**=*integer*  
    &nbsp;&nbsp;&nbsp;&nbsp;Set quantile  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *96*  
    **roundm**=*integer*  
    &nbsp;&nbsp;&nbsp;&nbsp;Round to "m" decimal places for computing mode  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *3*  
    **aw**=*float*  
    &nbsp;&nbsp;&nbsp;&nbsp;aw value  
    &nbsp;&nbsp;&nbsp;&nbsp;Wetting antenna value Aw[dB]  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1.5*  
    **baseltime**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Set interval or just time when not raining (see the manual)  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input file  
    **baselfile**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Baseline values in format "linkid,baseline"  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input file  
    **interval**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Summing precipitation per  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *minute,  hour,  day*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *minute*  
    **fromtime**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;First timestamp "YYYY-MM-DD H:M:S"  
    &nbsp;&nbsp;&nbsp;&nbsp;Set first timestamp to create timewindows  
    **totime**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Last timestamp "YYYY-MM-DD H:M:S"  
    &nbsp;&nbsp;&nbsp;&nbsp;Set last timestamp to create timewindows  
    **lignore**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Linkid ignore list  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input file  
    **rgauges**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Path to folder with rain rauge files  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input directory  
    **interpolation**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Type of interpolation  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *bspline,  idw,  rst*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *rst*  
    **isettings**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Interpolation command string  
    &nbsp;&nbsp;&nbsp;&nbsp;Additional settings for choosen interpolation (see manual)  
    **pmethod**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Type of interpolation  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *permeter,  count*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *count*  
    **step**=*integer*  
    &nbsp;&nbsp;&nbsp;&nbsp;Setting for parameter pmethod  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1*  
    **color**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Set color table  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input file  
    **user**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;User name  
    &nbsp;&nbsp;&nbsp;&nbsp;Connect to the database as the user username instead of the default.  
    **password**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Password  
    &nbsp;&nbsp;&nbsp;&nbsp;Password will be stored in file!  
    **schema**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of db schema for results  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *temp4*  
    **-g**  
    &nbsp;&nbsp;&nbsp;&nbsp;Run GRASS analysis  
    **-q**  
    &nbsp;&nbsp;&nbsp;&nbsp;Do not set region from modul settings  
    **-p**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print info about timestamp(first,last) in db  
    **-r**  
    &nbsp;&nbsp;&nbsp;&nbsp;Remove temporary working schema and data folder  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **database** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;PostgreSQL database containing input data  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: dbname, *name*  
    **statfce** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Choose method for compute bs from time intervals  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *avg, mode, quantile*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *mode*  
    **quantile** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Set quantile  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *96*  
    **roundm** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Round to "m" decimal places for computing mode  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *3*  
    **aw** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;aw value  
    &nbsp;&nbsp;&nbsp;&nbsp;Wetting antenna value Aw[dB]  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1.5*  
    **baseltime** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Set interval or just time when not raining (see the manual)  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input file  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, file, *name*  
    **baselfile** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Baseline values in format "linkid,baseline"  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input file  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, file, *name*  
    **interval** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Summing precipitation per  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *minute,  hour,  day*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *minute*  
    **fromtime** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;First timestamp "YYYY-MM-DD H:M:S"  
    &nbsp;&nbsp;&nbsp;&nbsp;Set first timestamp to create timewindows  
    **totime** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Last timestamp "YYYY-MM-DD H:M:S"  
    &nbsp;&nbsp;&nbsp;&nbsp;Set last timestamp to create timewindows  
    **lignore** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Linkid ignore list  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input file  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, file, *name*  
    **rgauges** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Path to folder with rain rauge files  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input directory  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, dir, *name*  
    **interpolation** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Type of interpolation  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *bspline,  idw,  rst*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *rst*  
    **isettings** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Interpolation command string  
    &nbsp;&nbsp;&nbsp;&nbsp;Additional settings for choosen interpolation (see manual)  
    **pmethod** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Type of interpolation  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *permeter,  count*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *count*  
    **step** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Setting for parameter pmethod  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1*  
    **color** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Set color table  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input file  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, file, *name*  
    **user** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;User name  
    &nbsp;&nbsp;&nbsp;&nbsp;Connect to the database as the user username instead of the default.  
    **password** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Password  
    &nbsp;&nbsp;&nbsp;&nbsp;Password will be stored in file!  
    **schema** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of db schema for results  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *temp4*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *g*, *q*, *p*, *r*  
    &nbsp;&nbsp;&nbsp;&nbsp;**g**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Run GRASS analysis  
    &nbsp;&nbsp;&nbsp;&nbsp;**q**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Do not set region from modul settings  
    &nbsp;&nbsp;&nbsp;&nbsp;**p**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Print info about timestamp(first,last) in db  
    &nbsp;&nbsp;&nbsp;&nbsp;**r**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Remove temporary working schema and data folder  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **database** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;PostgreSQL database containing input data  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: dbname, *name*  
    **statfce** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Choose method for compute bs from time intervals  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *avg, mode, quantile*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *mode*  
    **quantile** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Set quantile  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *96*  
    **roundm** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Round to "m" decimal places for computing mode  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *3*  
    **aw** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;aw value  
    &nbsp;&nbsp;&nbsp;&nbsp;Wetting antenna value Aw[dB]  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1.5*  
    **baseltime** : str | io.StringIO, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Set interval or just time when not raining (see the manual)  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input file  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, file, *name*  
    **baselfile** : str | io.StringIO, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Baseline values in format "linkid,baseline"  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input file  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, file, *name*  
    **interval** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Summing precipitation per  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *minute,  hour,  day*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *minute*  
    **fromtime** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;First timestamp "YYYY-MM-DD H:M:S"  
    &nbsp;&nbsp;&nbsp;&nbsp;Set first timestamp to create timewindows  
    **totime** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Last timestamp "YYYY-MM-DD H:M:S"  
    &nbsp;&nbsp;&nbsp;&nbsp;Set last timestamp to create timewindows  
    **lignore** : str | io.StringIO, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Linkid ignore list  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input file  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, file, *name*  
    **rgauges** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Path to folder with rain rauge files  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input directory  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, dir, *name*  
    **interpolation** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Type of interpolation  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *bspline,  idw,  rst*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *rst*  
    **isettings** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Interpolation command string  
    &nbsp;&nbsp;&nbsp;&nbsp;Additional settings for choosen interpolation (see manual)  
    **pmethod** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Type of interpolation  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *permeter,  count*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *count*  
    **step** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Setting for parameter pmethod  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1*  
    **color** : str | io.StringIO, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Set color table  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input file  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, file, *name*  
    **user** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;User name  
    &nbsp;&nbsp;&nbsp;&nbsp;Connect to the database as the user username instead of the default.  
    **password** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Password  
    &nbsp;&nbsp;&nbsp;&nbsp;Password will be stored in file!  
    **schema** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of db schema for results  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *temp4*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *g*, *q*, *p*, *r*  
    &nbsp;&nbsp;&nbsp;&nbsp;**g**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Run GRASS analysis  
    &nbsp;&nbsp;&nbsp;&nbsp;**q**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Do not set region from modul settings  
    &nbsp;&nbsp;&nbsp;&nbsp;**p**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Print info about timestamp(first,last) in db  
    &nbsp;&nbsp;&nbsp;&nbsp;**r**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Remove temporary working schema and data folder  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

## AUTHOR

Matej Krejci, Czech Technical University in Prague, Czech Republic

## SOURCE CODE

Available at: [r.mwprecip source code](https://github.com/OSGeo/grass-addons/tree/grass8/src/raster/r.mwprecip)
([history](https://github.com/OSGeo/grass-addons/commits/grass8/src/raster/r.mwprecip))  
Latest change: Thursday Feb 20 13:02:26 2025 in commit [53de819](https://github.com/OSGeo/grass-addons/commit/53de8196a10ba5a8a9121898ce87861d227137e3)
