---
name: r.null
description: Manages NULL-values of given raster map.
keywords: [ raster, map management, null data, no-data ]
---

# r.null

Manages NULL-values of given raster map.

=== "Command line"

    **r.null**
    [**-fincrz**]
    **map**=*name*
    [**setnull**=*val[-val]* [,*val[-val]*,...]]
    [**null**=*float*]
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    r.null map=name
    ```

=== "Python (grass.script)"

    *grass.script.run_command*("***r.null***",
        **map**,
        **setnull**=*None*,
        **null**=*None*,
        **flags**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.run_command("r.null", map="name")
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.r_null*(**map**,
        **setnull**=*None*,
        **null**=*None*,
        **flags**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.r_null(map="name")
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **map**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of raster map for which to edit null values  
    **setnull**=*val[-val]* [,*val[-val]*,...]  
    &nbsp;&nbsp;&nbsp;&nbsp;List of cell values to be set to NULL  
    **null**=*float*  
    &nbsp;&nbsp;&nbsp;&nbsp;The value to replace the null value by  
    **-f**  
    &nbsp;&nbsp;&nbsp;&nbsp;Only do the work if the map is floating-point  
    **-i**  
    &nbsp;&nbsp;&nbsp;&nbsp;Only do the work if the map is integer  
    **-n**  
    &nbsp;&nbsp;&nbsp;&nbsp;Only do the work if the map doesn't have a NULL-value bitmap file  
    **-c**  
    &nbsp;&nbsp;&nbsp;&nbsp;Create NULL-value bitmap file validating all data cells  
    **-r**  
    &nbsp;&nbsp;&nbsp;&nbsp;Remove NULL-value bitmap file  
    **-z**  
    &nbsp;&nbsp;&nbsp;&nbsp;Re-create NULL-value bitmap file (to compress or uncompress)  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **map** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of raster map for which to edit null values  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **setnull** : str | list[str], *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;List of cell values to be set to NULL  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *val[-val]*  
    **null** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;The value to replace the null value by  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *f*, *i*, *n*, *c*, *r*, *z*  
    &nbsp;&nbsp;&nbsp;&nbsp;**f**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Only do the work if the map is floating-point  
    &nbsp;&nbsp;&nbsp;&nbsp;**i**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Only do the work if the map is integer  
    &nbsp;&nbsp;&nbsp;&nbsp;**n**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Only do the work if the map doesn't have a NULL-value bitmap file  
    &nbsp;&nbsp;&nbsp;&nbsp;**c**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Create NULL-value bitmap file validating all data cells  
    &nbsp;&nbsp;&nbsp;&nbsp;**r**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Remove NULL-value bitmap file  
    &nbsp;&nbsp;&nbsp;&nbsp;**z**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Re-create NULL-value bitmap file (to compress or uncompress)  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **map** : str | np.ndarray, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of raster map for which to edit null values  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **setnull** : str | list[str], *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;List of cell values to be set to NULL  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *val[-val]*  
    **null** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;The value to replace the null value by  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *f*, *i*, *n*, *c*, *r*, *z*  
    &nbsp;&nbsp;&nbsp;&nbsp;**f**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Only do the work if the map is floating-point  
    &nbsp;&nbsp;&nbsp;&nbsp;**i**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Only do the work if the map is integer  
    &nbsp;&nbsp;&nbsp;&nbsp;**n**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Only do the work if the map doesn't have a NULL-value bitmap file  
    &nbsp;&nbsp;&nbsp;&nbsp;**c**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Create NULL-value bitmap file validating all data cells  
    &nbsp;&nbsp;&nbsp;&nbsp;**r**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Remove NULL-value bitmap file  
    &nbsp;&nbsp;&nbsp;&nbsp;**z**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Re-create NULL-value bitmap file (to compress or uncompress)  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

The function of *r.null* is to explicitly create the NULL-value bitmap
file. The intended usage is to update maps that do not have a NULL-value
bitmap file (i.e. to indicate for each pixel if zero is a valid value or
is to be considered as NULL, i.e. no data value). The module does not
work with reclassified or external maps.

The design is flexible. Ranges of values can be set to NULL and/or the
NULL value can be eliminated and replace with a specified value.

The **setnull** parameter is used to specify values in the ranges to be
set to NULL. A range is either a single value (e.g., 5.3), or a pair of
values (e.g., 4.76-34.56). Existing NULL-values are left NULL, unless
the null argument is requested.

The **null** parameter eliminates the NULL value and replaces it with
value. This argument is applied only to existing NULL values, and not to
the NULLs created by the setnull argument.

## NOTES

Note that the value is restricted to integer if the map is an integer
map.

### r.null and reclassified maps

*r.null* does not support reclassified maps because, if *r.null* was run
on the reclass raster it would alter the original and any other reclass
rasters of the original. Therefore *r.null* does not allow recoding
reclassified maps (products of *r.reclass*).  
As a workaround, the way to recode such a map is: The user creates a
raster map out of the reclassified map by copying it:  

```sh
r.mapcalc "newmap = reclass"
```

### NULL data compression

By default no data files (i.e., NULL files) are not compressed unless a
specific environment variable is set. The NULL file compression must be
explicitly turned on with `export GRASS_COMPRESS_NULLS=1`.  
Warning: such raster maps can then only be opened with GRASS GIS 7.2.0
or later. NULL file compression can be managed with **r.null -z**.

### External maps

From the [r.external](r.external.md) documentation: GDAL-linked
(*r.external*) maps do not have or use a NULL bitmap, hence *r.null*
cannot manipulate them directly. Here NULL cells are those whose value
matches the value reported by the GDALGetRasterNoDataValue() function.
To introduce additional NULL values to a computation based on a
GDAL-linked raster, the user needs to either create a mask with with
*r.mask* and then "apply" it using e.g. *r.resample* or *r.mapcalc*, or
use *r.mapcalc* to create a copy with the appropriate categories changed
to NULL (`if()` condition).

## EXAMPLES

Set specific values of a classified map to NULL:  

```sh
r.null map=landcover.30m setnull=21,22
```

Set NULL-values of a map to a specific value:  

```sh
r.null map=fields null=99
```

## SEE ALSO

*[r.compress](r.compress.md), [r.support](r.support.md),
[r.quant](r.quant.md)*

## AUTHOR

U.S.Army Construction Engineering Research Laboratory

## SOURCE CODE

Available at: [r.null source code](https://github.com/OSGeo/grass/tree/main/raster/r.null)
([history](https://github.com/OSGeo/grass/commits/main/raster/r.null))  
Latest change: Friday Mar 07 10:39:45 2025 in commit [4b9d1a2](https://github.com/OSGeo/grass/commit/4b9d1a2dcde590db4ab3ba1cbbb50af2768aed25)
