---
name: r.object.thickness.py
description: Evaluates minimum, maximum and mean thickness of objects of a given category on a raster map.
keywords: [ raster, algebra, size, clumps ]
---

# r.object.thickness.py

Evaluates minimum, maximum and mean thickness of objects of a given category on a raster map.

=== "Command line"

    **r.object.thickness.py**
    **input**=*name*
    **category**=*integer*
    **tsize**=*float*
    **tspace**=*float*
    **resolutiondir**=*string*
    [**rmedian**=*name*]
    [**vmedian**=*name*]
    [**vcategories**=*name*]
    [**transects**=*name*]
    [**itransects**=*name*]
    [**csvfilename**=*name*]
    [**metric**=*string*]
    [**transect_perpendicular**=*string*]
    [**iterations**=*integer*]
    [**--overwrite**]
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    r.object.thickness.py input=name category=0 tsize=100 tspace=2 resolutiondir=N-S
    ```

=== "Python (grass.script)"

    *grass.script.run_command*("***r.object.thickness.py***",
        **input**,
        **category**,
        **tsize**=*100*,
        **tspace**=*2*,
        **resolutiondir**=*"N-S"*,
        **rmedian**=*None*,
        **vmedian**=*None*,
        **vcategories**=*None*,
        **transects**=*None*,
        **itransects**=*None*,
        **csvfilename**=*None*,
        **metric**=*"straight"*,
        **transect_perpendicular**=*"trend"*,
        **iterations**=*200*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.run_command("r.object.thickness.py", input="name", category=0, tsize=100, tspace=2, resolutiondir="N-S")
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.r_object_thickness_py*(**input**,
        **category**,
        **tsize**=*100*,
        **tspace**=*2*,
        **resolutiondir**=*"N-S"*,
        **rmedian**=*None*,
        **vmedian**=*None*,
        **vcategories**=*None*,
        **transects**=*None*,
        **itransects**=*None*,
        **csvfilename**=*None*,
        **metric**=*"straight"*,
        **transect_perpendicular**=*"trend"*,
        **iterations**=*200*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.r_object_thickness_py(input="name", category=0, tsize=100, tspace=2, resolutiondir="N-S")
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **input**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input raster map  
    **category**=*integer* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Category to evaluate  
    **tsize**=*float* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Expected maximum size in map units  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *100*  
    **tspace**=*float* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Transect spacing in map units  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *2*  
    **resolutiondir**=*string* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Resolution for output in pixels  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *N-S, E-W*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *N-S*  
    **rmedian**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Raster map of median lines  
    **vmedian**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Vector map of median lines  
    **vcategories**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Vector map of areas  
    **transects**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Vector map of complete transects  
    **itransects**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Vector map of inner transects  
    **csvfilename**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;CSV output file  
    **metric**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Determines how transect spacing is measured  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *straight,  along*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *straight*  
    &nbsp;&nbsp;&nbsp;&nbsp;**straight**: Straight distance between transect points  
    &nbsp;&nbsp;&nbsp;&nbsp;**along**: Distance along the line (see v.transect for details)  
    **transect_perpendicular**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Determines which line is the transect perpendicular to  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *trend,  line*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *trend*  
    &nbsp;&nbsp;&nbsp;&nbsp;**trend**:  Perpendicular to the line connecting transect points. line  
    **iterations**=*integer*  
    &nbsp;&nbsp;&nbsp;&nbsp;Maximum number of iterations (used during thinning)  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *200*  
    **--overwrite**  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **input** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **category** : int, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Category to evaluate  
    **tsize** : float, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Expected maximum size in map units  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *100*  
    **tspace** : float, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Transect spacing in map units  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *2*  
    **resolutiondir** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Resolution for output in pixels  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *N-S, E-W*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *N-S*  
    **rmedian** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Raster map of median lines  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster, *name*  
    **vmedian** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Vector map of median lines  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, vector, *name*  
    **vcategories** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Vector map of areas  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, vector, *name*  
    **transects** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Vector map of complete transects  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, vector, *name*  
    **itransects** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Vector map of inner transects  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, vector, *name*  
    **csvfilename** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;CSV output file  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, file, *name*  
    **metric** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Determines how transect spacing is measured  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *straight,  along*  
    &nbsp;&nbsp;&nbsp;&nbsp;**straight**: Straight distance between transect points  
    &nbsp;&nbsp;&nbsp;&nbsp;**along**: Distance along the line (see v.transect for details)  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *straight*  
    **transect_perpendicular** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Determines which line is the transect perpendicular to  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *trend,  line*  
    &nbsp;&nbsp;&nbsp;&nbsp;**trend**:  Perpendicular to the line connecting transect points. line  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *trend*  
    **iterations** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Maximum number of iterations (used during thinning)  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *200*  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **input** : str | np.ndarray, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **category** : int, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Category to evaluate  
    **tsize** : float, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Expected maximum size in map units  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *100*  
    **tspace** : float, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Transect spacing in map units  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *2*  
    **resolutiondir** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Resolution for output in pixels  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *N-S, E-W*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *N-S*  
    **rmedian** : str | type(np.ndarray) | type(np.array) | type(gs.array.array), *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Raster map of median lines  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster, *name*  
    **vmedian** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Vector map of median lines  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, vector, *name*  
    **vcategories** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Vector map of areas  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, vector, *name*  
    **transects** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Vector map of complete transects  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, vector, *name*  
    **itransects** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Vector map of inner transects  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, vector, *name*  
    **csvfilename** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;CSV output file  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, file, *name*  
    **metric** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Determines how transect spacing is measured  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *straight,  along*  
    &nbsp;&nbsp;&nbsp;&nbsp;**straight**: Straight distance between transect points  
    &nbsp;&nbsp;&nbsp;&nbsp;**along**: Distance along the line (see v.transect for details)  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *straight*  
    **transect_perpendicular** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Determines which line is the transect perpendicular to  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *trend,  line*  
    &nbsp;&nbsp;&nbsp;&nbsp;**trend**:  Perpendicular to the line connecting transect points. line  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *trend*  
    **iterations** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Maximum number of iterations (used during thinning)  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *200*  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | np.ndarray | tuple[np.ndarray] | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned. If an array type (e.g., *np.ndarray*) is used for one of the raster outputs, the result will be an array and will have the shape corresponding to the computational region. If an array type is used for more than one raster output, the result will be a tuple of arrays.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

*r.object.thickness* evaluates the minimum, maximum, and mean thickness of
objects of a given category on a raster map.

The thickness is reported both in map units and pixels. The module is primarily
used to estimate the neighborhood window size for filters, such as those used by
[r.neighbors](https://grass.osgeo.org/grass-stable/manuals/r.neighbors.html) and
[r.fill.category](https://grass.osgeo.org/grass-stable/manuals/addons/r.fill.category.html).

Another use case is to estimate the width of small landscape elements (SLE),
e.g., to complement statistics computed by
[r.object.geometry](https://grass.osgeo.org/grass-stable/manuals/r.object.geometry.html)

Object thickness is evaluated by creating transects along the median lines of
the raster objects, clipping them with objects themselves, and evaluating their
lengths. This is done using the *v.transects* addon, which must therefore
be installed to run this module.

Optionally, *r.object.thickness* can save a CSV file containing the complete
list of the lengths of the parts of all created transects inside the objects. It
is possible to save a vector map containing the transects, a vector map
containing the clipped transects and maps containing the median lines of the
objects, in both raster and vector format. The attribute table of the latter
contains the average, minimum, and maximum widths of the transects within the
objects.

## PARAMETERS

The user must indicate the category of the objects whose thickness should
be evaluated, as well as the expected maximum length of the transects and
their spacing.

The expected maximum length of the transects is used to create the transects
before clipping them with the raster objects. It must therefore be large enough
to contain the longer cross section of the biggest object. The module issues a
warning if the maximum evaluated thickness is less than or equal to the expected
maximum: in that case, at least one transect has not been clipped because it
does not intersect the object boundary. Therefore, the expected maximum size
parameter must be raised.

Transect spacing controls the distance between transects along the median line.
It must be chosen so that at least one transect is created on each median line.
Smaller values can provide slightly more accurate results but require more
processing time. As a rule of thumb, a good starting point is setting transects
spacing around 1/50 of the expected maximum size, but the minimum value can
change. If the transects spacing value is too low, no transect is created and no
thickness can be evaluated: in that case, the module issues an error and stops.

It is possible to choose the direction (N-S or E-W) of the region resolution
used to convert the estimated lengths in pixels. The choice is irrelevant for
regions with square cells.

By default, the transect spacing is measured as straight distances between the
transects (default) or along the line. This is set by the **metric** parameter.
In addition, the parameter **transect_perpendicular** determines whether the
transects are generated perpendicular to either the input line or to the line
connecting the transect points. See the manual page of
[v.transects](https://grass.osgeo.org/grass-stable/manuals/addons/v.transects.html)
for more details.

Optional maps containing the median lines of the objects, in both raster and
vector format, the vector map containing the transects, and the vector map
containing the clipped transects are created only if a name is provided for
them. In the same way, a CSV file containing the complete list of the lengths of
the parts of all created transects inside the objects is also created only if a
file name is given.

## EXAMPLE

In this example, the width of the water bodies in the *landuse* map in the North
Carolina sample dataset is evaluated:

```sh
# set the region on the landuse map
g.region rast=landuse@PERMANENT
# evaluate the thickness of water bodies (category 6) in the landuse map
# create a vector map containing the median lines called median
# create a vector map containing the transects inside the water bodies
# called transects_in
r.object.thickness input=landuse@PERMANENT category=6 tsize=4000 tspace=100 \
vmedian=median itransects=transects_in
```

outputs

```text
Thickness in map units: 
min = 1.525433 
max = 2962.446155 
mean = 301.059197

Thickness in pixels: 
min = 0.053524
max = 103.945479
mean = 10.563481
```

## SEE ALSO

*[r.neighbors](https://grass.osgeo.org/grass-stable/manuals/r.neighbors.html),
[r.reclass.area](https://grass.osgeo.org/grass-stable/manuals/r.fill.category),
[v.transects](https://grass.osgeo.org/grass-stable/manuals/v.transects)*

## AUTHOR

- Paolo Zatelli, DICAM, University of Trento, Italy (original version)
- Paulo van Breugel, HAS green academy, Netherlands (add stats to generated
vector layers).

## SOURCE CODE

Available at: [r.object.thickness source code](https://github.com/OSGeo/grass-addons/tree/grass8/src/raster/r.object.thickness)
([history](https://github.com/OSGeo/grass-addons/commits/grass8/src/raster/r.object.thickness))  
Latest change: Friday Jun 06 23:38:55 2025 in commit [1ff8dde](https://github.com/OSGeo/grass-addons/commit/1ff8ddee6a01630b69dba1cbc92c31c588b10b86)
