---
name: r.pi.corr.mw
description: Moving window correlation analysis.
keywords: [ raster, landscape structure analysis, correlation analysis ]
---

# r.pi.corr.mw

Moving window correlation analysis.

=== "Command line"

    **r.pi.corr.mw**
    **input1**=*name*
    **input2**=*name*
    **output**=*name*
    **size**=*integer*
    **max**=*integer*
    [**title**=*"phrase"*]
    [**--overwrite**]
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    r.pi.corr.mw input1=name input2=name output=name size=0 max=0
    ```

=== "Python (grass.script)"

    *grass.script.run_command*("***r.pi.corr.mw***",
        **input1**,
        **input2**,
        **output**,
        **size**,
        **max**,
        **title**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.run_command("r.pi.corr.mw", input1="name", input2="name", output="name", size=0, max=0)
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.r_pi_corr_mw*(**input1**,
        **input2**,
        **output**,
        **size**,
        **max**,
        **title**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.r_pi_corr_mw(input1="name", input2="name", output="name", size=0, max=0)
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **input1**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input raster map  
    **input2**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input raster map  
    **output**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output raster map  
    **size**=*integer* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Neighborhood size  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *1, 3, 5, 7, 9, 11, 13, 15, 17, 19, 21, 23, 25*  
    **max**=*integer* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;In order to receive more information of the decimal places, set it to e.g. 1000  
    **title**=*"phrase"*  
    &nbsp;&nbsp;&nbsp;&nbsp;Title for resultant raster map  
    **--overwrite**  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **input1** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **input2** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **output** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster, *name*  
    **size** : int, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Neighborhood size  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *1, 3, 5, 7, 9, 11, 13, 15, 17, 19, 21, 23, 25*  
    **max** : int, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;In order to receive more information of the decimal places, set it to e.g. 1000  
    **title** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Title for resultant raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *"phrase"*  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **input1** : str | np.ndarray, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **input2** : str | np.ndarray, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **output** : str | type(np.ndarray) | type(np.array) | type(gs.array.array), *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster, *name*  
    **size** : int, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Neighborhood size  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *1, 3, 5, 7, 9, 11, 13, 15, 17, 19, 21, 23, 25*  
    **max** : int, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;In order to receive more information of the decimal places, set it to e.g. 1000  
    **title** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Title for resultant raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *"phrase"*  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | np.ndarray | tuple[np.ndarray] | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned. If an array type (e.g., *np.ndarray*) is used for one of the raster outputs, the result will be an array and will have the shape corresponding to the computational region. If an array type is used for more than one raster output, the result will be a tuple of arrays.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

*r.pi.corr.mw* provides information concerning the correlation of pixels
inside a moving window between two raster files.

It calculates correlation of two raster maps by calculating correlation
function of two corresponding rectangular areas for each raster point
and writing the result into a new raster map.

## NOTES

This module computes the correlation between two raster files but unlike
*r.pi.lm* for moving windows of a specific size. This module is partly
based on *r.neighbors* and *r.covar*.

## EXAMPLE

An example for the North Carolina sample dataset: Correlation of all
pixels within a 7x7 sized window of two rasters (elevation and slope).
The output is multiplied by 10000 for higher precision

```sh
g.region rast=elevation -p
r.pi.corr.mw input1=slope input2=elevation output=corrwin1 size=7 max=10000
r.colors corrwin1 col=bgyr
```

## SEE ALSO

*[r.pi.index](r.pi.index.md), [r.pi.lm](r.pi.lm.md), [r.pi](r.pi.md)*

## AUTHORS

Programming: Elshad Shirinov  
Scientific concept: Dr. Martin Wegmann  
Department of Remote Sensing  
Remote Sensing and Biodiversity Unit  
University of Wuerzburg, Germany

Port to GRASS GIS 7: Markus Metz

## SOURCE CODE

Available at: [r.pi.corr.mw source code](https://github.com/OSGeo/grass-addons/tree/grass8/raster/r.pi/r.pi.corr.mw)
([history](https://github.com/OSGeo/grass-addons/commits/grass8/raster/r.pi/r.pi.corr.mw))  
Latest change: Thursday Feb 20 13:02:26 2025 in commit [53de819](https://github.com/OSGeo/grass-addons/commit/53de8196a10ba5a8a9121898ce87861d227137e3)
