---
name: r.pi.enn
description: Analysis of n-th Euclidean Nearest Neighbor distance.
keywords: [ raster, landscape structure analysis, patch index ]
---

# r.pi.enn

Analysis of n-th Euclidean Nearest Neighbor distance.

=== "Command line"

    **r.pi.enn**
    [**-a**]
    **input**=*name*
    **output**=*name*
    **keyval**=*integer*
    **method**=*string* [,*string*,...]
    **number**=*num[-num]* [,*num[-num]*,...]
    **statmethod**=*string*
    [**dmout**=*string*]
    [**adj_matrix**=*string*]
    [**title**=*"phrase"*]
    [**--overwrite**]
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    r.pi.enn input=name output=name keyval=0 method=distance number=num[-num] statmethod=average
    ```

=== "Python (grass.script)"

    *grass.script.run_command*("***r.pi.enn***",
        **input**,
        **output**,
        **keyval**,
        **method**,
        **number**,
        **statmethod**,
        **dmout**=*None*,
        **adj_matrix**=*None*,
        **title**=*None*,
        **flags**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.run_command("r.pi.enn", input="name", output="name", keyval=0, method="distance", number="num[-num]", statmethod="average")
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.r_pi_enn*(**input**,
        **output**,
        **keyval**,
        **method**,
        **number**,
        **statmethod**,
        **dmout**=*None*,
        **adj_matrix**=*None*,
        **title**=*None*,
        **flags**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.r_pi_enn(input="name", output="name", keyval=0, method="distance", number="num[-num]", statmethod="average")
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **input**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input raster map  
    **output**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output raster map  
    **keyval**=*integer* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Key value  
    **method**=*string* [,*string*,...] **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Operation to perform on fragments  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *distance, path_distance, area, perimeter, shapeindex*  
    **number**=*num[-num]* [,*num[-num]*,...] **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Number of nearest neighbors to analyse  
    **statmethod**=*string* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Statistical method to perform on the values  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *average, variance, standard deviation, value, sum*  
    **dmout**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Output name for distance matrix and id-map (performed if not empty)  
    **adj_matrix**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Output name for adjacency matrix (performed if not empty)  
    **title**=*"phrase"*  
    &nbsp;&nbsp;&nbsp;&nbsp;Title for resultant raster map  
    **-a**  
    &nbsp;&nbsp;&nbsp;&nbsp;Set for 8 cell-neighbors. 4 cell-neighbors are default  
    **--overwrite**  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **input** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **output** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster, *name*  
    **keyval** : int, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Key value  
    **method** : str | list[str], *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Operation to perform on fragments  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *distance, path_distance, area, perimeter, shapeindex*  
    **number** : str | list[str], *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Number of nearest neighbors to analyse  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *num[-num]*  
    **statmethod** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Statistical method to perform on the values  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *average, variance, standard deviation, value, sum*  
    **dmout** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Output name for distance matrix and id-map (performed if not empty)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster  
    **adj_matrix** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Output name for adjacency matrix (performed if not empty)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster  
    **title** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Title for resultant raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *"phrase"*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *a*  
    &nbsp;&nbsp;&nbsp;&nbsp;**a**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Set for 8 cell-neighbors. 4 cell-neighbors are default  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **input** : str | np.ndarray, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **output** : str | type(np.ndarray) | type(np.array) | type(gs.array.array), *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster, *name*  
    **keyval** : int, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Key value  
    **method** : str | list[str], *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Operation to perform on fragments  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *distance, path_distance, area, perimeter, shapeindex*  
    **number** : str | list[str], *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Number of nearest neighbors to analyse  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *num[-num]*  
    **statmethod** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Statistical method to perform on the values  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *average, variance, standard deviation, value, sum*  
    **dmout** : str | type(np.ndarray) | type(np.array) | type(gs.array.array), *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Output name for distance matrix and id-map (performed if not empty)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster  
    **adj_matrix** : str | type(np.ndarray) | type(np.array) | type(gs.array.array), *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Output name for adjacency matrix (performed if not empty)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster  
    **title** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Title for resultant raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *"phrase"*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *a*  
    &nbsp;&nbsp;&nbsp;&nbsp;**a**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Set for 8 cell-neighbors. 4 cell-neighbors are default  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | np.ndarray | tuple[np.ndarray] | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned. If an array type (e.g., *np.ndarray*) is used for one of the raster outputs, the result will be an array and will have the shape corresponding to the computational region. If an array type is used for more than one raster output, the result will be a tuple of arrays.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

*r.pi.enn* computes the euclidean distance between patches (1-n NN).
Analysis of n-th euclidean nearest neighbour distance.

## NOTES

The user must specify the names of the raster map layers to be used for
*input* and *output*, the *keyval* the *method* (e.g. distance, area)
and *statmethod* used (i.e., average).

Within *r.pi.enn* the following setting have to be set:

### keyval setting

The *keyval* operator determines which category value is taken for the
Patch Index analysis.

### Method setting

The *method* operators determine what measure is applied on the nth NN.

- **Distance**  
    The *Average* computes the average distance of the n NN.
- **Path distance**  
    The *path\_distance* computes the actual distance to the n NN.
- **Area**  
    The *area* computes the area of the n NN.
- **Perimeter**  
    The *perimeter* computes the perimeter of the n NN.
- **SHAPE Index**  
    The *shapeindex* computes the SHAPE Index of the n NN.

### Statmethod setting

The *statmethod* operators determine what statistic measure is applied
on the nth NN.

- **Average**  
    The *Average* computes the average distance of the n NN.
- **Variance**  
    The *Variance* computes the variance of the distance of the n NN.
- **Std. Dev.**  
    The *Std. Dev* computes the std. dev. of the distance of the n NN.

### Number

The *keyval* operator determines which or how many Nearest Neighbour are
analysed. *1,2,5* will analyse the 1, 2 and 5th Nearest Neigbour. *1-10*
will analyse the 1, 2, 3, ... 10th Nearest Neighbour. *0* will analyse
all Nearest Neighbours.

### Distancematrix

The *dmout* operator is optional and determines if a distance matrix is
written (first NN only). *1,2,5* will analyse the 1, 2 and 5th Nearest
Neigbour. *1-10* will analyse the 1, 2, 3, ... 10th Nearest Neighbour.
*0* will analyse all Nearest Neighbours.

## EXAMPLE

An example for the North Carolina sample dataset:

```sh
r.pi.enn input=landclass96 output=dist1.c5 keyval=5 method=distance number=1 statmethod=average
# -> gives a map of patches (all of category of 5) with the average distance to their first NN

r.pi.enn input=landclass96 output=dist10.c5 keyval=5 method=distance number=10 statmethod=average
# -> gives a map of patches (all of category of 5) with the average distance to their first-10th NN

r.pi.enn input=landclass96 output=dist1.5.10.c5 keyval=5 method=distance number=1,5,10 statmethod=average
# -> gives a map of patches (all of category of 5) with the average distance to their first, first-to-fifth and first-to-10th NN

r.pi.enn input=landclass96 output=dist10b.c5 keyval=5 method=path_distance number=10 statmethod=average
# -> gives a map of patches (all of category of 5) with the actual distance to the 10th NN
```

## SEE ALSO

*[r.pi.index](r.pi.index.md), [r.fragment.dist](r.fragment.dist.md),
[r.pi.enn](r.pi.enn.md), [r.pi.enn.pr](r.pi.enn.pr.md),
[r.fragment.neighbors](r.fragment.neighbors.md),
[r.li](https://grass.osgeo.org/grass-stable/manuals/r.li.setup.html)*

## AUTHORS

Programming: Elshad Shirinov  
Scientific concept: Dr. Martin Wegmann  
Department of Remote Sensing  
Remote Sensing and Biodiversity Unit  
University of Wuerzburg, Germany

Port to GRASS GIS 7: Markus Metz

## SOURCE CODE

Available at: [r.pi.enn source code](https://github.com/OSGeo/grass-addons/tree/grass8/raster/r.pi/r.pi.enn)
([history](https://github.com/OSGeo/grass-addons/commits/grass8/raster/r.pi/r.pi.enn))  
Latest change: Friday Feb 21 12:27:42 2025 in commit [8fce680](https://github.com/OSGeo/grass-addons/commit/8fce680a2170ee81eff27fdf4315079b10a10f83)
