---
name: r.pi.fnn
description: Determines patches of given value and performs a nearest-neighbor analysis.
keywords: [ raster, landscape structure analysis, patch index ]
---

# r.pi.fnn

Determines patches of given value and performs a nearest-neighbor analysis.

=== "Command line"

    **r.pi.fnn**
    [**-a**]
    **input**=*name*
    **costmap**=*string*
    **output**=*name*
    **keyval**=*integer*
    **method**=*string* [,*string*,...]
    **number**=*num[-num]* [,*num[-num]*,...]
    **statmethod**=*string*
    [**dmout**=*string*]
    [**adj_matrix**=*string*]
    [**title**=*"phrase"*]
    [**--overwrite**]
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    r.pi.fnn input=name costmap=string output=name keyval=0 method=distance number=num[-num] statmethod=average
    ```

=== "Python (grass.script)"

    *grass.script.run_command*("***r.pi.fnn***",
        **input**,
        **costmap**,
        **output**,
        **keyval**,
        **method**,
        **number**,
        **statmethod**,
        **dmout**=*None*,
        **adj_matrix**=*None*,
        **title**=*None*,
        **flags**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.run_command("r.pi.fnn", input="name", costmap="string", output="name", keyval=0, method="distance", number="num[-num]", statmethod="average")
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.r_pi_fnn*(**input**,
        **costmap**,
        **output**,
        **keyval**,
        **method**,
        **number**,
        **statmethod**,
        **dmout**=*None*,
        **adj_matrix**=*None*,
        **title**=*None*,
        **flags**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.r_pi_fnn(input="name", costmap="string", output="name", keyval=0, method="distance", number="num[-num]", statmethod="average")
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **input**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input raster map  
    **costmap**=*string* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of existing raster file with path-cost information  
    **output**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output raster map  
    **keyval**=*integer* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Key value  
    **method**=*string* [,*string*,...] **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Operation to perform on fragments  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *distance, path_distance, area, perimeter, shapeindex*  
    **number**=*num[-num]* [,*num[-num]*,...] **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Number of nearest neighbors to analyse  
    **statmethod**=*string* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Statistical method to perform on the values  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *average, variance, standard deviation, value, sum*  
    **dmout**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Output name for distance matrix and id-map (performed if not empty)  
    **adj_matrix**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Output name for adjacency matrix (performed if not empty)  
    **title**=*"phrase"*  
    &nbsp;&nbsp;&nbsp;&nbsp;Title for resultant raster map  
    **-a**  
    &nbsp;&nbsp;&nbsp;&nbsp;Set for 8 cell-neighbors. 4 cell-neighbors are default  
    **--overwrite**  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **input** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **costmap** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of existing raster file with path-cost information  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster  
    **output** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster, *name*  
    **keyval** : int, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Key value  
    **method** : str | list[str], *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Operation to perform on fragments  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *distance, path_distance, area, perimeter, shapeindex*  
    **number** : str | list[str], *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Number of nearest neighbors to analyse  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *num[-num]*  
    **statmethod** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Statistical method to perform on the values  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *average, variance, standard deviation, value, sum*  
    **dmout** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Output name for distance matrix and id-map (performed if not empty)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster  
    **adj_matrix** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Output name for adjacency matrix (performed if not empty)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster  
    **title** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Title for resultant raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *"phrase"*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *a*  
    &nbsp;&nbsp;&nbsp;&nbsp;**a**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Set for 8 cell-neighbors. 4 cell-neighbors are default  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **input** : str | np.ndarray, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **costmap** : str | np.ndarray, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of existing raster file with path-cost information  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster  
    **output** : str | type(np.ndarray) | type(np.array) | type(gs.array.array), *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster, *name*  
    **keyval** : int, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Key value  
    **method** : str | list[str], *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Operation to perform on fragments  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *distance, path_distance, area, perimeter, shapeindex*  
    **number** : str | list[str], *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Number of nearest neighbors to analyse  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *num[-num]*  
    **statmethod** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Statistical method to perform on the values  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *average, variance, standard deviation, value, sum*  
    **dmout** : str | type(np.ndarray) | type(np.array) | type(gs.array.array), *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Output name for distance matrix and id-map (performed if not empty)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster  
    **adj_matrix** : str | type(np.ndarray) | type(np.array) | type(gs.array.array), *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Output name for adjacency matrix (performed if not empty)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster  
    **title** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Title for resultant raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *"phrase"*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *a*  
    &nbsp;&nbsp;&nbsp;&nbsp;**a**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Set for 8 cell-neighbors. 4 cell-neighbors are default  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | np.ndarray | tuple[np.ndarray] | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned. If an array type (e.g., *np.ndarray*) is used for one of the raster outputs, the result will be an array and will have the shape corresponding to the computational region. If an array type is used for more than one raster output, the result will be a tuple of arrays.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

Determine the functional nearest-neighbor distance analysis. *r.pi.fnn*
is a patch based ecological/functional nearest neighbour analysis
module. It computes distance based on a friction map. This module is
related to *r.pi.enn* but more adequate if the ecological connectivity
should be analysed.

## NOTES

The calculation of the ecolgogical nearest neighbour is based on a
raster with start patches. The actual map can be categorical or
continuous but the value defined in *keyval* will be the basis for the
patches to calculate the methods defined below. These patches will also
be in the output map. The calculation of the ecolgogical nearest
neighbour is based on a costmap (\* and 1-infinite) - this map can be
binary or continous - high values are considered to have high cost
issues and the shortest path is the one with the lowest amount of costs.
"null" values can not be traversed, hence these values have to be
bypassed. "0" values are not accepted and will result in "0" distance.

e.g. if a binary map(1 and 2) is used, the the path with the lowest
amount of "1" is chosen The *number* is the amount of nearest neighbours
to be taken and the calculated distances are processed as assigned in
*statmethod* Operations which *r.pi.fnn* can perform are:

- **Distance**  
    The *Distance to Nearest* computes the nearest edge-to-edge distance
    between patches. Counting from the focus patch.
- **path Distance**  
    The *Distance to Nearest* computes the nearest edge-to-edge distance
    between patches. Unlike *Distance* the distance is computed based on
    subsequent NN not from the focus patch onwards. The 1th NN is the
    first patch with the minimal edge-to-edge distance from the focus
    patch, while 2th NN is the patch with the minimal edge-to-edge
    distance from the 1th NN patch and so on.
- **Area**  
    The *Area* computes the size of the nearest edge-to-edge distance
    patch. It is based on *Distance* not on *path Distance*.
- **Perimeter**  
    The *Perimeter* computes the Perimeter of the nearest edge-to-edge
    distance patch. It is based on *Distance* not on *path Distance*.
- **SHAPE**  
    The *SHAPE* computes the SHAPE Index of the nearest edge-to-edge
    distance patch. It is based on *Distance* not on *path Distance*.

The *statsmethod* operators determine calculation is done on the
distance. *Average*, *Variance*,*Stddev* and *value* can be used.

- **Average**  
    The *Average* computes the average value defined in *Operations to
    perform* .
- **Variance**  
    The *Variance* computes the variance defined in *Operations to
    perform* .
- **Stand. Dev.**  
    The *Stand. Dev.* computes the stddev value defined in *Operations
    to perform* .
- **Value**  
    The *patch Distance* computes the nearest edge-to-edge distance
    between two patches. The output of *value* is the actual value. E.g.
    NN==5 of *area* gives the size of the 5th NN while *Average* gives
    the average of the area of 1-5th NN.

The input options are either one NN: *1* or several NN separated by *,*:
1,2,5,8 or a range of NN: 1-6.

Merging these options is possible as well: 1-5,8,9,13,15-19,22 etc.

## EXAMPLE

An example for the North Carolina sample dataset: Computing the
functional or ecological distance to the first to nth nearest
neighrbours using a cost matrix:

```sh
r.mapcalc "cost_raster = if(landclass96==5,1,if(landclass96 == 1, 10, if (landclass96==3,2, if(landclass96==4,1,if(landclass96==6,100)))))"
r.pi.fnn input=landclass96 keyval=5 costmap=cost_raster output=fnn1 method=distance number=10 statmethod=average
```

## SEE ALSO

*[r.pi.enn](r.pi.enn.md), [r.pi.index](r.pi.index.md), [r.pi](r.pi.md)*

## AUTHORS

Programming: Elshad Shirinov  
Scientific concept: Dr. Martin Wegmann  
Department of Remote Sensing  
Remote Sensing and Biodiversity Unit  
University of Wuerzburg, Germany

Port to GRASS GIS 7: Markus Metz

## SOURCE CODE

Available at: [r.pi.fnn source code](https://github.com/OSGeo/grass-addons/tree/grass8/raster/r.pi/r.pi.fnn)
([history](https://github.com/OSGeo/grass-addons/commits/grass8/raster/r.pi/r.pi.fnn))  
Latest change: Sunday Oct 05 18:32:57 2025 in commit [fc9ae68](https://github.com/OSGeo/grass-addons/commit/fc9ae6835e9e88967d0ece26ac89b2c78d91e8db)
