---
name: r.pi.graph.red
description: Graph Theory - decreasing distance threshold option.
keywords: [ raster, landscape structure analysis, connectivity analysis ]
---

# r.pi.graph.red

Graph Theory - decreasing distance threshold option.

=== "Command line"

    **r.pi.graph.red**
    [**-a**]
    **input**=*name*
    **output**=*string*
    **keyval**=*integer*
    **distance**=*float*
    **step**=*float*
    **neighborhood**=*string*
    **index**=*string* [,*string*,...]
    **stats**=*string*
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    r.pi.graph.red input=name output=string keyval=0 distance=0.0 step=0.0 neighborhood=nearest_neighbor index=connectance_index stats=average
    ```

=== "Python (grass.script)"

    *grass.script.run_command*("***r.pi.graph.red***",
        **input**,
        **output**,
        **keyval**,
        **distance**,
        **step**,
        **neighborhood**,
        **index**,
        **stats**,
        **flags**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.run_command("r.pi.graph.red", input="name", output="string", keyval=0, distance=0.0, step=0.0, neighborhood="nearest_neighbor", index="connectance_index", stats="average")
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.r_pi_graph_red*(**input**,
        **output**,
        **keyval**,
        **distance**,
        **step**,
        **neighborhood**,
        **index**,
        **stats**,
        **flags**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.r_pi_graph_red(input="name", output="string", keyval=0, distance=0.0, step=0.0, neighborhood="nearest_neighbor", index="connectance_index", stats="average")
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **input**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input raster map  
    **output**=*string* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of the output ASCII file  
    **keyval**=*integer* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Key value  
    **distance**=*float* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Distance at which to begin decreasing  
    **step**=*float* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Step to decrease the distance  
    **neighborhood**=*string* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Neighborhood definition  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *nearest_neighbor, relative_neighbor, gabriel, spanning_tree*  
    **index**=*string* [,*string*,...] **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Cluster index  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *connectance_index, gyration_radius, cohesion_index, percent_patches, percent_area, number_patches, number_links, mean_patch_size, largest_patch_size, largest_patch_diameter, graph_diameter*  
    **stats**=*string* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Statistical method to perform on the values  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *average, median, variance, std_deviat, min, max*  
    **-a**  
    &nbsp;&nbsp;&nbsp;&nbsp;Set for 8 cell-neighbors. 4 cell-neighbors are default  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **input** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **output** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of the output ASCII file  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output  
    **keyval** : int, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Key value  
    **distance** : float, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Distance at which to begin decreasing  
    **step** : float, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Step to decrease the distance  
    **neighborhood** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Neighborhood definition  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *nearest_neighbor, relative_neighbor, gabriel, spanning_tree*  
    **index** : str | list[str], *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Cluster index  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *connectance_index, gyration_radius, cohesion_index, percent_patches, percent_area, number_patches, number_links, mean_patch_size, largest_patch_size, largest_patch_diameter, graph_diameter*  
    **stats** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Statistical method to perform on the values  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *average, median, variance, std_deviat, min, max*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *a*  
    &nbsp;&nbsp;&nbsp;&nbsp;**a**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Set for 8 cell-neighbors. 4 cell-neighbors are default  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **input** : str | np.ndarray, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **output** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of the output ASCII file  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output  
    **keyval** : int, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Key value  
    **distance** : float, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Distance at which to begin decreasing  
    **step** : float, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Step to decrease the distance  
    **neighborhood** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Neighborhood definition  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *nearest_neighbor, relative_neighbor, gabriel, spanning_tree*  
    **index** : str | list[str], *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Cluster index  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *connectance_index, gyration_radius, cohesion_index, percent_patches, percent_area, number_patches, number_links, mean_patch_size, largest_patch_size, largest_patch_diameter, graph_diameter*  
    **stats** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Statistical method to perform on the values  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *average, median, variance, std_deviat, min, max*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *a*  
    &nbsp;&nbsp;&nbsp;&nbsp;**a**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Set for 8 cell-neighbors. 4 cell-neighbors are default  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

Graph Theory - decreasing distance threshold option.

## NOTES

...

## EXAMPLE

An example for the North Carolina sample dataset:

```sh
g.region -d
...
```

## SEE ALSO

*[r.pi.corearea](r.pi.corearea.md), [r.pi.corr.mw](r.pi.corr.mw.md),
[r.pi.csr.mw](r.pi.csr.mw.md), [r.pi.export](r.pi.export.md),
[r.pi.graph](r.pi.graph.md), [r.pi.graph.dec](r.pi.graph.dec.md),
[r.pi.graph.pr](r.pi.graph.pr.md), [r.pi.grow](r.pi.grow.md),
[r.pi.import](r.pi.import.md), [r.pi.index](r.pi.index.md),
[r.pi.lm](r.pi.lm.md), [r.pi.odc](r.pi.odc.md),
[r.pi.prob.mw](r.pi.prob.mw.md), [r.pi.rectangle](r.pi.rectangle.md),
[r.pi](r.pi.md)*

## AUTHORS

Programming: Elshad Shirinov  
Scientific concept: Dr. Martin Wegmann  
Department of Remote Sensing  
Remote Sensing and Biodiversity Unit  
University of Wuerzburg, Germany

Port to GRASS GIS 7: Markus Metz

## SOURCE CODE

Available at: [r.pi.graph.red source code](https://github.com/OSGeo/grass-addons/tree/grass8/raster/r.pi/r.pi.graph.red)
([history](https://github.com/OSGeo/grass-addons/commits/grass8/raster/r.pi/r.pi.graph.red))  
Latest change: Thursday Feb 20 13:02:26 2025 in commit [53de819](https://github.com/OSGeo/grass-addons/commit/53de8196a10ba5a8a9121898ce87861d227137e3)
