---
name: r.pi.grow
description: Size and suitability based region growing.
keywords: [ raster, landscape structure analysis, region growing ]
---

# r.pi.grow

Size and suitability based region growing.

=== "Command line"

    **r.pi.grow**
    [**-a**]
    **input**=*name*
    [**costmap**=*string*]
    **output**=*name*
    **keyval**=*integer*
    **area**=*integer*
    **method**=*string*
    [**seed**=*integer*]
    [**--overwrite**]
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    r.pi.grow input=name output=name keyval=0 area=0 method=circular
    ```

=== "Python (grass.script)"

    *grass.script.run_command*("***r.pi.grow***",
        **input**,
        **costmap**=*None*,
        **output**,
        **keyval**,
        **area**,
        **method**,
        **seed**=*None*,
        **flags**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.run_command("r.pi.grow", input="name", output="name", keyval=0, area=0, method="circular")
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.r_pi_grow*(**input**,
        **costmap**=*None*,
        **output**,
        **keyval**,
        **area**,
        **method**,
        **seed**=*None*,
        **flags**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.r_pi_grow(input="name", output="name", keyval=0, area=0, method="circular")
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **input**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input raster map  
    **costmap**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of the cost map raster file  
    **output**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output raster map  
    **keyval**=*integer* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Key value  
    **area**=*integer* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Area to grow  
    **method**=*string* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Method of growth  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *circular, random, costbased*  
    **seed**=*integer*  
    &nbsp;&nbsp;&nbsp;&nbsp;Random number generator seed  
    **-a**  
    &nbsp;&nbsp;&nbsp;&nbsp;Set for 8 cell-neighbors. 4 cell-neighbors are default  
    **--overwrite**  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **input** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **costmap** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of the cost map raster file  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster  
    **output** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster, *name*  
    **keyval** : int, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Key value  
    **area** : int, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Area to grow  
    **method** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Method of growth  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *circular, random, costbased*  
    **seed** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Random number generator seed  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *a*  
    &nbsp;&nbsp;&nbsp;&nbsp;**a**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Set for 8 cell-neighbors. 4 cell-neighbors are default  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **input** : str | np.ndarray, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **costmap** : str | np.ndarray, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of the cost map raster file  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster  
    **output** : str | type(np.ndarray) | type(np.array) | type(gs.array.array), *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster, *name*  
    **keyval** : int, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Key value  
    **area** : int, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Area to grow  
    **method** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Method of growth  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *circular, random, costbased*  
    **seed** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Random number generator seed  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *a*  
    &nbsp;&nbsp;&nbsp;&nbsp;**a**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Set for 8 cell-neighbors. 4 cell-neighbors are default  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | np.ndarray | tuple[np.ndarray] | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned. If an array type (e.g., *np.ndarray*) is used for one of the raster outputs, the result will be an array and will have the shape corresponding to the computational region. If an array type is used for more than one raster output, the result will be a tuple of arrays.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

Size and suitability based region growing.

## NOTES

...

## EXAMPLE

An example for the North Carolina sample dataset:

```sh
g.region -d
...
```

## SEE ALSO

*[r.pi.corearea](r.pi.corearea.md), [r.pi.corr.mw](r.pi.corr.mw.md),
[r.pi.csr.mw](r.pi.csr.mw.md), [r.pi.export](r.pi.export.md),
[r.pi.graph](r.pi.graph.md), [r.pi.graph.dec](r.pi.graph.dec.md),
[r.pi.graph.pr](r.pi.graph.pr.md), [r.pi.graph.red](r.pi.graph.red.md),
[r.pi.import](r.pi.import.md), [r.pi.index](r.pi.index.md),
[r.pi.lm](r.pi.lm.md), [r.pi.odc](r.pi.odc.md),
[r.pi.prob.mw](r.pi.prob.mw.md), [r.pi.rectangle](r.pi.rectangle.md),
[r.pi](r.pi.md)*

## AUTHORS

Programming: Elshad Shirinov  
Scientific concept: Dr. Martin Wegmann  
Department of Remote Sensing  
Remote Sensing and Biodiversity Unit  
University of Wuerzburg, Germany

Port to GRASS GIS 7: Markus Metz

## SOURCE CODE

Available at: [r.pi.grow source code](https://github.com/OSGeo/grass-addons/tree/grass8/raster/r.pi/r.pi.grow)
([history](https://github.com/OSGeo/grass-addons/commits/grass8/raster/r.pi/r.pi.grow))  
Latest change: Thursday Feb 20 13:02:26 2025 in commit [53de819](https://github.com/OSGeo/grass-addons/commit/53de8196a10ba5a8a9121898ce87861d227137e3)
