---
name: r.pi.odc
description: Omnidirectional connectivity analysis
keywords: [ raster, landscape structure analysis, connectivity analysis ]
---

# r.pi.odc

Omnidirectional connectivity analysis

=== "Command line"

    **r.pi.odc**
    [**-abdm**]
    **input**=*name*
    **output**=*name*
    [**mask**=*string*]
    **keyval**=*integer*
    **ratio**=*string*
    **stats**=*string* [,*string*,...]
    [**neighbor_level**=*integer*]
    [**title**=*"phrase"*]
    [**--overwrite**]
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    r.pi.odc input=name output=name keyval=0 ratio=none stats=average
    ```

=== "Python (grass.script)"

    *grass.script.run_command*("***r.pi.odc***",
        **input**,
        **output**,
        **mask**=*None*,
        **keyval**,
        **ratio**,
        **stats**,
        **neighbor_level**=*None*,
        **title**=*None*,
        **flags**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.run_command("r.pi.odc", input="name", output="name", keyval=0, ratio="none", stats="average")
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.r_pi_odc*(**input**,
        **output**,
        **mask**=*None*,
        **keyval**,
        **ratio**,
        **stats**,
        **neighbor_level**=*None*,
        **title**=*None*,
        **flags**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.r_pi_odc(input="name", output="name", keyval=0, ratio="none", stats="average")
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **input**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input raster map  
    **output**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output raster map  
    **mask**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of a raster file with a mask (0,1 values)  
    **keyval**=*integer* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Category value of the patches  
    **ratio**=*string* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Compensation method to perform on the values  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *none, odd_area, area_odd, odd_perim, perim_odd*  
    **stats**=*string* [,*string*,...] **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Statistical method to perform on the values  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *average, variance, standard deviation, median*  
    **neighbor_level**=*integer*  
    &nbsp;&nbsp;&nbsp;&nbsp;Level of neighbors to analyse  
    **title**=*"phrase"*  
    &nbsp;&nbsp;&nbsp;&nbsp;Title for resultant raster map  
    **-a**  
    &nbsp;&nbsp;&nbsp;&nbsp;Set for 8 cell-neighbors. 4 cell-neighbors are default  
    **-b**  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow moving on diagonals  
    **-d**  
    &nbsp;&nbsp;&nbsp;&nbsp;Graphical output  
    **-m**  
    &nbsp;&nbsp;&nbsp;&nbsp;Adjacency matrix output  
    **--overwrite**  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **input** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **output** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster, *name*  
    **mask** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of a raster file with a mask (0,1 values)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster  
    **keyval** : int, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Category value of the patches  
    **ratio** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Compensation method to perform on the values  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *none, odd_area, area_odd, odd_perim, perim_odd*  
    **stats** : str | list[str], *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Statistical method to perform on the values  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *average, variance, standard deviation, median*  
    **neighbor_level** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Level of neighbors to analyse  
    **title** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Title for resultant raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *"phrase"*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *a*, *b*, *d*, *m*  
    &nbsp;&nbsp;&nbsp;&nbsp;**a**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Set for 8 cell-neighbors. 4 cell-neighbors are default  
    &nbsp;&nbsp;&nbsp;&nbsp;**b**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Allow moving on diagonals  
    &nbsp;&nbsp;&nbsp;&nbsp;**d**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Graphical output  
    &nbsp;&nbsp;&nbsp;&nbsp;**m**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Adjacency matrix output  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **input** : str | np.ndarray, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **output** : str | type(np.ndarray) | type(np.array) | type(gs.array.array), *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster, *name*  
    **mask** : str | np.ndarray, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of a raster file with a mask (0,1 values)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster  
    **keyval** : int, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Category value of the patches  
    **ratio** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Compensation method to perform on the values  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *none, odd_area, area_odd, odd_perim, perim_odd*  
    **stats** : str | list[str], *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Statistical method to perform on the values  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *average, variance, standard deviation, median*  
    **neighbor_level** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Level of neighbors to analyse  
    **title** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Title for resultant raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *"phrase"*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *a*, *b*, *d*, *m*  
    &nbsp;&nbsp;&nbsp;&nbsp;**a**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Set for 8 cell-neighbors. 4 cell-neighbors are default  
    &nbsp;&nbsp;&nbsp;&nbsp;**b**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Allow moving on diagonals  
    &nbsp;&nbsp;&nbsp;&nbsp;**d**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Graphical output  
    &nbsp;&nbsp;&nbsp;&nbsp;**m**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Adjacency matrix output  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | np.ndarray | tuple[np.ndarray] | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned. If an array type (e.g., *np.ndarray*) is used for one of the raster outputs, the result will be an array and will have the shape corresponding to the computational region. If an array type is used for more than one raster output, the result will be a tuple of arrays.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

*r.pi.odc* is part of the patch based fragmentation analysis package
r.pi.\* (Patch Index). It computes omnidirectional connectivity analysis
between patches.

## NOTES

Several output raster are generated with the defined *output* file name
and a suffix of the information provided. All files named \*.FP.\* are
providing information concerning the focus patch. All files named
\*.TP.\* are providing informaton about the target patches.  
...

The user must specify the names of the raster map layers to be used for
*input* and *output*, the *keyval* the *ratio* (area/odd or odd/area)
and *stats* used (i.e., average).

Within *r.pi.odc* the following setting have to be set:

### keyval setting

The *keyval* operator determines which category value is taken for the
Patch Index analysis.

### Ratio setting

The *ratio* operators determine what measure is applied.

### Neighbourhood level

The *neighbor\_level* operator determines which neighbourhood level is
used. *0* produces output for the focus patch itself, *1* assigns the
connectivity information of the first omnidirectional neighbours to the
focus patch, hence the connectivity of the surrouding fragments. This
value can be increased for analysing the more distant neighbours.

### Output

Various output files are autmatically created with the pattern
$output.\* The ... *FP* describes attributes of the fokus patch (area
and area of the odd) *TP* describes attributes of the target patch (all
neighbouring patches around the FP) - separated by the statsmethod
(average, median, variance, stddev) *ratio* describes which ratio is
taken for all TPs. The output raster files are named accordingly:  
\*.FP.area: size of the patch  
\*.FP.odd: size of the isolation area  
\*.FP.odd\_area: ratio of size of patch and size of isolaton area  
\*.TP.no: amount of neighbouring patches  
\*.TP.area.avg: average size of all neighbouring patches  
\*.TP.odd.avg: average size of all isolation areas of neighbouring
patches  
\*.TP.odd\_area.avg: average ratio of isolation area to patch size  
\*.diagram: (if flag -d active) isolation areas and border are depicted

## EXAMPLE

An example for the North Carolina sample dataset:

```sh
r.pi.odc input=landclass96 output=odc keyval=5 ratio=odd_area stats=average neighbor_level=0 -d
```

## SEE ALSO

*[r.pi.fnn](r.pi.fnn.md), [r.pi.enn](r.pi.enn.md),
[r.pi.graph](r.pi.graph.md), [r.pi.index](r.pi.index.md),
[r.pi](r.pi.md)*

## AUTHORS

Programming: Elshad Shirinov  
Scientific concept: Dr. Martin Wegmann  
Department of Remote Sensing  
Remote Sensing and Biodiversity Unit  
University of Wuerzburg, Germany

Port to GRASS GIS 7: Markus Metz

## SOURCE CODE

Available at: [r.pi.odc source code](https://github.com/OSGeo/grass-addons/tree/grass8/raster/r.pi/r.pi.odc)
([history](https://github.com/OSGeo/grass-addons/commits/grass8/raster/r.pi/r.pi.odc))  
Latest change: Friday Feb 21 12:27:42 2025 in commit [8fce680](https://github.com/OSGeo/grass-addons/commit/8fce680a2170ee81eff27fdf4315079b10a10f83)
