---
name: r.random.walk.py
description: Performs a 2D random walk inside the computational region and returns the resulting walk.
keywords: [ raster, random, walk, surface, parallel ]
---

# r.random.walk.py

Performs a 2D random walk inside the computational region and returns the resulting walk.

=== "Command line"

    **r.random.walk.py**
    [**-ast**]
    **output**=*name*
    [**steps**=*integer*]
    [**directions**=*string*]
    [**memory**=*memory in MB*]
    [**seed**=*integer*]
    [**nprocs**=*integer*]
    [**nwalkers**=*integer*]
    [**--overwrite**]
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    r.random.walk.py output=name
    ```

=== "Python (grass.script)"

    *grass.script.run_command*("***r.random.walk.py***",
        **output**,
        **steps**=*100000*,
        **directions**=*"4"*,
        **memory**=*300*,
        **seed**=*None*,
        **nprocs**=*0*,
        **nwalkers**=*1*,
        **flags**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.run_command("r.random.walk.py", output="name")
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.r_random_walk_py*(**output**,
        **steps**=*100000*,
        **directions**=*"4"*,
        **memory**=*300*,
        **seed**=*None*,
        **nprocs**=*0*,
        **nwalkers**=*1*,
        **flags**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.r_random_walk_py(output="name")
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **output**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output raster map  
    **steps**=*integer*  
    &nbsp;&nbsp;&nbsp;&nbsp;How many steps to take during walk.  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *100000*  
    **directions**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;How many directions should be used during walk.  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *4,  8*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *4*  
    **memory**=*memory in MB*  
    &nbsp;&nbsp;&nbsp;&nbsp;Maximum memory to be used (in MB)  
    &nbsp;&nbsp;&nbsp;&nbsp;Cache size for raster rows  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *300*  
    **seed**=*integer*  
    &nbsp;&nbsp;&nbsp;&nbsp;Seed for random number generator  
    **nprocs**=*integer*  
    &nbsp;&nbsp;&nbsp;&nbsp;Number of threads for parallel computing  
    &nbsp;&nbsp;&nbsp;&nbsp;0: use OpenMP default; &gt;0: use nprocs; &lt;0: use MAX-nprocs  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0*  
    **nwalkers**=*integer*  
    &nbsp;&nbsp;&nbsp;&nbsp;Number of walkers.  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1*  
    **-a**  
    &nbsp;&nbsp;&nbsp;&nbsp;Perform a self-avoiding random walk  
    **-s**  
    &nbsp;&nbsp;&nbsp;&nbsp;Generate random seed (result is non-deterministic).  
    **-t**  
    &nbsp;&nbsp;&nbsp;&nbsp;Each walker starts from the same point.  
    **--overwrite**  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **output** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster, *name*  
    **steps** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;How many steps to take during walk.  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *100000*  
    **directions** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;How many directions should be used during walk.  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *4,  8*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *4*  
    **memory** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Maximum memory to be used (in MB)  
    &nbsp;&nbsp;&nbsp;&nbsp;Cache size for raster rows  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *memory in MB*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *300*  
    **seed** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Seed for random number generator  
    **nprocs** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Number of threads for parallel computing  
    &nbsp;&nbsp;&nbsp;&nbsp;0: use OpenMP default; &gt;0: use nprocs; &lt;0: use MAX-nprocs  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0*  
    **nwalkers** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Number of walkers.  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *a*, *s*, *t*  
    &nbsp;&nbsp;&nbsp;&nbsp;**a**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Perform a self-avoiding random walk  
    &nbsp;&nbsp;&nbsp;&nbsp;**s**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Generate random seed (result is non-deterministic).  
    &nbsp;&nbsp;&nbsp;&nbsp;**t**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Each walker starts from the same point.  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **output** : str | type(np.ndarray) | type(np.array) | type(gs.array.array), *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster, *name*  
    **steps** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;How many steps to take during walk.  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *100000*  
    **directions** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;How many directions should be used during walk.  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *4,  8*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *4*  
    **memory** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Maximum memory to be used (in MB)  
    &nbsp;&nbsp;&nbsp;&nbsp;Cache size for raster rows  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *memory in MB*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *300*  
    **seed** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Seed for random number generator  
    **nprocs** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Number of threads for parallel computing  
    &nbsp;&nbsp;&nbsp;&nbsp;0: use OpenMP default; &gt;0: use nprocs; &lt;0: use MAX-nprocs  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0*  
    **nwalkers** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Number of walkers.  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *a*, *s*, *t*  
    &nbsp;&nbsp;&nbsp;&nbsp;**a**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Perform a self-avoiding random walk  
    &nbsp;&nbsp;&nbsp;&nbsp;**s**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Generate random seed (result is non-deterministic).  
    &nbsp;&nbsp;&nbsp;&nbsp;**t**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Each walker starts from the same point.  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | np.ndarray | tuple[np.ndarray] | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned. If an array type (e.g., *np.ndarray*) is used for one of the raster outputs, the result will be an array and will have the shape corresponding to the computational region. If an array type is used for more than one raster output, the result will be a tuple of arrays.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

The *r.random.walk* module generates a 2D random walk across the current
computational region. The module provides control of the number of steps
and directions (4 or 8) a walker can take and allows the walker's
behavior to be set to be self-avoiding (Madras et al., 1996) or allow
revisits. The output displays the frequency the walker visited each cell
or the average frequency. The module can run multiple walks in parallel.
It either samples the same starting location for each walk or generates
a unique starting position for each walker.

## EXAMPLE

Using the North Carolina full sample dataset:

```sh
# set computational region
g.region raster=elevation -p

# calculate smoothed random walk from a single starting locations.
r.random.walk -at output=random_walk_smooth_paths directions=8 steps=100000 memory=1800 seed=1 nprocs=6 nwalkers=100
```

![image-alt](r_random_walk_example.png)  
Smoothed random walk (Single Starting Location)

```sh
# calculate smoothed random walk from a multiple starting locations.
r.random.walk -as output=random_walk_smooth directions=8 steps=100000 memory=1800 nprocs=6 nwalkers=100
```

![image-alt](r_random_walk_example_2.png)  
Smoothed random walk (Multiple Starting Locations)

## SEE ALSO

[r.surf.fractal](https://grass.osgeo.org/grass-stable/manuals/r.surf.fractal.html),
[r.surf.random](https://grass.osgeo.org/grass-stable/manuals/r.surf.random.html)

## AUTHOR

Corey T. White, [NCSU GeoForAll
Lab](https://geospatial.ncsu.edu/geoforall/)

## SOURCE CODE

Available at: [r.random.walk source code](https://github.com/OSGeo/grass-addons/tree/grass8/src/raster/r.random.walk)
([history](https://github.com/OSGeo/grass-addons/commits/grass8/src/raster/r.random.walk))  
Latest change: Thursday Feb 20 13:02:26 2025 in commit [53de819](https://github.com/OSGeo/grass-addons/commit/53de8196a10ba5a8a9121898ce87861d227137e3)
