---
name: r.resamp.stats
description: Resamples raster map layers to a coarser grid using aggregation.
keywords: [ raster, resample, univariate statistics, aggregation ]
---

# r.resamp.stats

Resamples raster map layers to a coarser grid using aggregation.

=== "Command line"

    **r.resamp.stats**
    [**-nw**]
    **input**=*name*
    **output**=*name*
    [**method**=*string*]
    [**quantile**=*float*]
    [**--overwrite**]
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    r.resamp.stats input=name output=name
    ```

=== "Python (grass.script)"

    *grass.script.run_command*("***r.resamp.stats***",
        **input**,
        **output**,
        **method**=*"average"*,
        **quantile**=*0.5*,
        **flags**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.run_command("r.resamp.stats", input="name", output="name")
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.r_resamp_stats*(**input**,
        **output**,
        **method**=*"average"*,
        **quantile**=*0.5*,
        **flags**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.r_resamp_stats(input="name", output="name")
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **input**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input raster map  
    **output**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output raster map  
    **method**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Aggregation method  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *average, median, mode, minimum, maximum, range, quart1, quart3, perc90, sum, variance, stddev, quantile, count, diversity*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *average*  
    **quantile**=*float*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quantile to calculate for method=quantile  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *0.0-1.0*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0.5*  
    **-n**  
    &nbsp;&nbsp;&nbsp;&nbsp;Propagate NULLs  
    **-w**  
    &nbsp;&nbsp;&nbsp;&nbsp;Weight according to area (slower)  
    **--overwrite**  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **input** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **output** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster, *name*  
    **method** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Aggregation method  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *average, median, mode, minimum, maximum, range, quart1, quart3, perc90, sum, variance, stddev, quantile, count, diversity*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *average*  
    **quantile** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quantile to calculate for method=quantile  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *0.0-1.0*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0.5*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *n*, *w*  
    &nbsp;&nbsp;&nbsp;&nbsp;**n**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Propagate NULLs  
    &nbsp;&nbsp;&nbsp;&nbsp;**w**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Weight according to area (slower)  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **input** : str | np.ndarray, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **output** : str | type(np.ndarray) | type(np.array) | type(gs.array.array), *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster, *name*  
    **method** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Aggregation method  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *average, median, mode, minimum, maximum, range, quart1, quart3, perc90, sum, variance, stddev, quantile, count, diversity*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *average*  
    **quantile** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quantile to calculate for method=quantile  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *0.0-1.0*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0.5*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *n*, *w*  
    &nbsp;&nbsp;&nbsp;&nbsp;**n**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Propagate NULLs  
    &nbsp;&nbsp;&nbsp;&nbsp;**w**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Weight according to area (slower)  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | np.ndarray | tuple[np.ndarray] | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned. If an array type (e.g., *np.ndarray*) is used for one of the raster outputs, the result will be an array and will have the shape corresponding to the computational region. If an array type is used for more than one raster output, the result will be a tuple of arrays.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

*r.resamp.stats* fills a grid cell (raster) matrix with aggregated
values generated from a set of input layer data points.

Without the *-w* switch, the aggregate is computed over all of the input
cells whose centers lie within the output cell.

With the *-w* switch, the aggregate uses the values from all input cells
which intersect the output cell, weighted according to the proportion of
the source cell which lies inside the output cell. This is slower, but
produces a more accurate result.

## NOTES

Resampling modules (*r.resample, r.resamp.stats, r.resamp.interp,
r.resamp.rst*) resample the map to match the current region settings.

The notion of weighting doesn't make any sense for the min and max
aggregates. However, the *-w* flag still has significance in that, when
multiple destination cells overlap a source cell, the source cell is
included in the calculation of all of the destination cells.

## EXAMPLE

Resample elevation raster map to a lower resolution (from 6m to 20m;
North Carolina sample dataset):

```sh
g.region raster=el_D782_6m -p
g.region res=20 -ap
# from 6m to 20m: weighted resampling -w
r.resamp.stats -w input=el_D782_6m output=el_D782_20m
```

![GRASS r.resamp.stats result (subset)](r_resamp_stats_6m_20m.png)  
*Resampling of 6m DEM (left) to 20m DEM (right) with weighted resampling
(subset)*

## SEE ALSO

*[g.region](g.region.md), [r.resample](r.resample.md),
[r.resamp.rst](r.resamp.rst.md), [r.resamp.filter](r.resamp.filter.md),
[r.resamp.interp](r.resamp.interp.md), [r.neighbors](r.neighbors.md)*

Overview: [Interpolation and
Resampling](https://grasswiki.osgeo.org/wiki/Interpolation) in GRASS

Examples how statistical functions are applied can be found in the
[r.neighbors](r.neighbors.md) module documentation.

## AUTHOR

Glynn Clements

## SOURCE CODE

Available at: [r.resamp.stats source code](https://github.com/OSGeo/grass/tree/main/raster/r.resamp.stats)
([history](https://github.com/OSGeo/grass/commits/main/raster/r.resamp.stats))  
Latest change: Friday Aug 08 09:39:19 2025 in commit [ed72c71](https://github.com/OSGeo/grass/commit/ed72c71d8580e872cd6fd345c84a15c324764465)
