---
name: r.series.boxplot.py
description: Draws the boxplot of raster values of a series of input rasters.
keywords: [ display, raster, plot, boxplot, statistics ]
---

# r.series.boxplot.py

Draws the boxplot of raster values of a series of input rasters.

=== "Command line"

    **r.series.boxplot.py**
    [**-onhg**]
    **map**=*name* [,*name*,...]
    [**output**=*file name*]
    [**plot_dimensions**=*string*]
    [**dpi**=*integer*]
    [**range**=*float*]
    [**text_labels**=*string*]
    [**rotate_labels**=*float*]
    [**boxplot_width**=*float*]
    [**bxcolor**=*name*]
    [**fontsize**=*integer*]
    [**flier_marker**=*string*]
    [**flier_size**=*string*]
    [**flier_color**=*name*]
    [**--overwrite**]
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    r.series.boxplot.py map=name
    ```

=== "Python (grass.script)"

    *grass.script.run_command*("***r.series.boxplot.py***",
        **map**,
        **output**=*None*,
        **plot_dimensions**=*None*,
        **dpi**=*None*,
        **range**=*1.5*,
        **text_labels**=*None*,
        **rotate_labels**=*None*,
        **boxplot_width**=*None*,
        **bxcolor**=*"black"*,
        **fontsize**=*None*,
        **flier_marker**=*None*,
        **flier_size**=*None*,
        **flier_color**=*"black"*,
        **flags**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.run_command("r.series.boxplot.py", map="name")
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.r_series_boxplot_py*(**map**,
        **output**=*None*,
        **plot_dimensions**=*None*,
        **dpi**=*None*,
        **range**=*1.5*,
        **text_labels**=*None*,
        **rotate_labels**=*None*,
        **boxplot_width**=*None*,
        **bxcolor**=*"black"*,
        **fontsize**=*None*,
        **flier_marker**=*None*,
        **flier_size**=*None*,
        **flier_color**=*"black"*,
        **flags**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.r_series_boxplot_py(map="name")
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **map**=*name* [,*name*,...] **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;input raster  
    **output**=*file name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of output image file  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output file  
    **plot_dimensions**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Plot dimensions (width,height)  
    &nbsp;&nbsp;&nbsp;&nbsp;Dimensions (width,height) of the figure in inches  
    **dpi**=*integer*  
    &nbsp;&nbsp;&nbsp;&nbsp;DPI  
    &nbsp;&nbsp;&nbsp;&nbsp;Set the resolution of plot  
    **range**=*float*  
    &nbsp;&nbsp;&nbsp;&nbsp;Range (value &gt; 0)  
    &nbsp;&nbsp;&nbsp;&nbsp;This determines how far the plot whiskers extend out from the box. If range is positive, the whiskers extend to the most extreme data point which is no more than range times the interquartile range from the box. A value of zero causes the whiskers to extend to the data extremes.  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1.5*  
    **text_labels**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Boxplot text labels  
    &nbsp;&nbsp;&nbsp;&nbsp;Give labels of the boxplots (comma separated). If you leave this empty, the raster layer names will be used as labels.  
    **rotate_labels**=*float*  
    &nbsp;&nbsp;&nbsp;&nbsp;Rotate labels (degrees)  
    &nbsp;&nbsp;&nbsp;&nbsp;Rotate labels (degrees)  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *-90-90*  
    **boxplot_width**=*float*  
    &nbsp;&nbsp;&nbsp;&nbsp;Set boxplot width  
    &nbsp;&nbsp;&nbsp;&nbsp;The width of the boxplots (0,1])  
    **bxcolor**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Boxplot color  
    &nbsp;&nbsp;&nbsp;&nbsp;Color of the boxplots. See manual page for color notation options.  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *black*  
    **fontsize**=*integer*  
    &nbsp;&nbsp;&nbsp;&nbsp;Font size  
    &nbsp;&nbsp;&nbsp;&nbsp;Default font size  
    **flier_marker**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Flier marker  
    &nbsp;&nbsp;&nbsp;&nbsp;Set flier marker (see https://matplotlib.org/stable/api/markers_api.html for options)  
    **flier_size**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Flier size  
    &nbsp;&nbsp;&nbsp;&nbsp;Set flier size  
    **flier_color**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Flier color  
    &nbsp;&nbsp;&nbsp;&nbsp;Set flier color  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *black*  
    **-o**  
    &nbsp;&nbsp;&nbsp;&nbsp;Include outliers  
    &nbsp;&nbsp;&nbsp;&nbsp;Draw boxplot(s) with outliers  
    **-n**  
    &nbsp;&nbsp;&nbsp;&nbsp;Draw the notch  
    &nbsp;&nbsp;&nbsp;&nbsp;Draw boxplot(s) with notch  
    **-h**  
    &nbsp;&nbsp;&nbsp;&nbsp;Horizontal boxplot(s)  
    &nbsp;&nbsp;&nbsp;&nbsp;Draw the boxplot horizontal  
    **-g**  
    &nbsp;&nbsp;&nbsp;&nbsp;grid lines  
    &nbsp;&nbsp;&nbsp;&nbsp;add grid lines  
    **--overwrite**  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **map** : str | list[str], *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;input raster  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **output** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of output image file  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output file  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, file, *file name*  
    **plot_dimensions** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Plot dimensions (width,height)  
    &nbsp;&nbsp;&nbsp;&nbsp;Dimensions (width,height) of the figure in inches  
    **dpi** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;DPI  
    &nbsp;&nbsp;&nbsp;&nbsp;Set the resolution of plot  
    **range** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Range (value &gt; 0)  
    &nbsp;&nbsp;&nbsp;&nbsp;This determines how far the plot whiskers extend out from the box. If range is positive, the whiskers extend to the most extreme data point which is no more than range times the interquartile range from the box. A value of zero causes the whiskers to extend to the data extremes.  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1.5*  
    **text_labels** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Boxplot text labels  
    &nbsp;&nbsp;&nbsp;&nbsp;Give labels of the boxplots (comma separated). If you leave this empty, the raster layer names will be used as labels.  
    **rotate_labels** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Rotate labels (degrees)  
    &nbsp;&nbsp;&nbsp;&nbsp;Rotate labels (degrees)  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *-90-90*  
    **boxplot_width** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Set boxplot width  
    &nbsp;&nbsp;&nbsp;&nbsp;The width of the boxplots (0,1])  
    **bxcolor** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Boxplot color  
    &nbsp;&nbsp;&nbsp;&nbsp;Color of the boxplots. See manual page for color notation options.  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, color, *name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *black*  
    **fontsize** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Font size  
    &nbsp;&nbsp;&nbsp;&nbsp;Default font size  
    **flier_marker** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Flier marker  
    &nbsp;&nbsp;&nbsp;&nbsp;Set flier marker (see https://matplotlib.org/stable/api/markers_api.html for options)  
    **flier_size** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Flier size  
    &nbsp;&nbsp;&nbsp;&nbsp;Set flier size  
    **flier_color** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Flier color  
    &nbsp;&nbsp;&nbsp;&nbsp;Set flier color  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, color, *name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *black*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *o*, *n*, *h*, *g*  
    &nbsp;&nbsp;&nbsp;&nbsp;**o**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Include outliers  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Draw boxplot(s) with outliers  
    &nbsp;&nbsp;&nbsp;&nbsp;**n**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Draw the notch  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Draw boxplot(s) with notch  
    &nbsp;&nbsp;&nbsp;&nbsp;**h**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Horizontal boxplot(s)  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Draw the boxplot horizontal  
    &nbsp;&nbsp;&nbsp;&nbsp;**g**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;grid lines  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;add grid lines  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **map** : str | list[str], *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;input raster  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **output** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of output image file  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output file  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, file, *file name*  
    **plot_dimensions** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Plot dimensions (width,height)  
    &nbsp;&nbsp;&nbsp;&nbsp;Dimensions (width,height) of the figure in inches  
    **dpi** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;DPI  
    &nbsp;&nbsp;&nbsp;&nbsp;Set the resolution of plot  
    **range** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Range (value &gt; 0)  
    &nbsp;&nbsp;&nbsp;&nbsp;This determines how far the plot whiskers extend out from the box. If range is positive, the whiskers extend to the most extreme data point which is no more than range times the interquartile range from the box. A value of zero causes the whiskers to extend to the data extremes.  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1.5*  
    **text_labels** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Boxplot text labels  
    &nbsp;&nbsp;&nbsp;&nbsp;Give labels of the boxplots (comma separated). If you leave this empty, the raster layer names will be used as labels.  
    **rotate_labels** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Rotate labels (degrees)  
    &nbsp;&nbsp;&nbsp;&nbsp;Rotate labels (degrees)  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *-90-90*  
    **boxplot_width** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Set boxplot width  
    &nbsp;&nbsp;&nbsp;&nbsp;The width of the boxplots (0,1])  
    **bxcolor** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Boxplot color  
    &nbsp;&nbsp;&nbsp;&nbsp;Color of the boxplots. See manual page for color notation options.  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, color, *name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *black*  
    **fontsize** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Font size  
    &nbsp;&nbsp;&nbsp;&nbsp;Default font size  
    **flier_marker** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Flier marker  
    &nbsp;&nbsp;&nbsp;&nbsp;Set flier marker (see https://matplotlib.org/stable/api/markers_api.html for options)  
    **flier_size** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Flier size  
    &nbsp;&nbsp;&nbsp;&nbsp;Set flier size  
    **flier_color** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Flier color  
    &nbsp;&nbsp;&nbsp;&nbsp;Set flier color  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, color, *name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *black*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *o*, *n*, *h*, *g*  
    &nbsp;&nbsp;&nbsp;&nbsp;**o**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Include outliers  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Draw boxplot(s) with outliers  
    &nbsp;&nbsp;&nbsp;&nbsp;**n**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Draw the notch  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Draw boxplot(s) with notch  
    &nbsp;&nbsp;&nbsp;&nbsp;**h**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Horizontal boxplot(s)  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Draw the boxplot horizontal  
    &nbsp;&nbsp;&nbsp;&nbsp;**g**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;grid lines  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;add grid lines  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

*r.seriesboxplot* draws boxplots of series of input raster layers. It
can be used to display both temporal patterns and spatial variation.

The whiskers of the boxplots extend to the most extreme data point,
which is no more than **range** ✕ the interquartile range (iqr) from the
box. By default, a **range** of 1.5 is used, but the user can change
this. Note that range values need to be larger than 0. By default,
outliers are not included in the plot. Set the -o flag to include them
in the plot.

There are a few layout options, including the option to rotate the plot
and the x-axis labels, print the boxplot(s) with notches, and define the
color of the boxplots.

By default, the raster names are used as labels, but the user can
explicitly define the labels (example 3 below). The number of labels
need to be the same as the number of input raster layers.

By default, the resulting plot is displayed on screen. However, the user
can also save the plot to file using the **output** option. The format
is determined by the extension given by the user. So, if **output =
outputfile.png**, the plot will be saved as a PNG file. The user can set
the output size (in inches) and resolution (dpi) of the output image.

## NOTE

If you work with a large number of raster layers, of if the raster
layers are very large, try to avoid setting the range value very low, as
that may result in a massive number of outliers, slowing down the
computations and rendering of the plot.

## EXAMPLE

The examples use the North Carolina full dataset, which you can download
from
[https://grass.osgeo.org/download/data/#NorthCarolinaDataset](https://grass.osgeo.org/download/data/#NorthCarolinaDataset).

### Example 1

Three landsat layers are provided as input. In addition, plot dimensions
are set to 12 inch wide, 6 inch height.

```sh
r.series.boxplot plot_dimensions=12,6 \
map=lsat7_2002_10,lsat7_2002_20,lsat7_2002_30,lsat7_2002_40,lsat7_2002_50
```

![image-alt](r_series_boxplot_1.png)

### Example 2

The example below uses the same layers as input. In addition, it defines
the colors for the boxplots, rotates the labels and sets the fontsize to
14.

```sh
r.series.boxplot plot_dimensions=12,6 \
map=lsat7_2002_10,lsat7_2002_20,lsat7_2002_30,lsat7_2002_40,lsat7_2002_50 \
bxcolor=green rotate_labels=45 fontsize=14
```

See [(https://matplotlib.org/stable/tutorials/colors/colors.html](https://matplotlib.org/stable/tutorials/colors/colors.html)
for the different formats in which colors can be specified.

![image-alt](r_series_boxplot_2.png)

### Example 3

Same example as above, but this time, the outliers are plotted as well
(in blue). And the labels are explicitly defined.

```sh
r.series.boxplot -o plot_dimensions=12,6 rotate_labels=45 fontsize=14 \
map=lsat7_2002_10,lsat7_2002_20,lsat7_2002_30,lsat7_2002_40,lsat7_2002_50 \
flier_color=blue bxcolor=green \
text_labels="2002 10,2002 20,2002 30,2002 40,2002 50"
```

![image-alt](r_series_boxplot_3.png)

## Acknowledgements

This work was carried in the framework of the [Save the tiger, save the
grassland, save the water](https://savethetiger.nl/) project by the
[Innovative Bio-Monitoring research
group](https://www.has.nl/en/has-research/research-groups/innovative-bio-monitoring-research-group)
of the HAS University of Applied Sciences.

## SEE ALSO

*[r.boxplot](https://grass.osgeo.org/grass-stable/manuals/addons/r.boxplot.html),
[d.vect.colbp](https://grass.osgeo.org/grass-stable/manuals/addons/d.vect.colbp.html),
[r.scatterplot](https://grass.osgeo.org/grass-stable/manuals/addons/r.scatterplot.html),
[r.stats.zonal](https://grass.osgeo.org/grass-stable/manuals/r.stats.zonal.html)*

## AUTHOR

Paulo van Breugel  
Applied Geo-information Sciences  
[HAS University of Applied Sciences](https://www.hasuniversity.nl/)

## SOURCE CODE

Available at: [r.series.boxplot source code](https://github.com/OSGeo/grass-addons/tree/grass8/src/raster/r.series.boxplot)
([history](https://github.com/OSGeo/grass-addons/commits/grass8/src/raster/r.series.boxplot))  
Latest change: Thursday May 29 11:23:19 2025 in commit [701c59b](https://github.com/OSGeo/grass-addons/commit/701c59b932c6a12e06ba3a4135cab5955cd9047a)
