---
name: r.shaded.pca.py
description: Creates relief shades from various directions and combines them into RGB composition. The combined shades highlight terrain features which wouldn't be visible using standard shading technique.
keywords: [ raster, elevation, terrain, visualization, parallel ]
---

# r.shaded.pca.py

Creates relief shades from various directions and combines them into RGB composition.

The combined shades highlight terrain features which wouldn't be visible using standard shading technique.

=== "Command line"

    **r.shaded.pca.py**
    **input**=*string*
    **output**=*string*
    [**altitude**=*float*]
    [**nazimuths**=*integer*]
    [**zscale**=*float*]
    [**scale**=*float*]
    [**units**=*string*]
    [**shades_basename**=*string*]
    [**pca_shades_basename**=*string*]
    [**nprocs**=*integer*]
    [**--overwrite**]
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    r.shaded.pca.py input=string output=string
    ```

=== "Python (grass.script)"

    *grass.script.run_command*("***r.shaded.pca.py***",
        **input**,
        **output**,
        **altitude**=*30*,
        **nazimuths**=*8*,
        **zscale**=*1*,
        **scale**=*1*,
        **units**=*None*,
        **shades_basename**=*None*,
        **pca_shades_basename**=*None*,
        **nprocs**=*1*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.run_command("r.shaded.pca.py", input="string", output="string")
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.r_shaded_pca_py*(**input**,
        **output**,
        **altitude**=*30*,
        **nazimuths**=*8*,
        **zscale**=*1*,
        **scale**=*1*,
        **units**=*None*,
        **shades_basename**=*None*,
        **pca_shades_basename**=*None*,
        **nprocs**=*1*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.r_shaded_pca_py(input="string", output="string")
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **input**=*string* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of the input elevation raster map  
    **output**=*string* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output PCA shaded relief map  
    **altitude**=*float*  
    &nbsp;&nbsp;&nbsp;&nbsp;Altitude of the sun in degrees above the horizon  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *0-90*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *30*  
    **nazimuths**=*integer*  
    &nbsp;&nbsp;&nbsp;&nbsp;The number of azimuths (suggested values are 4, 8, 16, 32)  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *8*  
    **zscale**=*float*  
    &nbsp;&nbsp;&nbsp;&nbsp;Factor for exaggerating relief  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1*  
    **scale**=*float*  
    &nbsp;&nbsp;&nbsp;&nbsp;Azimuth of the sun in degrees to the east of north  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1*  
    **units**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Elevation units (overrides scale factor)  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *intl, survey*  
    &nbsp;&nbsp;&nbsp;&nbsp;**intl**: international feet  
    &nbsp;&nbsp;&nbsp;&nbsp;**survey**: survey feet  
    **shades_basename**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Base name for output shades map  
    &nbsp;&nbsp;&nbsp;&nbsp;A base of the name of shades maps for all azimuths. An underscore ('_') and a azimuth will be added to the base name. When empty, no maps will be outputted (although they need to be generated).  
    **pca_shades_basename**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Base name for output PCA shades map  
    &nbsp;&nbsp;&nbsp;&nbsp;A base of the name of PCA shades maps. An underscore ('_') and a azimuth will be added to the base name. When empty, no maps will be outputted (although they need to be generated).  
    **nprocs**=*integer*  
    &nbsp;&nbsp;&nbsp;&nbsp;Number of r.shade.relief processes to run in parallel  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *1-*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1*  
    **--overwrite**  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **input** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of the input elevation raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster  
    **output** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output PCA shaded relief map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster  
    **altitude** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Altitude of the sun in degrees above the horizon  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *0-90*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *30*  
    **nazimuths** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;The number of azimuths (suggested values are 4, 8, 16, 32)  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *8*  
    **zscale** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Factor for exaggerating relief  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1*  
    **scale** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Azimuth of the sun in degrees to the east of north  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1*  
    **units** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Elevation units (overrides scale factor)  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *intl, survey*  
    &nbsp;&nbsp;&nbsp;&nbsp;**intl**: international feet  
    &nbsp;&nbsp;&nbsp;&nbsp;**survey**: survey feet  
    **shades_basename** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Base name for output shades map  
    &nbsp;&nbsp;&nbsp;&nbsp;A base of the name of shades maps for all azimuths. An underscore ('_') and a azimuth will be added to the base name. When empty, no maps will be outputted (although they need to be generated).  
    **pca_shades_basename** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Base name for output PCA shades map  
    &nbsp;&nbsp;&nbsp;&nbsp;A base of the name of PCA shades maps. An underscore ('_') and a azimuth will be added to the base name. When empty, no maps will be outputted (although they need to be generated).  
    **nprocs** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Number of r.shade.relief processes to run in parallel  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *1-*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1*  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **input** : str | np.ndarray, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of the input elevation raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster  
    **output** : str | type(np.ndarray) | type(np.array) | type(gs.array.array), *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output PCA shaded relief map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster  
    **altitude** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Altitude of the sun in degrees above the horizon  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *0-90*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *30*  
    **nazimuths** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;The number of azimuths (suggested values are 4, 8, 16, 32)  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *8*  
    **zscale** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Factor for exaggerating relief  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1*  
    **scale** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Azimuth of the sun in degrees to the east of north  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1*  
    **units** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Elevation units (overrides scale factor)  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *intl, survey*  
    &nbsp;&nbsp;&nbsp;&nbsp;**intl**: international feet  
    &nbsp;&nbsp;&nbsp;&nbsp;**survey**: survey feet  
    **shades_basename** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Base name for output shades map  
    &nbsp;&nbsp;&nbsp;&nbsp;A base of the name of shades maps for all azimuths. An underscore ('_') and a azimuth will be added to the base name. When empty, no maps will be outputted (although they need to be generated).  
    **pca_shades_basename** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Base name for output PCA shades map  
    &nbsp;&nbsp;&nbsp;&nbsp;A base of the name of PCA shades maps. An underscore ('_') and a azimuth will be added to the base name. When empty, no maps will be outputted (although they need to be generated).  
    **nprocs** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Number of r.shade.relief processes to run in parallel  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *1-*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1*  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | np.ndarray | tuple[np.ndarray] | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned. If an array type (e.g., *np.ndarray*) is used for one of the raster outputs, the result will be an array and will have the shape corresponding to the computational region. If an array type is used for more than one raster output, the result will be a tuple of arrays.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

*r.shaded.pca* is a tool for the generation of RGB composite of the
three main components of PCA created from different hill shades (created
by
*[r.relief](https://grass.osgeo.org/grass-stable/manuals/r.relief.html)*).

### Input parameters explanation

Input parameters are the same as for
*[r.relief](https://grass.osgeo.org/grass-stable/manuals/r.relief.html)*
module except for an *azimuth* parameter which is replaced by
*nazimuths* parameter (we need to specify number of different azimuths
rather than one) and for an *nprocs* parameter which adds the
possibility to run the shades creation
(*[r.relief](https://grass.osgeo.org/grass-stable/manuals/r.relief.html)*)
in parallel. However, the speed of
*[i.pca](https://grass.osgeo.org/grass-stable/manuals/i.pca.html)*
limits the overall speed of this module. In order to provide simple
interface, it is not possible to customize principal component analyses
which uses the default settings of the
*[i.pca](https://grass.osgeo.org/grass-stable/manuals/i.pca.html)*
module.

### Output parameters explanation

The the standard output map is an RGB composition of first three
principal components where components are assigned to red, green and
blue colors in this order. If you want to create your own RGB
composition, HIS composition or do another analyses you can specify the
*pca\_shades\_basename* parameter. If this parameter is specified, the
module outputs the PCA maps as created during the process by
*[i.pca](https://grass.osgeo.org/grass-stable/manuals/i.pca.html)*.
Moreover, if you would like to add one of the shades to your
composition, you can specify the *shades\_basename* parameter then the
module will output also the hill shade maps as created during the
process by
*[r.relief](https://grass.osgeo.org/grass-stable/manuals/r.relief.html)*.
One of the shades can be used to subtract the intensity channel in HIS
composition or just as an overlay in your visualization tool.

## EXAMPLE

```sh
# basic example with changed vertical exaggeration
r.shaded.pca input=elevation output=elevation_pca_shaded zscale=100

# example of more complicated settings
# including output shades and principal component maps
r.shaded.pca input=elevation output=elevation_pca_shaded \
 zscale=100 altitude=15  nazimuths=16 nprocs=4 \
 shades_basename=elevation_pca_shaded_shades pca_shades_basename=elevation_pca_shaded_pcs
```

![image-alt](r.shaded.pca.png)

Figure: The RGB composition of first 3 PCA components (output from
*r.shaded.pca* with default values)

## SEE ALSO

*[r.relief](https://grass.osgeo.org/grass-stable/manuals/r.relief.html),
[i.pca](https://grass.osgeo.org/grass-stable/manuals/i.pca.html),
[r.local.relief](r.local.relief.md), [r.skyview](r.skyview.md)*

## REFERENCES

Devereux, B. J., Amable, G. S., & Crow, P. P. (2008). Visualisation of
LiDAR terrain models for archaeological feature detection. Antiquity,
82(316), 470-479.

## AUTHOR

Vaclav Petras, [NCSU OSGeoREL](http://gis.ncsu.edu/osgeorel/)

## SOURCE CODE

Available at: [r.shaded.pca source code](https://github.com/OSGeo/grass-addons/tree/grass8/src/raster/r.shaded.pca)
([history](https://github.com/OSGeo/grass-addons/commits/grass8/src/raster/r.shaded.pca))  
Latest change: Thursday Feb 20 13:02:26 2025 in commit [53de819](https://github.com/OSGeo/grass-addons/commit/53de8196a10ba5a8a9121898ce87861d227137e3)
