---
name: r.soillossbare.py
description: Calculates annual soil loss [t/(ha*a)] for bare soil. Use r.soillosscropland.py afterwards for grown soil.
keywords: [ erosion, raster, bare soil, potential soilloss ]
---

# r.soillossbare.py

Calculates annual soil loss [t/(ha*a)] for bare soil. Use r.soillosscropland.py afterwards for grown soil.

=== "Command line"

    **r.soillossbare.py**
    [**-r**]
    **soillossbare**=*name*
    **flowaccmethod**=*name*
    **elevation**=*name*
    **resolution**=*float*
    **kfactor**=*name*
    **rfactor**=*name*
    [**fieldblock**=*name*]
    [**map**=*name*]
    [**flowacc**=*name*]
    [**constant_m**=*float*]
    [**constant_n**=*float*]
    [**--overwrite**]
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    r.soillossbare.py soillossbare=name flowaccmethod=r.terraflow elevation=name resolution=2 kfactor=name rfactor=name
    ```

=== "Python (grass.script)"

    *grass.script.run_command*("***r.soillossbare.py***",
        **soillossbare**,
        **flowaccmethod**=*"r.terraflow"*,
        **elevation**,
        **resolution**=*"2"*,
        **kfactor**,
        **rfactor**,
        **fieldblock**=*None*,
        **map**=*None*,
        **flowacc**=*None*,
        **constant_m**=*"0.4"*,
        **constant_n**=*"1.3"*,
        **flags**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.run_command("r.soillossbare.py", soillossbare="name", flowaccmethod="r.terraflow", elevation="name", resolution="2", kfactor="name", rfactor="name")
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.r_soillossbare_py*(**soillossbare**,
        **flowaccmethod**=*"r.terraflow"*,
        **elevation**,
        **resolution**=*"2"*,
        **kfactor**,
        **rfactor**,
        **fieldblock**=*None*,
        **map**=*None*,
        **flowacc**=*None*,
        **constant_m**=*"0.4"*,
        **constant_n**=*"1.3"*,
        **flags**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.r_soillossbare_py(soillossbare="name", flowaccmethod="r.terraflow", elevation="name", resolution="2", kfactor="name", rfactor="name")
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **soillossbare**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Output map (soilloss for ungrown soil)  
    **flowaccmethod**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Module for flowaccumulation calculation  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *r.terraflow, r.flow, r.watershed*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *r.terraflow*  
    **elevation**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Digital Elevation Model  
    **resolution**=*float* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Resolution of Digital Elevation Model (x y)  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *2*  
    **kfactor**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;K-Factor (soil erodibility factor)  
    **rfactor**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;R-Factor (rain erosivity factor)  
    **fieldblock**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Fieldblock raster map with NULL/0-values as barrier  
    **map**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Fieldblock vector map  
    **flowacc**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Flowaccumulation raster map (instead of calculation)  
    **constant_m**=*float*  
    &nbsp;&nbsp;&nbsp;&nbsp;RUSLE3D exponential m (0.2..0.6)  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0.4*  
    **constant_n**=*float*  
    &nbsp;&nbsp;&nbsp;&nbsp;RUSLE3D exponential n (1.2..1.6)  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1.3*  
    **-r**  
    &nbsp;&nbsp;&nbsp;&nbsp;Remove intermediate results  
    **--overwrite**  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **soillossbare** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Output map (soilloss for ungrown soil)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster, *name*  
    **flowaccmethod** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Module for flowaccumulation calculation  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *r.terraflow, r.flow, r.watershed*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *r.terraflow*  
    **elevation** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Digital Elevation Model  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **resolution** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Resolution of Digital Elevation Model (x y)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *float*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *2*  
    **kfactor** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;K-Factor (soil erodibility factor)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **rfactor** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;R-Factor (rain erosivity factor)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **fieldblock** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Fieldblock raster map with NULL/0-values as barrier  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **map** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Fieldblock vector map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, vector, *name*  
    **flowacc** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Flowaccumulation raster map (instead of calculation)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **constant_m** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;RUSLE3D exponential m (0.2..0.6)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *float*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0.4*  
    **constant_n** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;RUSLE3D exponential n (1.2..1.6)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *float*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1.3*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *r*  
    &nbsp;&nbsp;&nbsp;&nbsp;**r**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Remove intermediate results  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **soillossbare** : str | type(np.ndarray) | type(np.array) | type(gs.array.array), *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Output map (soilloss for ungrown soil)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster, *name*  
    **flowaccmethod** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Module for flowaccumulation calculation  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *r.terraflow, r.flow, r.watershed*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *r.terraflow*  
    **elevation** : str | np.ndarray, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Digital Elevation Model  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **resolution** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Resolution of Digital Elevation Model (x y)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *float*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *2*  
    **kfactor** : str | np.ndarray, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;K-Factor (soil erodibility factor)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **rfactor** : str | np.ndarray, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;R-Factor (rain erosivity factor)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **fieldblock** : str | np.ndarray, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Fieldblock raster map with NULL/0-values as barrier  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **map** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Fieldblock vector map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, vector, *name*  
    **flowacc** : str | np.ndarray, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Flowaccumulation raster map (instead of calculation)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **constant_m** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;RUSLE3D exponential m (0.2..0.6)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *float*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0.4*  
    **constant_n** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;RUSLE3D exponential n (1.2..1.6)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *float*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1.3*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *r*  
    &nbsp;&nbsp;&nbsp;&nbsp;**r**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Remove intermediate results  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | np.ndarray | tuple[np.ndarray] | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned. If an array type (e.g., *np.ndarray*) is used for one of the raster outputs, the result will be an array and will have the shape corresponding to the computational region. If an array type is used for more than one raster output, the result will be a tuple of arrays.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

*r.soillossbare* calculates the annual soil loss \[t/(ha\*a)\] for bare
soil. Generates a "out\_soillossbare" raster map and intermediate
results.

Also use *r.soillosscropland* afterwards for grown soil.

## REFERENCES

Mitasova H, Mitas L, 1999. Modeling soil detachment with RUSLE 3d using
GIS. <http://fatra.cnr.ncsu.edu/~hmitaso/gmslab/erosion/usle.html>

## SEE ALSO

*[r.soillosscropland](r.soillosscropland.md)*

## AUTHOR

Martin Zbinden

## SOURCE CODE

Available at: [r.soillossbare source code](https://github.com/OSGeo/grass-addons/tree/grass8/src/raster/r.soillossbare)
([history](https://github.com/OSGeo/grass-addons/commits/grass8/src/raster/r.soillossbare))  
Latest change: Thursday Feb 20 13:02:26 2025 in commit [53de819](https://github.com/OSGeo/grass-addons/commit/53de8196a10ba5a8a9121898ce87861d227137e3)
